/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.text.ChunkedWriter;
import org.apache.mahout.text.SequenceFilesFromDirectory;
import org.apache.mahout.text.SequenceFilesFromDirectoryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SequenceFilesFromCsvFilter
extends SequenceFilesFromDirectoryFilter {
    private static final Logger log = LoggerFactory.getLogger(SequenceFilesFromCsvFilter.class);
    private static final Pattern TAB = Pattern.compile("\\t");
    public static final String[] KEY_COLUMN_OPTION = new String[]{"keyColumn", "kcol"};
    public static final String[] VALUE_COLUMN_OPTION = new String[]{"valueColumn", "vcol"};
    private volatile int keyColumn;
    private volatile int valueColumn;

    private SequenceFilesFromCsvFilter() {
    }

    public SequenceFilesFromCsvFilter(Configuration conf, String keyPrefix, Map<String, String> options, ChunkedWriter writer) throws IOException {
        super(conf, keyPrefix, options, writer);
        this.keyColumn = Integer.parseInt(options.get(KEY_COLUMN_OPTION[0]));
        this.valueColumn = Integer.parseInt(options.get(VALUE_COLUMN_OPTION[0]));
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new SequenceFilesFromCsvFilter(), (String[])args);
    }

    @Override
    public void addOptions() {
        super.addOptions();
        this.addOption(KEY_COLUMN_OPTION[0], KEY_COLUMN_OPTION[1], "The key column. Default to 0", "0");
        this.addOption(VALUE_COLUMN_OPTION[0], VALUE_COLUMN_OPTION[1], "The value column. Default to 1", "1");
    }

    @Override
    public Map<String, String> parseOptions() throws IOException {
        Map<String, String> options = super.parseOptions();
        options.put(SequenceFilesFromDirectory.FILE_FILTER_CLASS_OPTION[0], ((Object)((Object)this)).getClass().getName());
        options.put(KEY_COLUMN_OPTION[0], this.getOption(KEY_COLUMN_OPTION[0]));
        options.put(VALUE_COLUMN_OPTION[0], this.getOption(VALUE_COLUMN_OPTION[0]));
        return options;
    }

    @Override
    protected void process(FileStatus fst, Path current) throws IOException {
        if (fst.isDir()) {
            this.fs.listStatus(fst.getPath(), (PathFilter)new SequenceFilesFromCsvFilter(this.conf, this.prefix + "/" + current.getName(), this.options, this.writer));
        } else {
            FSDataInputStream in = this.fs.open(fst.getPath());
            for (String aFit : new FileLineIterable((InputStream)in, this.charset, false)) {
                String[] columns = TAB.split(aFit);
                log.info("key : {}, value : {}", (Object)columns[this.keyColumn], (Object)columns[this.valueColumn]);
                String key = columns[this.keyColumn];
                String value = columns[this.valueColumn];
                this.writer.write(this.prefix + key, value);
            }
        }
    }
}

