/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.text.ChunkedWriter;
import org.apache.mahout.text.PrefixAdditionFilter;
import org.apache.mahout.text.SequenceFilesFromDirectoryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFilesFromDirectory
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(SequenceFilesFromDirectory.class);
    private static final String PREFIX_ADDITION_FILTER = PrefixAdditionFilter.class.getName();
    public static final String[] CHUNK_SIZE_OPTION = new String[]{"chunkSize", "chunk"};
    public static final String[] FILE_FILTER_CLASS_OPTION = new String[]{"fileFilterClass", "filter"};
    public static final String[] KEY_PREFIX_OPTION = new String[]{"keyPrefix", "prefix"};
    public static final String[] CHARSET_OPTION = new String[]{"charset", "c"};

    public void run(Configuration conf, String keyPrefix, Map<String, String> options, Path input, Path output) throws InstantiationException, IllegalAccessException, InvocationTargetException, IOException, NoSuchMethodException, ClassNotFoundException {
        SequenceFilesFromDirectoryFilter pathFilter;
        FileSystem fs = FileSystem.get((Configuration)conf);
        ChunkedWriter writer = new ChunkedWriter(conf, Integer.parseInt(options.get(CHUNK_SIZE_OPTION[0])), output);
        String fileFilterClassName = options.get(FILE_FILTER_CLASS_OPTION[0]);
        if (PrefixAdditionFilter.class.getName().equals(fileFilterClassName)) {
            pathFilter = new PrefixAdditionFilter(conf, keyPrefix, options, writer);
        } else {
            Class<SequenceFilesFromDirectoryFilter> pathFilterClass = Class.forName(fileFilterClassName).asSubclass(SequenceFilesFromDirectoryFilter.class);
            Constructor<SequenceFilesFromDirectoryFilter> constructor = pathFilterClass.getConstructor(Configuration.class, String.class, Map.class, ChunkedWriter.class);
            pathFilter = constructor.newInstance(conf, keyPrefix, options, writer);
        }
        fs.listStatus(input, (PathFilter)pathFilter);
        writer.close();
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new SequenceFilesFromDirectory(), (String[])args);
    }

    public int run(String[] args) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        this.addOptions();
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Map<String, String> options = this.parseOptions();
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        if (this.hasOption("overwrite")) {
            Configuration conf = new Configuration();
            HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        }
        String keyPrefix = this.getOption(KEY_PREFIX_OPTION[0]);
        this.run(this.getConf(), keyPrefix, options, input, output);
        return 0;
    }

    protected void addOptions() {
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        this.addOption(CHUNK_SIZE_OPTION[0], CHUNK_SIZE_OPTION[1], "The chunkSize in MegaBytes. Defaults to 64", "64");
        this.addOption(FILE_FILTER_CLASS_OPTION[0], FILE_FILTER_CLASS_OPTION[1], "The name of the class to use for file parsing. Default: " + PREFIX_ADDITION_FILTER, PREFIX_ADDITION_FILTER);
        this.addOption(KEY_PREFIX_OPTION[0], KEY_PREFIX_OPTION[1], "The prefix to be prepended to the key", "");
        this.addOption(CHARSET_OPTION[0], CHARSET_OPTION[1], "The name of the character encoding of the input files. Default to UTF-8", "UTF-8");
    }

    protected Map<String, String> parseOptions() throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(CHUNK_SIZE_OPTION[0], this.getOption(CHUNK_SIZE_OPTION[0]));
        options.put(FILE_FILTER_CLASS_OPTION[0], this.getOption(FILE_FILTER_CLASS_OPTION[0]));
        options.put(CHARSET_OPTION[0], this.getOption(CHARSET_OPTION[0]));
        return options;
    }
}

