/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.mahout.text.ChunkedWriter;
import org.apache.mahout.text.SequenceFilesFromDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SequenceFilesFromDirectoryFilter
extends SequenceFilesFromDirectory
implements PathFilter {
    private static final Logger log = LoggerFactory.getLogger(SequenceFilesFromDirectoryFilter.class);
    protected final String prefix;
    protected final ChunkedWriter writer;
    protected final Charset charset;
    protected final Configuration conf;
    protected final FileSystem fs;
    protected final Map<String, String> options;

    protected SequenceFilesFromDirectoryFilter() {
        this.prefix = null;
        this.writer = null;
        this.charset = null;
        this.conf = null;
        this.fs = null;
        this.options = null;
    }

    protected SequenceFilesFromDirectoryFilter(Configuration conf, String keyPrefix, Map<String, String> options, ChunkedWriter writer) throws IOException {
        this.conf = conf;
        this.prefix = keyPrefix;
        this.writer = writer;
        this.charset = Charset.forName(options.get(SequenceFilesFromDirectory.CHARSET_OPTION[0]));
        this.fs = FileSystem.get((Configuration)conf);
        this.options = options;
    }

    protected final Map<String, String> getOptions() {
        return this.options;
    }

    public final boolean accept(Path current) {
        log.debug("CURRENT: {}", (Object)current.getName());
        try {
            for (FileStatus fst : this.fs.listStatus(current)) {
                log.debug("CHILD: {}", (Object)fst.getPath().getName());
                this.process(fst, current);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        return false;
    }

    protected abstract void process(FileStatus var1, Path var2) throws IOException;
}

