/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.arff;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.arff.ARFFIterator;
import org.apache.mahout.utils.vectors.arff.ARFFModel;
import org.apache.mahout.utils.vectors.arff.ARFFType;

public class ARFFVectorIterable
implements Iterable<Vector> {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    private final BufferedReader buff;
    private final ARFFModel model;

    public ARFFVectorIterable(File file, ARFFModel model) throws IOException {
        this(file, Charsets.UTF_8, model);
    }

    public ARFFVectorIterable(File file, Charset encoding, ARFFModel model) throws IOException {
        this(Files.newReader((File)file, (Charset)encoding), model);
    }

    public ARFFVectorIterable(String arff, ARFFModel model) throws IOException {
        this(new StringReader(arff), model);
    }

    public ARFFVectorIterable(Reader reader, ARFFModel model) throws IOException {
        String line;
        this.buff = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.model = model;
        int labelNumber = 0;
        while ((line = this.buff.readLine()) != null) {
            line = line.trim();
            String lower = line.toLowerCase(Locale.ENGLISH);
            Integer labelNumInt = labelNumber;
            if (lower.startsWith("%")) continue;
            if (lower.startsWith("@relation")) {
                model.setRelation(line.substring("@relation".length()).trim());
                continue;
            }
            if (lower.startsWith("@attribute")) {
                ARFFType type;
                String label;
                if (lower.contains(ARFFType.NUMERIC.getIndicator())) {
                    label = ARFFType.NUMERIC.getLabel(lower);
                    type = ARFFType.NUMERIC;
                } else if (lower.contains(ARFFType.STRING.getIndicator())) {
                    label = ARFFType.STRING.getLabel(lower);
                    type = ARFFType.STRING;
                } else if (lower.contains(ARFFType.NOMINAL.getIndicator())) {
                    label = ARFFType.NOMINAL.getLabel(lower);
                    type = ARFFType.NOMINAL;
                    int classIdx = lower.indexOf(ARFFType.NOMINAL.getIndicator());
                    String[] classes = COMMA_PATTERN.split(line.substring(classIdx + 1, line.length() - 1));
                    for (int i = 0; i < classes.length; ++i) {
                        model.addNominal(label, classes[i].trim(), i);
                    }
                } else if (lower.contains(ARFFType.DATE.getIndicator())) {
                    label = ARFFType.DATE.getLabel(lower);
                    type = ARFFType.DATE;
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    int idx = lower.indexOf(ARFFType.DATE.getIndicator());
                    String[] split = SPACE_PATTERN.split(line);
                    if (split.length >= 4) {
                        String formStr = line.substring(idx + ARFFType.DATE.getIndicator().length()).trim();
                        if (formStr.startsWith("\"")) {
                            formStr = formStr.substring(1, formStr.length() - 1);
                        }
                        format = new SimpleDateFormat(formStr);
                    }
                    model.addDateFormat(labelNumInt, format);
                } else {
                    throw new UnsupportedOperationException("Invalid attribute: " + line);
                }
                model.addLabel(label, labelNumInt);
                model.addType(labelNumInt, type);
                ++labelNumber;
                continue;
            }
            if (!lower.startsWith("@data")) continue;
            break;
        }
    }

    @Override
    public Iterator<Vector> iterator() {
        return new ARFFIterator(this.buff, this.model);
    }

    public ARFFModel getModel() {
        return this.model;
    }
}

