/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.internal.AbstractMavenPluginDependenciesValidator;
import org.codehaus.plexus.component.repository.ComponentDependency;

@Singleton
@Named
class MavenMixedDependenciesValidator
extends AbstractMavenPluginDependenciesValidator {
    @Inject
    MavenMixedDependenciesValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected void doValidate(MavenSession mavenSession, MojoDescriptor mojoDescriptor) {
        Set mavenVersions = mojoDescriptor.getPluginDescriptor().getDependencies().stream().filter(d -> "org.apache.maven".equals(d.getGroupId())).filter(d -> !this.expectedProvidedScopeExclusions.contains(d.getGroupId() + ":" + d.getArtifactId())).map(ComponentDependency::getVersion).collect(Collectors.toSet());
        if (mavenVersions.size() > 1) {
            this.pluginValidationManager.reportPluginValidationIssue(mavenSession, mojoDescriptor, "Plugin mixes multiple Maven versions: " + mavenVersions);
        }
    }
}

