/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.internal.AbstractMavenPluginDependenciesValidator;

@Singleton
@Named
class MavenScopeDependenciesValidator
extends AbstractMavenPluginDependenciesValidator {
    @Inject
    MavenScopeDependenciesValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected void doValidate(MavenSession mavenSession, MojoDescriptor mojoDescriptor) {
        Set mavenArtifacts = mojoDescriptor.getPluginDescriptor().getDependencies().stream().filter(d -> "org.apache.maven".equals(d.getGroupId())).filter(d -> !this.expectedProvidedScopeExclusions.contains(d.getGroupId() + ":" + d.getArtifactId())).filter(d -> d.getVersion().startsWith("3.")).map(d -> d.getGroupId() + ":" + d.getArtifactId() + ":" + d.getVersion()).collect(Collectors.toSet());
        if (!mavenArtifacts.isEmpty()) {
            this.pluginValidationManager.reportPluginValidationIssue(mavenSession, mojoDescriptor, "Plugin should declare these Maven artifacts in `provided` scope: " + mavenArtifacts);
        }
    }
}

