/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.InputLocation;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class DefaultPluginValidationManager
extends AbstractMavenLifecycleParticipant
implements PluginValidationManager {
    private static final String ISSUES_KEY = DefaultPluginValidationManager.class.getName() + ".issues";
    private static final String MAVEN_PLUGIN_VALIDATION_KEY = "maven.plugin.validation";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void afterSessionEnd(MavenSession session) {
        this.reportSessionCollectedValidationIssues(session);
    }

    private ValidationLevel validationLevel(RepositorySystemSession session) {
        String level = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{MAVEN_PLUGIN_VALIDATION_KEY});
        if (level == null || level.isEmpty()) {
            return ValidationLevel.DEFAULT;
        }
        try {
            return ValidationLevel.valueOf(level.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Invalid value specified for property {}: '{}'. Supported values are (case insensitive): {}", new Object[]{MAVEN_PLUGIN_VALIDATION_KEY, level, Arrays.toString((Object[])ValidationLevel.values())});
            return ValidationLevel.DEFAULT;
        }
    }

    private String pluginKey(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    private String pluginKey(MojoDescriptor mojoDescriptor) {
        PluginDescriptor pd = mojoDescriptor.getPluginDescriptor();
        return this.pluginKey(pd.getGroupId(), pd.getArtifactId(), pd.getVersion());
    }

    private String pluginKey(Artifact pluginArtifact) {
        return this.pluginKey(pluginArtifact.getGroupId(), pluginArtifact.getArtifactId(), pluginArtifact.getVersion());
    }

    @Override
    public void reportPluginValidationIssue(RepositorySystemSession session, Artifact pluginArtifact, String issue) {
        String pluginKey = this.pluginKey(pluginArtifact);
        PluginValidationIssues pluginIssues = this.pluginIssues(session).computeIfAbsent(pluginKey, k -> new PluginValidationIssues());
        pluginIssues.reportPluginIssue(null, null, issue);
    }

    @Override
    public void reportPluginValidationIssue(MavenSession mavenSession, MojoDescriptor mojoDescriptor, String issue) {
        String pluginKey = this.pluginKey(mojoDescriptor);
        PluginValidationIssues pluginIssues = this.pluginIssues(mavenSession.getRepositorySession()).computeIfAbsent(pluginKey, k -> new PluginValidationIssues());
        pluginIssues.reportPluginIssue(this.pluginDeclaration(mavenSession, mojoDescriptor), this.pluginOccurrence(mavenSession), issue);
    }

    @Override
    public void reportPluginMojoValidationIssue(MavenSession mavenSession, MojoDescriptor mojoDescriptor, Class<?> mojoClass, String issue) {
        String pluginKey = this.pluginKey(mojoDescriptor);
        PluginValidationIssues pluginIssues = this.pluginIssues(mavenSession.getRepositorySession()).computeIfAbsent(pluginKey, k -> new PluginValidationIssues());
        pluginIssues.reportPluginMojoIssue(this.pluginDeclaration(mavenSession, mojoDescriptor), this.pluginOccurrence(mavenSession), this.mojoInfo(mojoDescriptor, mojoClass), issue);
    }

    private void reportSessionCollectedValidationIssues(MavenSession mavenSession) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        ValidationLevel validationLevel = this.validationLevel(mavenSession.getRepositorySession());
        ConcurrentHashMap<String, PluginValidationIssues> issuesMap = this.pluginIssues(mavenSession.getRepositorySession());
        if (!issuesMap.isEmpty()) {
            this.logger.warn("");
            this.logger.warn("Plugin validation issues were detected in {} plugin(s)", (Object)issuesMap.size());
            this.logger.warn("");
            if (validationLevel == ValidationLevel.BRIEF) {
                return;
            }
            for (Map.Entry<String, PluginValidationIssues> entry : issuesMap.entrySet()) {
                this.logger.warn(" * {}", (Object)entry.getKey());
                if (validationLevel != ValidationLevel.VERBOSE) continue;
                PluginValidationIssues issues = entry.getValue();
                if (!issues.pluginDeclarations.isEmpty()) {
                    this.logger.warn("  Declared at location(s):");
                    for (String pluginDeclaration : issues.pluginDeclarations) {
                        this.logger.warn("   * {}", (Object)pluginDeclaration);
                    }
                }
                if (!issues.pluginOccurrences.isEmpty()) {
                    this.logger.warn("  Used in module(s):");
                    for (String pluginOccurrence : issues.pluginOccurrences) {
                        this.logger.warn("   * {}", (Object)pluginOccurrence);
                    }
                }
                if (!issues.pluginIssues.isEmpty()) {
                    this.logger.warn("  Plugin issue(s):");
                    for (String pluginIssue : issues.pluginIssues) {
                        this.logger.warn("   * {}", (Object)pluginIssue);
                    }
                }
                if (!issues.mojoIssues.isEmpty()) {
                    this.logger.warn("  Mojo issue(s):");
                    for (String mojoInfo : issues.mojoIssues.keySet()) {
                        this.logger.warn("   * Mojo {}", (Object)mojoInfo);
                        for (String mojoIssue : (LinkedHashSet)issues.mojoIssues.get(mojoInfo)) {
                            this.logger.warn("     - {}", (Object)mojoIssue);
                        }
                    }
                }
                this.logger.warn("");
            }
            this.logger.warn("");
            if (validationLevel == ValidationLevel.VERBOSE) {
                this.logger.warn("Fix reported issues by adjusting plugin configuration or by upgrading above listed plugins. If no upgrade available, please notify plugin maintainers about reported issues.");
            }
            this.logger.warn("For more or less details, use 'maven.plugin.validation' property with one of the values (case insensitive): {}", (Object)Arrays.toString((Object[])ValidationLevel.values()));
            this.logger.warn("");
        }
    }

    private String pluginDeclaration(MavenSession mavenSession, MojoDescriptor mojoDescriptor) {
        InputLocation inputLocation = mojoDescriptor.getPluginDescriptor().getPlugin().getLocation((Object)"");
        if (inputLocation != null && inputLocation.getSource() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(inputLocation.getSource().getModelId());
            String location = inputLocation.getSource().getLocation();
            if (location != null) {
                if (location.contains("://")) {
                    stringBuilder.append(" (").append(location).append(")");
                } else {
                    File rootBasedir = mavenSession.getTopLevelProject().getBasedir();
                    File locationFile = new File(location);
                    if (location.startsWith(rootBasedir.getPath())) {
                        stringBuilder.append(" (").append(rootBasedir.toPath().relativize(locationFile.toPath())).append(")");
                    } else {
                        stringBuilder.append(" (").append(location).append(")");
                    }
                }
            }
            stringBuilder.append(" @ line ").append(inputLocation.getLineNumber());
            return stringBuilder.toString();
        }
        return "unknown";
    }

    private String pluginOccurrence(MavenSession mavenSession) {
        MavenProject prj = mavenSession.getCurrentProject();
        String result = prj.getGroupId() + ":" + prj.getArtifactId() + ":" + prj.getVersion();
        File currentPom = prj.getFile();
        if (currentPom != null) {
            File rootBasedir = mavenSession.getTopLevelProject().getBasedir();
            result = result + " (" + rootBasedir.toPath().relativize(currentPom.toPath()) + ")";
        }
        return result;
    }

    private String mojoInfo(MojoDescriptor mojoDescriptor, Class<?> mojoClass) {
        return mojoDescriptor.getFullGoalName() + " (" + mojoClass.getName() + ")";
    }

    private ConcurrentHashMap<String, PluginValidationIssues> pluginIssues(RepositorySystemSession session) {
        return (ConcurrentHashMap)session.getData().computeIfAbsent((Object)ISSUES_KEY, ConcurrentHashMap::new);
    }

    private static enum ValidationLevel {
        BRIEF,
        DEFAULT,
        VERBOSE;

    }

    private static class PluginValidationIssues {
        private final LinkedHashSet<String> pluginDeclarations = new LinkedHashSet();
        private final LinkedHashSet<String> pluginOccurrences = new LinkedHashSet();
        private final LinkedHashSet<String> pluginIssues = new LinkedHashSet();
        private final LinkedHashMap<String, LinkedHashSet<String>> mojoIssues = new LinkedHashMap();

        private PluginValidationIssues() {
        }

        private synchronized void reportPluginIssue(String pluginDeclaration, String pluginOccurrence, String issue) {
            if (pluginDeclaration != null) {
                this.pluginDeclarations.add(pluginDeclaration);
            }
            if (pluginOccurrence != null) {
                this.pluginOccurrences.add(pluginOccurrence);
            }
            this.pluginIssues.add(issue);
        }

        private synchronized void reportPluginMojoIssue(String pluginDeclaration, String pluginOccurrence, String mojoInfo, String issue) {
            if (pluginDeclaration != null) {
                this.pluginDeclarations.add(pluginDeclaration);
            }
            if (pluginOccurrence != null) {
                this.pluginOccurrences.add(pluginOccurrence);
            }
            this.mojoIssues.computeIfAbsent(mojoInfo, k -> new LinkedHashSet()).add(issue);
        }
    }
}

