/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.lifecycle.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.xml.Dom;
import org.apache.maven.plugin.lifecycle.Execution;
import org.apache.maven.plugin.lifecycle.Lifecycle;
import org.apache.maven.plugin.lifecycle.LifecycleConfiguration;
import org.apache.maven.plugin.lifecycle.Phase;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

@Generated
public class LifecycleMappingsXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, LifecycleConfiguration lifecycleConfiguration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(lifecycleConfiguration.getModelEncoding(), null);
        this.writeLifecycleConfiguration("lifecycles", lifecycleConfiguration, (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, LifecycleConfiguration lifecycleConfiguration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, lifecycleConfiguration.getModelEncoding());
        serializer.startDocument(lifecycleConfiguration.getModelEncoding(), null);
        this.writeLifecycleConfiguration("lifecycles", lifecycleConfiguration, (XmlSerializer)serializer);
        serializer.endDocument();
    }

    protected void writeDomToSerializer(Dom dom, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, dom.getName());
        for (Map.Entry attribute : dom.getAttributes().entrySet()) {
            serializer.attribute(NAMESPACE, (String)attribute.getKey(), (String)attribute.getValue());
        }
        for (Dom aChild : dom.getChildren()) {
            this.writeDomToSerializer(aChild, serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.text(value);
        }
        serializer.endTag(NAMESPACE, dom.getName());
    }

    private void writeLifecycleConfiguration(String tagName, LifecycleConfiguration lifecycleConfiguration, XmlSerializer serializer) throws IOException {
        if (lifecycleConfiguration != null) {
            if (this.fileComment != null) {
                serializer.comment(this.fileComment);
            }
            serializer.setPrefix("", "http://maven.apache.org/POM/4.0.0");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.startTag(NAMESPACE, tagName);
            serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd");
            this.writeList("lifecycles", true, lifecycleConfiguration.getLifecycles(), serializer, t -> this.writeLifecycle("lifecycle", (Lifecycle)t, serializer));
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeLifecycle(String tagName, Lifecycle lifecycle, XmlSerializer serializer) throws IOException {
        if (lifecycle != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("id", null, lifecycle.getId(), serializer);
            this.writeList("phases", false, lifecycle.getPhases(), serializer, t -> this.writePhase("phase", (Phase)t, serializer));
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writePhase(String tagName, Phase phase, XmlSerializer serializer) throws IOException {
        if (phase != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeTag("id", null, phase.getId(), serializer);
            this.writeList("executions", false, phase.getExecutions(), serializer, t -> this.writeExecution("execution", (Execution)t, serializer));
            this.writeDom(phase.getConfiguration(), serializer);
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeExecution(String tagName, Execution execution, XmlSerializer serializer) throws IOException {
        if (execution != null) {
            serializer.startTag(NAMESPACE, tagName);
            this.writeDom(execution.getConfiguration(), serializer);
            this.writeList("goals", execution.getGoals(), serializer, t -> this.writeTag("goal", "new java.util.ArrayList/*<String>*/()", (String)t, serializer));
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private <T> void writeList(String tagName, List<T> list, XmlSerializer serializer, ElementWriter<T> writer) throws IOException {
        this.writeList(tagName, false, list, serializer, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XmlSerializer serializer, ElementWriter<T> writer) throws IOException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.startTag(NAMESPACE, tagName);
            }
            for (T t : list) {
                writer.write(t);
            }
            if (!flat) {
                serializer.endTag(NAMESPACE, tagName);
            }
        }
    }

    private <T> void writeProperties(String tagName, Properties props, XmlSerializer serializer) throws IOException {
        if (props != null && !props.isEmpty()) {
            serializer.startTag(NAMESPACE, tagName);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                this.writeTag(entry.getKey().toString(), null, entry.getValue().toString(), serializer);
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeDom(Dom dom, XmlSerializer serializer) throws IOException {
        if (dom != null) {
            serializer.startTag(NAMESPACE, dom.getName());
            for (Map.Entry attr : dom.getAttributes().entrySet()) {
                serializer.attribute(NAMESPACE, (String)attr.getKey(), (String)attr.getValue());
            }
            for (Dom child : dom.getChildren()) {
                this.writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.text(value);
            }
            serializer.endTag(NAMESPACE, dom.getName());
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XmlSerializer serializer) throws IOException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.startTag(NAMESPACE, tagName).text(value).endTag(NAMESPACE, tagName);
        }
    }

    private void writeAttr(String attrName, String value, XmlSerializer serializer) throws IOException {
        if (value != null) {
            serializer.attribute(NAMESPACE, attrName, value);
        }
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException;
    }
}

