/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.xml.Dom;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PluginExecution
extends ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String id;
    final String phase;
    final int priority;
    final List<String> goals;
    final InputLocation idLocation;
    final InputLocation phaseLocation;
    final InputLocation priorityLocation;
    final InputLocation goalsLocation;
    public static final String DEFAULT_EXECUTION_ID = "default";

    PluginExecution(String inherited, Dom configuration, String id, String phase, int priority, Collection<String> goals, Map<Object, InputLocation> locations, InputLocation location, InputLocation inheritedLocation, InputLocation configurationLocation, InputLocation idLocation, InputLocation phaseLocation, InputLocation priorityLocation, InputLocation goalsLocation) {
        super(inherited, configuration, locations, location, inheritedLocation, configurationLocation);
        this.id = id;
        this.phase = phase;
        this.priority = priority;
        this.goals = ImmutableCollections.copy(goals);
        this.idLocation = idLocation;
        this.phaseLocation = phaseLocation;
        this.priorityLocation = priorityLocation;
        this.goalsLocation = goalsLocation;
    }

    public String getId() {
        return this.id;
    }

    public String getPhase() {
        return this.phase;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nonnull
    public List<String> getGoals() {
        return this.goals;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "id": {
                    return this.idLocation;
                }
                case "phase": {
                    return this.phaseLocation;
                }
                case "priority": {
                    return this.priorityLocation;
                }
                case "goals": {
                    return this.goalsLocation;
                }
            }
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return PluginExecution.newBuilder(this);
    }

    @Override
    @Nonnull
    public PluginExecution withInherited(String inherited) {
        return this.with().inherited(inherited).build();
    }

    @Override
    @Nonnull
    public PluginExecution withConfiguration(Dom configuration) {
        return this.with().configuration(configuration).build();
    }

    @Nonnull
    public PluginExecution withId(String id) {
        return this.with().id(id).build();
    }

    @Nonnull
    public PluginExecution withPhase(String phase) {
        return this.with().phase(phase).build();
    }

    @Nonnull
    public PluginExecution withPriority(int priority) {
        return this.with().priority(priority).build();
    }

    @Nonnull
    public PluginExecution withGoals(Collection<String> goals) {
        return this.with().goals(goals).build();
    }

    @Nonnull
    public static PluginExecution newInstance() {
        return PluginExecution.newInstance(true);
    }

    @Nonnull
    public static PluginExecution newInstance(boolean withDefaults) {
        return PluginExecution.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PluginExecution.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PluginExecution from) {
        return PluginExecution.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PluginExecution from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return this.getId();
    }

    @NotThreadSafe
    public static class Builder
    extends ConfigurationContainer.Builder {
        PluginExecution base;
        String id;
        String phase;
        Integer priority;
        Collection<String> goals;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = PluginExecution.DEFAULT_EXECUTION_ID;
                this.priority = 0;
            }
        }

        Builder(PluginExecution base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.phase = base.phase;
                this.priority = base.priority;
                this.goals = base.goals;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Override
        @Nonnull
        public Builder configuration(Dom configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder phase(String phase) {
            this.phase = phase;
            return this;
        }

        @Nonnull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Nonnull
        public Builder goals(Collection<String> goals) {
            this.goals = goals;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public PluginExecution build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration || this.id != null && this.id != this.base.id || this.phase != null && this.phase != this.base.phase || this.priority != null && this.priority != this.base.priority || this.goals != null && this.goals != this.base.goals)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation inheritedLocation = null;
            InputLocation configurationLocation = null;
            InputLocation idLocation = null;
            InputLocation phaseLocation = null;
            InputLocation priorityLocation = null;
            InputLocation goalsLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                inheritedLocation = (InputLocation)locations.remove("inherited");
                configurationLocation = (InputLocation)locations.remove("configuration");
                idLocation = (InputLocation)locations.remove("id");
                phaseLocation = (InputLocation)locations.remove("phase");
                priorityLocation = (InputLocation)locations.remove("priority");
                goalsLocation = (InputLocation)locations.remove("goals");
            }
            return new PluginExecution(this.inherited != null ? this.inherited : (this.base != null ? this.base.inherited : null), (Dom)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)), this.id != null ? this.id : (this.base != null ? this.base.id : null), this.phase != null ? this.phase : (this.base != null ? this.base.phase : null), this.priority != null ? this.priority : (this.base != null ? this.base.priority : 0), this.goals != null ? this.goals : (this.base != null ? this.base.goals : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), inheritedLocation != null ? inheritedLocation : (this.base != null ? this.base.inheritedLocation : null), configurationLocation != null ? configurationLocation : (this.base != null ? this.base.configurationLocation : null), idLocation != null ? idLocation : (this.base != null ? this.base.idLocation : null), phaseLocation != null ? phaseLocation : (this.base != null ? this.base.phaseLocation : null), priorityLocation != null ? priorityLocation : (this.base != null ? this.base.priorityLocation : null), goalsLocation != null ? goalsLocation : (this.base != null ? this.base.goalsLocation : null));
        }
    }
}

