/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.ReportSet;
import org.apache.maven.api.xml.Dom;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ReportPlugin
extends ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final List<ReportSet> reportSets;
    final InputLocation groupIdLocation;
    final InputLocation artifactIdLocation;
    final InputLocation versionLocation;
    final InputLocation reportSetsLocation;
    private Map<String, ReportSet> reportSetMap = null;

    ReportPlugin(String inherited, Dom configuration, String groupId, String artifactId, String version, Collection<ReportSet> reportSets, Map<Object, InputLocation> locations, InputLocation location, InputLocation inheritedLocation, InputLocation configurationLocation, InputLocation groupIdLocation, InputLocation artifactIdLocation, InputLocation versionLocation, InputLocation reportSetsLocation) {
        super(inherited, configuration, locations, location, inheritedLocation, configurationLocation);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.reportSets = ImmutableCollections.copy(reportSets);
        this.groupIdLocation = groupIdLocation;
        this.artifactIdLocation = artifactIdLocation;
        this.versionLocation = versionLocation;
        this.reportSetsLocation = reportSetsLocation;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @Nonnull
    public List<ReportSet> getReportSets() {
        return this.reportSets;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "groupId": {
                    return this.groupIdLocation;
                }
                case "artifactId": {
                    return this.artifactIdLocation;
                }
                case "version": {
                    return this.versionLocation;
                }
                case "reportSets": {
                    return this.reportSetsLocation;
                }
            }
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return ReportPlugin.newBuilder(this);
    }

    @Override
    @Nonnull
    public ReportPlugin withInherited(String inherited) {
        return this.with().inherited(inherited).build();
    }

    @Override
    @Nonnull
    public ReportPlugin withConfiguration(Dom configuration) {
        return this.with().configuration(configuration).build();
    }

    @Nonnull
    public ReportPlugin withGroupId(String groupId) {
        return this.with().groupId(groupId).build();
    }

    @Nonnull
    public ReportPlugin withArtifactId(String artifactId) {
        return this.with().artifactId(artifactId).build();
    }

    @Nonnull
    public ReportPlugin withVersion(String version) {
        return this.with().version(version).build();
    }

    @Nonnull
    public ReportPlugin withReportSets(Collection<ReportSet> reportSets) {
        return this.with().reportSets(reportSets).build();
    }

    @Nonnull
    public static ReportPlugin newInstance() {
        return ReportPlugin.newInstance(true);
    }

    @Nonnull
    public static ReportPlugin newInstance(boolean withDefaults) {
        return ReportPlugin.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ReportPlugin.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ReportPlugin from) {
        return ReportPlugin.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ReportPlugin from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public void flushReportSetMap() {
        this.reportSetMap = null;
    }

    public Map<String, ReportSet> getReportSetsAsMap() {
        if (this.reportSetMap == null) {
            this.reportSetMap = new LinkedHashMap<String, ReportSet>();
            if (this.getReportSets() != null) {
                for (ReportSet reportSet : this.getReportSets()) {
                    this.reportSetMap.put(reportSet.getId(), reportSet);
                }
            }
        }
        return this.reportSetMap;
    }

    public String getKey() {
        return ReportPlugin.constructKey(this.getGroupId(), this.getArtifactId());
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    @NotThreadSafe
    public static class Builder
    extends ConfigurationContainer.Builder {
        ReportPlugin base;
        String groupId;
        String artifactId;
        String version;
        Collection<ReportSet> reportSets;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.groupId = "org.apache.maven.plugins";
            }
        }

        Builder(ReportPlugin base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.reportSets = base.reportSets;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Override
        @Nonnull
        public Builder configuration(Dom configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder reportSets(Collection<ReportSet> reportSets) {
            this.reportSets = reportSets;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public ReportPlugin build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.reportSets != null && this.reportSets != this.base.reportSets)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation inheritedLocation = null;
            InputLocation configurationLocation = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            InputLocation versionLocation = null;
            InputLocation reportSetsLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                inheritedLocation = (InputLocation)locations.remove("inherited");
                configurationLocation = (InputLocation)locations.remove("configuration");
                groupIdLocation = (InputLocation)locations.remove("groupId");
                artifactIdLocation = (InputLocation)locations.remove("artifactId");
                versionLocation = (InputLocation)locations.remove("version");
                reportSetsLocation = (InputLocation)locations.remove("reportSets");
            }
            return new ReportPlugin(this.inherited != null ? this.inherited : (this.base != null ? this.base.inherited : null), (Dom)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)), this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.reportSets != null ? this.reportSets : (this.base != null ? this.base.reportSets : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), inheritedLocation != null ? inheritedLocation : (this.base != null ? this.base.inheritedLocation : null), configurationLocation != null ? configurationLocation : (this.base != null ? this.base.configurationLocation : null), groupIdLocation != null ? groupIdLocation : (this.base != null ? this.base.groupIdLocation : null), artifactIdLocation != null ? artifactIdLocation : (this.base != null ? this.base.artifactIdLocation : null), versionLocation != null ? versionLocation : (this.base != null ? this.base.versionLocation : null), reportSetsLocation != null ? reportSetsLocation : (this.base != null ? this.base.reportSetsLocation : null));
        }
    }
}

