/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class RepositoryPolicy
implements Serializable,
InputLocationTracker {
    final String enabled;
    final String updatePolicy;
    final String checksumPolicy;
    final InputLocation location;
    final InputLocation enabledLocation;
    final InputLocation updatePolicyLocation;
    final InputLocation checksumPolicyLocation;
    final Map<Object, InputLocation> locations;

    RepositoryPolicy(String enabled, String updatePolicy, String checksumPolicy, Map<Object, InputLocation> locations, InputLocation location, InputLocation enabledLocation, InputLocation updatePolicyLocation, InputLocation checksumPolicyLocation) {
        this.enabled = enabled;
        this.updatePolicy = updatePolicy;
        this.checksumPolicy = checksumPolicy;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.enabledLocation = enabledLocation;
        this.updatePolicyLocation = updatePolicyLocation;
        this.checksumPolicyLocation = checksumPolicyLocation;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "enabled": {
                    return this.enabledLocation;
                }
                case "updatePolicy": {
                    return this.updatePolicyLocation;
                }
                case "checksumPolicy": {
                    return this.checksumPolicyLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return RepositoryPolicy.newBuilder(this);
    }

    @Nonnull
    public RepositoryPolicy withEnabled(String enabled) {
        return this.with().enabled(enabled).build();
    }

    @Nonnull
    public RepositoryPolicy withUpdatePolicy(String updatePolicy) {
        return this.with().updatePolicy(updatePolicy).build();
    }

    @Nonnull
    public RepositoryPolicy withChecksumPolicy(String checksumPolicy) {
        return this.with().checksumPolicy(checksumPolicy).build();
    }

    @Nonnull
    public static RepositoryPolicy newInstance() {
        return RepositoryPolicy.newInstance(true);
    }

    @Nonnull
    public static RepositoryPolicy newInstance(boolean withDefaults) {
        return RepositoryPolicy.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return RepositoryPolicy.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryPolicy from) {
        return RepositoryPolicy.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryPolicy from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isEnabled() {
        return this.getEnabled() != null ? Boolean.parseBoolean(this.getEnabled()) : true;
    }

    @NotThreadSafe
    public static class Builder {
        RepositoryPolicy base;
        String enabled;
        String updatePolicy;
        String checksumPolicy;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(RepositoryPolicy base, boolean forceCopy) {
            if (forceCopy) {
                this.enabled = base.enabled;
                this.updatePolicy = base.updatePolicy;
                this.checksumPolicy = base.checksumPolicy;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder enabled(String enabled) {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Builder updatePolicy(String updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        @Nonnull
        public Builder checksumPolicy(String checksumPolicy) {
            this.checksumPolicy = checksumPolicy;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public RepositoryPolicy build() {
            if (!(this.base == null || this.enabled != null && this.enabled != this.base.enabled || this.updatePolicy != null && this.updatePolicy != this.base.updatePolicy || this.checksumPolicy != null && this.checksumPolicy != this.base.checksumPolicy)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation enabledLocation = null;
            InputLocation updatePolicyLocation = null;
            InputLocation checksumPolicyLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                enabledLocation = locations.remove("enabled");
                updatePolicyLocation = locations.remove("updatePolicy");
                checksumPolicyLocation = locations.remove("checksumPolicy");
            }
            return new RepositoryPolicy(this.enabled != null ? this.enabled : (this.base != null ? this.base.enabled : null), this.updatePolicy != null ? this.updatePolicy : (this.base != null ? this.base.updatePolicy : null), this.checksumPolicy != null ? this.checksumPolicy : (this.base != null ? this.base.checksumPolicy : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), enabledLocation != null ? enabledLocation : (this.base != null ? this.base.enabledLocation : null), updatePolicyLocation != null ? updatePolicyLocation : (this.base != null ? this.base.updatePolicyLocation : null), checksumPolicyLocation != null ? checksumPolicyLocation : (this.base != null ? this.base.checksumPolicyLocation : null));
        }
    }
}

