/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;

@Named
@Singleton
public class DefaultPluginDescriptorCache
implements PluginDescriptorCache {
    private Map<PluginDescriptorCache.Key, PluginDescriptor> descriptors = new HashMap<PluginDescriptorCache.Key, PluginDescriptor>(128);

    @Override
    public void flush() {
        this.descriptors.clear();
    }

    @Override
    public PluginDescriptorCache.Key createKey(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) {
        return new CacheKey(plugin, repositories, session);
    }

    @Override
    public PluginDescriptor get(PluginDescriptorCache.Key cacheKey) {
        return DefaultPluginDescriptorCache.clone(this.descriptors.get(cacheKey));
    }

    @Override
    public void put(PluginDescriptorCache.Key cacheKey, PluginDescriptor pluginDescriptor) {
        this.descriptors.put(cacheKey, DefaultPluginDescriptorCache.clone(pluginDescriptor));
    }

    protected static PluginDescriptor clone(PluginDescriptor original) {
        PluginDescriptor clone = null;
        if (original != null) {
            clone = new PluginDescriptor();
            clone.setGroupId(original.getGroupId());
            clone.setArtifactId(original.getArtifactId());
            clone.setVersion(original.getVersion());
            clone.setGoalPrefix(original.getGoalPrefix());
            clone.setInheritedByDefault(original.isInheritedByDefault());
            clone.setName(original.getName());
            clone.setDescription(original.getDescription());
            clone.setRequiredMavenVersion(original.getRequiredMavenVersion());
            clone.setPluginArtifact(ArtifactUtils.copyArtifactSafe((Artifact)original.getPluginArtifact()));
            clone.setComponents(DefaultPluginDescriptorCache.clone(original.getMojos(), clone));
            clone.setId(original.getId());
            clone.setIsolatedRealm(original.isIsolatedRealm());
            clone.setSource(original.getSource());
            clone.setDependencies(original.getDependencies());
        }
        return clone;
    }

    private static List<ComponentDescriptor<?>> clone(List<MojoDescriptor> mojos, PluginDescriptor pluginDescriptor) {
        ArrayList<MojoDescriptor> clones = null;
        if (mojos != null) {
            clones = new ArrayList<MojoDescriptor>(mojos.size());
            for (MojoDescriptor mojo : mojos) {
                MojoDescriptor clone = mojo.clone();
                clone.setPluginDescriptor(pluginDescriptor);
                clones.add(clone);
            }
        }
        return clones;
    }

    private static final class CacheKey
    implements PluginDescriptorCache.Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final int hashCode;

        CacheKey(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) {
            this.groupId = plugin.getGroupId();
            this.artifactId = plugin.getArtifactId();
            this.version = plugin.getVersion();
            this.workspace = RepositoryUtils.getWorkspace(session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            int hash = 17;
            hash = hash * 31 + this.groupId.hashCode();
            hash = hash * 31 + this.artifactId.hashCode();
            hash = hash * 31 + this.version.hashCode();
            hash = hash * 31 + CacheKey.hash(this.workspace);
            hash = hash * 31 + this.localRepo.hashCode();
            this.hashCode = hash = hash * 31 + RepositoryUtils.repositoriesHashCode(repositories);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)obj;
            return Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.version, that.version) && Objects.equals(this.localRepo, that.localRepo) && Objects.equals(this.workspace, that.workspace) && RepositoryUtils.repositoriesEquals(this.repositories, that.repositories);
        }

        public String toString() {
            return this.groupId + ':' + this.artifactId + ':' + this.version;
        }

        private static int hash(Object obj) {
            return obj != null ? obj.hashCode() : 0;
        }
    }
}

