/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.building;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import org.apache.maven.building.Source;

public class UrlSource
implements Source {
    private final URL url;
    private final int hashCode;

    public UrlSource(URL url) {
        this.url = Objects.requireNonNull(url, "url cannot be null");
        this.hashCode = Objects.hashCode(url);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    @Override
    public String getLocation() {
        return this.url.toString();
    }

    public URL getUrl() {
        return this.url;
    }

    public String toString() {
        return this.getLocation();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!UrlSource.class.equals(obj.getClass())) {
            return false;
        }
        UrlSource other = (UrlSource)obj;
        return this.url.equals(other.url);
    }
}

