/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.Optional;
import org.apache.maven.logwrapper.LogLevelRecorder;
import org.apache.maven.logwrapper.MavenSlf4jWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.impl.MavenFailOnSeverityLogger;
import org.slf4j.impl.MavenSimpleLogger;
import org.slf4j.impl.SimpleLoggerFactory;

public class MavenLoggerFactory
extends SimpleLoggerFactory
implements MavenSlf4jWrapperFactory {
    private LogLevelRecorder logLevelRecorder = null;

    public void setLogLevelRecorder(LogLevelRecorder logLevelRecorder) {
        if (this.logLevelRecorder != null) {
            throw new IllegalStateException("LogLevelRecorder has already been set.");
        }
        this.logLevelRecorder = logLevelRecorder;
    }

    public Optional<LogLevelRecorder> getLogLevelRecorder() {
        return Optional.ofNullable(this.logLevelRecorder);
    }

    @Override
    public Logger getLogger(String name) {
        Logger simpleLogger = (Logger)this.loggerMap.get(name);
        if (simpleLogger != null) {
            return simpleLogger;
        }
        Logger newInstance = this.getNewLoggingInstance(name);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    private Logger getNewLoggingInstance(String name) {
        if (this.logLevelRecorder == null) {
            return new MavenSimpleLogger(name);
        }
        return new MavenFailOnSeverityLogger(name, this.logLevelRecorder);
    }
}

