/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;

@Experimental
@Immutable
public interface DependencyCollectorRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public Optional<Artifact> getRootArtifact();

    @Nonnull
    public Optional<DependencyCoordinate> getRoot();

    @Nonnull
    public Collection<DependencyCoordinate> getDependencies();

    @Nonnull
    public Collection<DependencyCoordinate> getManagedDependencies();

    public boolean getVerbose();

    @Nonnull
    public static DependencyCollectorRequest build(@Nonnull Session session, Artifact root) {
        return DependencyCollectorRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).rootArtifact(BaseRequest.nonNull(root, "root cannot be null")).build();
    }

    @Nonnull
    public static DependencyCollectorRequest build(@Nonnull Session session, @Nonnull DependencyCoordinate root) {
        return DependencyCollectorRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).root(BaseRequest.nonNull(root, "root cannot be null")).build();
    }

    @Nonnull
    public static DependencyCollectorRequest build(@Nonnull Session session, @Nonnull Project project) {
        return DependencyCollectorRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).rootArtifact(BaseRequest.nonNull(project, "project cannot be null").getArtifact()).dependencies(project.getDependencies()).managedDependencies(project.getManagedDependencies()).build();
    }

    @Nonnull
    public static DependencyCollectorRequestBuilder builder() {
        return new DependencyCollectorRequestBuilder();
    }

    @NotThreadSafe
    public static class DependencyCollectorRequestBuilder {
        Session session;
        Artifact rootArtifact;
        DependencyCoordinate root;
        List<DependencyCoordinate> dependencies = Collections.emptyList();
        List<DependencyCoordinate> managedDependencies = Collections.emptyList();
        boolean verbose;

        DependencyCollectorRequestBuilder() {
        }

        @Nonnull
        public DependencyCollectorRequestBuilder session(@Nonnull Session session) {
            this.session = session;
            return this;
        }

        @Nonnull
        public DependencyCollectorRequestBuilder rootArtifact(@Nullable Artifact rootArtifact) {
            this.rootArtifact = rootArtifact;
            return this;
        }

        @Nonnull
        public DependencyCollectorRequestBuilder root(@Nonnull DependencyCoordinate root) {
            this.root = root;
            return this;
        }

        @Nonnull
        public DependencyCollectorRequestBuilder dependencies(@Nullable List<DependencyCoordinate> dependencies) {
            this.dependencies = dependencies != null ? dependencies : Collections.emptyList();
            return this;
        }

        @Nonnull
        public DependencyCollectorRequestBuilder dependency(@Nullable DependencyCoordinate dependency) {
            if (dependency != null) {
                if (this.dependencies.isEmpty()) {
                    this.dependencies = new ArrayList<DependencyCoordinate>();
                }
                this.dependencies.add(dependency);
            }
            return this;
        }

        @Nonnull
        public DependencyCollectorRequestBuilder managedDependencies(@Nullable List<DependencyCoordinate> managedDependencies) {
            this.managedDependencies = managedDependencies != null ? managedDependencies : Collections.emptyList();
            return this;
        }

        @Nonnull
        public DependencyCollectorRequestBuilder managedDependency(@Nullable DependencyCoordinate managedDependency) {
            if (managedDependency != null) {
                if (this.managedDependencies.isEmpty()) {
                    this.managedDependencies = new ArrayList<DependencyCoordinate>();
                }
                this.managedDependencies.add(managedDependency);
            }
            return this;
        }

        @Nonnull
        public DependencyCollectorRequestBuilder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        @Nonnull
        public DependencyCollectorRequest build() {
            return new DefaultDependencyCollectorRequest(this.session, this.rootArtifact, this.root, this.dependencies, this.managedDependencies, this.verbose);
        }

        static class DefaultDependencyCollectorRequest
        extends BaseRequest
        implements DependencyCollectorRequest {
            private final Artifact rootArtifact;
            private final DependencyCoordinate root;
            private final Collection<DependencyCoordinate> dependencies;
            private final Collection<DependencyCoordinate> managedDependencies;
            private final boolean verbose;

            DefaultDependencyCollectorRequest(@Nonnull Session session, @Nullable Artifact rootArtifact, @Nullable DependencyCoordinate root, @Nonnull Collection<DependencyCoordinate> dependencies, @Nonnull Collection<DependencyCoordinate> managedDependencies, boolean verbose) {
                super(session);
                this.rootArtifact = rootArtifact;
                this.root = root;
                this.dependencies = DefaultDependencyCollectorRequest.unmodifiable(DefaultDependencyCollectorRequest.nonNull(dependencies, "dependencies cannot be null"));
                this.managedDependencies = DefaultDependencyCollectorRequest.unmodifiable(DefaultDependencyCollectorRequest.nonNull(managedDependencies, "managedDependencies cannot be null"));
                this.verbose = verbose;
            }

            @Override
            @Nonnull
            public Optional<Artifact> getRootArtifact() {
                return Optional.ofNullable(this.rootArtifact);
            }

            @Override
            @Nonnull
            public Optional<DependencyCoordinate> getRoot() {
                return Optional.ofNullable(this.root);
            }

            @Override
            @Nonnull
            public Collection<DependencyCoordinate> getDependencies() {
                return this.dependencies;
            }

            @Override
            @Nonnull
            public Collection<DependencyCoordinate> getManagedDependencies() {
                return this.managedDependencies;
            }

            @Override
            public boolean getVerbose() {
                return this.verbose;
            }

            @Nonnull
            public String toString() {
                return this.getRoot() + " -> " + this.getDependencies();
            }
        }
    }
}

