/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.MessageBuilder;

@Experimental
public class DefaultMessageBuilder
implements MessageBuilder {
    private final StringBuilder buffer;

    public DefaultMessageBuilder() {
        this(new StringBuilder());
    }

    public DefaultMessageBuilder(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Nonnull
    public MessageBuilder trace(Object o) {
        return this.a(o);
    }

    @Nonnull
    public MessageBuilder debug(Object o) {
        return this.a(o);
    }

    @Nonnull
    public MessageBuilder info(Object o) {
        return this.a(o);
    }

    @Nonnull
    public MessageBuilder warning(Object o) {
        return this.a(o);
    }

    @Nonnull
    public MessageBuilder error(Object o) {
        return this.a(o);
    }

    @Nonnull
    public MessageBuilder success(Object o) {
        return this.a(o);
    }

    @Nonnull
    public MessageBuilder failure(Object o) {
        return this.a(o);
    }

    @Nonnull
    public MessageBuilder strong(Object o) {
        return this.a(o);
    }

    @Nonnull
    public MessageBuilder mojo(Object o) {
        return this.a(o);
    }

    @Nonnull
    public MessageBuilder project(Object o) {
        return this.a(o);
    }

    @Nonnull
    public MessageBuilder a(char[] chars, int i, int i1) {
        this.buffer.append(chars, i, i1);
        return this;
    }

    @Nonnull
    public MessageBuilder a(char[] chars) {
        this.buffer.append(chars);
        return this;
    }

    @Nonnull
    public MessageBuilder a(CharSequence charSequence, int i, int i1) {
        this.buffer.append(charSequence, i, i1);
        return this;
    }

    @Nonnull
    public MessageBuilder a(CharSequence charSequence) {
        this.buffer.append(charSequence);
        return this;
    }

    @Nonnull
    public MessageBuilder a(Object o) {
        this.buffer.append(o);
        return this;
    }

    @Nonnull
    public MessageBuilder newline() {
        this.buffer.append(System.getProperty("line.separator"));
        return this;
    }

    @Nonnull
    public MessageBuilder format(String s, Object ... objects) {
        this.buffer.append(String.format(s, objects));
        return this;
    }

    @Nonnull
    public String build() {
        return this.buffer.toString();
    }

    public String toString() {
        return this.build();
    }

    public void setLength(int length) {
        this.buffer.setLength(length);
    }
}

