/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

final class OnChangeTransformer
implements Supplier<Path> {
    private final Supplier<Path> source;
    private final Path target;
    private final Function<Path, String> stateFunction;
    private final BiConsumer<Path, Path> transformerConsumer;
    private final AtomicReference<String> sourceState;

    OnChangeTransformer(Supplier<Path> source, Path target, Function<Path, String> stateFunction, BiConsumer<Path, Path> transformerConsumer) {
        this.source = Objects.requireNonNull(source);
        this.target = Objects.requireNonNull(target);
        this.stateFunction = Objects.requireNonNull(stateFunction);
        this.transformerConsumer = Objects.requireNonNull(transformerConsumer);
        this.sourceState = new AtomicReference<Object>(null);
    }

    @Override
    public synchronized Path get() {
        String state = this.mayUpdate();
        if (state == null) {
            return null;
        }
        return this.target;
    }

    private String mayUpdate() {
        String result;
        try {
            Path src = this.source.get();
            if (src == null) {
                Files.deleteIfExists(this.target);
                result = null;
            } else if (!Files.exists(src, new LinkOption[0])) {
                Files.deleteIfExists(this.target);
                result = "";
            } else {
                String existing;
                String current = this.stateFunction.apply(src);
                if (!Objects.equals(current, existing = this.sourceState.get())) {
                    this.transformerConsumer.accept(src, this.target);
                    Files.setLastModifiedTime(this.target, Files.getLastModifiedTime(src, new LinkOption[0]));
                }
                result = current;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.sourceState.set(result);
        return result;
    }
}

