/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.metadata;

import java.io.Serializable;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class SnapshotVersion
implements Serializable {
    final String classifier;
    final String extension;
    final String version;
    final String updated;

    SnapshotVersion(String classifier, String extension, String version, String updated) {
        this.classifier = classifier;
        this.extension = extension;
        this.version = version;
        this.updated = updated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof SnapshotVersion)) {
            return false;
        }
        SnapshotVersion that = (SnapshotVersion)o;
        return Objects.equals(this.classifier, that.classifier) && Objects.equals(this.extension, that.extension) && Objects.equals(this.version, that.version) && Objects.equals(this.updated, that.updated);
    }

    public int hashCode() {
        return Objects.hash(this.classifier, this.extension, this.version, this.updated);
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUpdated() {
        return this.updated;
    }

    @Nonnull
    public Builder with() {
        return SnapshotVersion.newBuilder(this);
    }

    @Nonnull
    public SnapshotVersion withClassifier(String classifier) {
        return SnapshotVersion.newBuilder(this, true).classifier(classifier).build();
    }

    @Nonnull
    public SnapshotVersion withExtension(String extension) {
        return SnapshotVersion.newBuilder(this, true).extension(extension).build();
    }

    @Nonnull
    public SnapshotVersion withVersion(String version) {
        return SnapshotVersion.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public SnapshotVersion withUpdated(String updated) {
        return SnapshotVersion.newBuilder(this, true).updated(updated).build();
    }

    @Nonnull
    public static SnapshotVersion newInstance() {
        return SnapshotVersion.newInstance(true);
    }

    @Nonnull
    public static SnapshotVersion newInstance(boolean withDefaults) {
        return SnapshotVersion.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return SnapshotVersion.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(SnapshotVersion from) {
        return SnapshotVersion.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(SnapshotVersion from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        SnapshotVersion base;
        String classifier;
        String extension;
        String version;
        String updated;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(SnapshotVersion base, boolean forceCopy) {
            if (forceCopy) {
                this.classifier = base.classifier;
                this.extension = base.extension;
                this.version = base.version;
                this.updated = base.updated;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        @Nonnull
        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder updated(String updated) {
            this.updated = updated;
            return this;
        }

        @Nonnull
        public SnapshotVersion build() {
            if (!(this.base == null || this.classifier != null && this.classifier != this.base.classifier || this.extension != null && this.extension != this.base.extension || this.version != null && this.version != this.base.version || this.updated != null && this.updated != this.base.updated)) {
                return this.base;
            }
            return new SnapshotVersion(this.classifier != null ? this.classifier : (this.base != null ? this.base.classifier : null), this.extension != null ? this.extension : (this.base != null ? this.base.extension : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.updated != null ? this.updated : (this.base != null ? this.base.updated : null));
        }
    }
}

