/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.di.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.di.Key;

public abstract class BindingInitializer<T> {
    private final Set<Key<?>> dependencies;

    protected BindingInitializer(Set<Key<?>> dependencies) {
        this.dependencies = dependencies;
    }

    public Set<Key<?>> getDependencies() {
        return this.dependencies;
    }

    public abstract Consumer<T> compile(Function<Key<?>, Supplier<?>> var1);

    public static <T> BindingInitializer<T> combine(final List<BindingInitializer<T>> bindingInitializers) {
        Set deps = bindingInitializers.stream().map(BindingInitializer::getDependencies).flatMap(Collection::stream).collect(Collectors.toSet());
        return new BindingInitializer<T>(deps){

            @Override
            public Consumer<T> compile(Function<Key<?>, Supplier<?>> compiler) {
                return instance -> bindingInitializers.stream().map(bindingInitializer -> bindingInitializer.compile(compiler)).forEach(i -> i.accept(instance));
            }
        };
    }
}

