/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal.relocation;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Relocation;
import org.apache.maven.repository.internal.MavenArtifactRelocationSource;
import org.apache.maven.repository.internal.RelocatedArtifact;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.sisu.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="distributionManagement")
@Priority(value=5)
public final class DistributionManagementArtifactRelocationSource
implements MavenArtifactRelocationSource {
    public static final String NAME = "distributionManagement";
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributionManagementArtifactRelocationSource.class);

    @Override
    public Artifact relocatedTarget(RepositorySystemSession session, ArtifactDescriptorResult artifactDescriptorResult, Model model) {
        Relocation relocation;
        DistributionManagement distMgmt = model.getDistributionManagement();
        if (distMgmt != null && (relocation = distMgmt.getRelocation()) != null) {
            RelocatedArtifact result = new RelocatedArtifact(artifactDescriptorResult.getRequest().getArtifact(), relocation.getGroupId(), relocation.getArtifactId(), null, null, relocation.getVersion(), relocation.getMessage());
            LOGGER.debug("The artifact {} has been relocated to {}: {}", new Object[]{artifactDescriptorResult.getRequest().getArtifact(), result, relocation.getMessage()});
            return result;
        }
        return null;
    }
}

