/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.internal.aether.LoggingRepositoryListener;
import org.apache.maven.internal.aether.MavenExecutionRequestExtender;
import org.apache.maven.internal.aether.RepositorySystemSessionExtender;
import org.apache.maven.internal.aether.ReverseTreeRepositoryListener;
import org.apache.maven.internal.aether.TypeRegistryAdapter;
import org.apache.maven.internal.impl.resolver.MavenSessionBuilderSupplier;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.internal.xml.XmlPlexusConfiguration;
import org.apache.maven.model.ModelBase;
import org.apache.maven.resolver.RepositorySystemSessionFactory;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.util.graph.version.ChainedVersionFilter;
import org.eclipse.aether.util.graph.version.ContextualSnapshotVersionFilter;
import org.eclipse.aether.util.graph.version.HighestVersionFilter;
import org.eclipse.aether.util.graph.version.LowestVersionFilter;
import org.eclipse.aether.util.graph.version.PredicateVersionFilter;
import org.eclipse.aether.util.listener.ChainedRepositoryListener;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultRepositorySystemSessionFactory
implements RepositorySystemSessionFactory {
    private static final String MAVEN_VERSION_FILTERS = "maven.versionFilters";
    private static final String MAVEN_REPO_LOCAL_TAIL = "maven.repo.local.tail";
    private static final String MAVEN_REPO_LOCAL_RECORD_REVERSE_TREE = "maven.repo.local.recordReverseTree";
    private static final String MAVEN_RESOLVER_DEPENDENCY_MANAGER_TRANSITIVITY_KEY = "maven.resolver.dependencyManagerTransitivity";
    private static final String MAVEN_RESOLVER_TRANSPORT_KEY = "maven.resolver.transport";
    private static final String MAVEN_RESOLVER_TRANSPORT_DEFAULT = "default";
    private static final String MAVEN_RESOLVER_TRANSPORT_WAGON = "wagon";
    private static final String MAVEN_RESOLVER_TRANSPORT_APACHE = "apache";
    private static final String MAVEN_RESOLVER_TRANSPORT_JDK = "jdk";
    @Deprecated
    private static final String MAVEN_RESOLVER_TRANSPORT_NATIVE = "native";
    private static final String MAVEN_RESOLVER_TRANSPORT_AUTO = "auto";
    private static final String WAGON_TRANSPORTER_PRIORITY_KEY = "aether.priority.WagonTransporterFactory";
    private static final String APACHE_HTTP_TRANSPORTER_PRIORITY_KEY = "aether.priority.ApacheTransporterFactory";
    private static final String JDK_HTTP_TRANSPORTER_PRIORITY_KEY = "aether.priority.JdkTransporterFactory";
    private static final String FILE_TRANSPORTER_PRIORITY_KEY = "aether.priority.FileTransporterFactory";
    private static final String RESOLVER_MAX_PRIORITY = String.valueOf(Float.MAX_VALUE);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RepositorySystem repoSystem;
    private final SettingsDecrypter settingsDecrypter;
    private final EventSpyDispatcher eventSpyDispatcher;
    private final RuntimeInformation runtimeInformation;
    private final TypeRegistry typeRegistry;
    private final VersionScheme versionScheme;
    private final Map<String, MavenExecutionRequestExtender> requestExtenders;
    private final Map<String, RepositorySystemSessionExtender> sessionExtenders;

    @Inject
    DefaultRepositorySystemSessionFactory(RepositorySystem repoSystem, SettingsDecrypter settingsDecrypter, EventSpyDispatcher eventSpyDispatcher, RuntimeInformation runtimeInformation, TypeRegistry typeRegistry, VersionScheme versionScheme, Map<String, MavenExecutionRequestExtender> requestExtenders, Map<String, RepositorySystemSessionExtender> sessionExtenders) {
        this.repoSystem = repoSystem;
        this.settingsDecrypter = settingsDecrypter;
        this.eventSpyDispatcher = eventSpyDispatcher;
        this.runtimeInformation = runtimeInformation;
        this.typeRegistry = typeRegistry;
        this.versionScheme = versionScheme;
        this.requestExtenders = requestExtenders;
        this.sessionExtenders = sessionExtenders;
    }

    @Deprecated
    public RepositorySystemSession newRepositorySession(MavenExecutionRequest request) {
        return this.newRepositorySessionBuilder(request).build();
    }

    @Override
    public RepositorySystemSession.SessionBuilder newRepositorySessionBuilder(MavenExecutionRequest request) {
        Objects.requireNonNull(request, "request");
        for (MavenExecutionRequestExtender requestExtender : this.requestExtenders.values()) {
            requestExtender.extend(request);
        }
        MavenSessionBuilderSupplier supplier = new MavenSessionBuilderSupplier(this.repoSystem);
        RepositorySystemSession.SessionBuilder sessionBuilder = supplier.get();
        sessionBuilder.setArtifactTypeRegistry((ArtifactTypeRegistry)new TypeRegistryAdapter(this.typeRegistry));
        sessionBuilder.setCache(request.getRepositoryCache());
        Map<String, String> mergedProps = this.createMergedProperties(request);
        LinkedHashMap<String, Object> configProps = new LinkedHashMap<String, Object>();
        configProps.put("aether.transport.http.userAgent", this.getUserAgent());
        configProps.put("aether.interactive", request.isInteractiveMode());
        configProps.put("maven.startTime", request.getStartTime());
        sessionBuilder.setOffline(request.isOffline());
        sessionBuilder.setChecksumPolicy(request.getGlobalChecksumPolicy());
        sessionBuilder.setUpdatePolicy(request.isNoSnapshotUpdates() ? "never" : (request.isUpdateSnapshots() ? "always" : null));
        int errorPolicy = 0;
        errorPolicy |= request.isCacheNotFound() ? 1 : 0;
        sessionBuilder.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(errorPolicy |= request.isCacheTransferError() ? 2 : 0, errorPolicy | 1));
        sessionBuilder.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(request.isIgnoreMissingArtifactDescriptor(), request.isIgnoreInvalidArtifactDescriptor()));
        VersionFilter versionFilter = this.buildVersionFilter(mergedProps.get(MAVEN_VERSION_FILTERS));
        if (versionFilter != null) {
            sessionBuilder.setVersionFilter(versionFilter);
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies(request.getProxies());
        decrypt.setServers(request.getServers());
        SettingsDecryptionResult decrypted = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem problem : decrypted.getProblems()) {
                this.logger.debug(problem.getMessage(), (Throwable)problem.getException());
            }
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : request.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.isBlocked(), mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        sessionBuilder.setMirrorSelector((MirrorSelector)mirrorSelector);
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (Object proxy : decrypted.getProxies()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            proxySelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authBuilder.build()), proxy.getNonProxyHosts());
        }
        sessionBuilder.setProxySelector((ProxySelector)proxySelector);
        DefaultAuthenticationSelector defaultAuthenticationSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            defaultAuthenticationSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                PlexusConfiguration connectTimeoutXml;
                PlexusConfiguration[] properties;
                XmlNode dom = server.getDelegate().getConfiguration();
                List children = dom.getChildren().stream().filter(c -> !"wagonProvider".equals(c.getName())).collect(Collectors.toList());
                dom = new XmlNodeImpl(dom.getName(), null, null, children, null);
                PlexusConfiguration config = XmlPlexusConfiguration.toPlexusConfiguration((XmlNode)dom);
                configProps.put("aether.transport.wagon.config." + server.getId(), config);
                Object headers = null;
                Integer connectTimeout = null;
                Integer requestTimeout = null;
                PlexusConfiguration httpHeaders = config.getChild("httpHeaders", false);
                if (httpHeaders != null && (properties = httpHeaders.getChildren("property")) != null && properties.length > 0) {
                    headers = new HashMap();
                    for (PlexusConfiguration property : properties) {
                        headers.put(property.getChild("name").getValue(), property.getChild("value").getValue());
                    }
                }
                if ((connectTimeoutXml = config.getChild("connectTimeout", false)) != null) {
                    connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                } else {
                    PlexusConfiguration httpConfigurationAll;
                    PlexusConfiguration httpConfiguration = config.getChild("httpConfiguration", false);
                    if (httpConfiguration != null && (httpConfigurationAll = httpConfiguration.getChild("all", false)) != null && (connectTimeoutXml = httpConfigurationAll.getChild("connectionTimeout", false)) != null) {
                        connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                        this.logger.warn("Settings for server {} uses legacy format", (Object)server.getId());
                    }
                }
                PlexusConfiguration requestTimeoutXml = config.getChild("requestTimeout", false);
                if (requestTimeoutXml != null) {
                    requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                } else {
                    PlexusConfiguration httpConfigurationAll;
                    PlexusConfiguration httpConfiguration = config.getChild("httpConfiguration", false);
                    if (httpConfiguration != null && (httpConfigurationAll = httpConfiguration.getChild("all", false)) != null && (requestTimeoutXml = httpConfigurationAll.getChild("readTimeout", false)) != null) {
                        requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                        this.logger.warn("Settings for server {} uses legacy format", (Object)server.getId());
                    }
                }
                if (headers != null) {
                    configProps.put("aether.transport.http.headers." + server.getId(), headers);
                }
                if (connectTimeout != null) {
                    configProps.put("aether.transport.http.connectTimeout." + server.getId(), connectTimeout);
                }
                if (requestTimeout != null) {
                    configProps.put("aether.transport.http.requestTimeout." + server.getId(), requestTimeout);
                }
            }
            configProps.put("aether.transport.wagon.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.transport.wagon.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        sessionBuilder.setAuthenticationSelector((AuthenticationSelector)defaultAuthenticationSelector);
        String transport = mergedProps.getOrDefault(MAVEN_RESOLVER_TRANSPORT_KEY, MAVEN_RESOLVER_TRANSPORT_DEFAULT);
        if (!MAVEN_RESOLVER_TRANSPORT_DEFAULT.equals(transport)) {
            if (MAVEN_RESOLVER_TRANSPORT_JDK.equals(transport)) {
                configProps.put(FILE_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
                configProps.put(JDK_HTTP_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
            } else if (MAVEN_RESOLVER_TRANSPORT_APACHE.equals(transport) || MAVEN_RESOLVER_TRANSPORT_NATIVE.equals(transport)) {
                if (MAVEN_RESOLVER_TRANSPORT_NATIVE.equals(transport)) {
                    this.logger.warn("Transport name '{}' is DEPRECATED/RENAMED, use '{}' instead", (Object)MAVEN_RESOLVER_TRANSPORT_NATIVE, (Object)MAVEN_RESOLVER_TRANSPORT_APACHE);
                }
                configProps.put(FILE_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
                configProps.put(APACHE_HTTP_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
            } else if (MAVEN_RESOLVER_TRANSPORT_WAGON.equals(transport)) {
                configProps.put(WAGON_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
            } else if (!MAVEN_RESOLVER_TRANSPORT_AUTO.equals(transport)) {
                throw new IllegalArgumentException("Unknown resolver transport '" + String.valueOf(transport) + "'. Supported transports are: wagon, apache, jdk, auto");
            }
        }
        sessionBuilder.setIgnoreArtifactDescriptorRepositories(request.isIgnoreTransitiveRepositories());
        sessionBuilder.setTransferListener(request.getTransferListener());
        RepositoryListener repositoryListener = this.eventSpyDispatcher.chainListener((RepositoryListener)new LoggingRepositoryListener(this.logger));
        boolean recordReverseTree = Boolean.parseBoolean(mergedProps.getOrDefault(MAVEN_REPO_LOCAL_RECORD_REVERSE_TREE, Boolean.FALSE.toString()));
        if (recordReverseTree) {
            repositoryListener = new ChainedRepositoryListener(new RepositoryListener[]{repositoryListener, new ReverseTreeRepositoryListener()});
        }
        sessionBuilder.setRepositoryListener(repositoryListener);
        String resolverDependencyManagerTransitivity = mergedProps.getOrDefault(MAVEN_RESOLVER_DEPENDENCY_MANAGER_TRANSITIVITY_KEY, Boolean.TRUE.toString());
        sessionBuilder.setDependencyManager(supplier.getDependencyManager(Boolean.parseBoolean(resolverDependencyManagerTransitivity)));
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(Paths.get(request.getLocalRepository().getBasedir(), new String[0]));
        String localRepoTail = mergedProps.get(MAVEN_REPO_LOCAL_TAIL);
        if (localRepoTail != null) {
            Arrays.stream(localRepoTail.split(",")).filter(p -> p != null && !p.trim().isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).forEach(paths::add);
        }
        sessionBuilder.withLocalRepositoryBaseDirectories(paths);
        for (RepositorySystemSessionExtender extender : this.sessionExtenders.values()) {
            extender.extend(request, configProps, (MirrorSelector)mirrorSelector, (ProxySelector)proxySelector, (AuthenticationSelector)defaultAuthenticationSelector);
        }
        HashMap<String, Object> finalConfigProperties = new HashMap<String, Object>();
        finalConfigProperties.putAll(mergedProps);
        finalConfigProperties.putAll(configProps);
        sessionBuilder.setUserProperties((Map)request.getUserProperties());
        sessionBuilder.setSystemProperties((Map)request.getSystemProperties());
        sessionBuilder.setConfigProperties(finalConfigProperties);
        return sessionBuilder;
    }

    private VersionFilter buildVersionFilter(String filterExpression) {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (filterExpression != null) {
            List<String> expressions = Arrays.stream(filterExpression.split(";")).filter(s -> s != null && !s.trim().isEmpty()).toList();
            for (String expression : expressions) {
                if ("h".equals(expression)) {
                    filters.add(new HighestVersionFilter());
                    continue;
                }
                if (expression.startsWith("h(") && expression.endsWith(")")) {
                    int num = Integer.parseInt(expression.substring(2, expression.length() - 1));
                    filters.add(new HighestVersionFilter(num));
                    continue;
                }
                if ("l".equals(expression)) {
                    filters.add(new LowestVersionFilter());
                    continue;
                }
                if (expression.startsWith("l(") && expression.endsWith(")")) {
                    int num = Integer.parseInt(expression.substring(2, expression.length() - 1));
                    filters.add(new LowestVersionFilter(num));
                    continue;
                }
                if ("s".equals(expression)) {
                    filters.add(new ContextualSnapshotVersionFilter());
                    continue;
                }
                if (expression.startsWith("e(") && expression.endsWith(")")) {
                    DefaultArtifact artifact = new DefaultArtifact(expression.substring(2, expression.length() - 1));
                    VersionRange versionRange = artifact.getVersion().contains(",") ? this.parseVersionRange(artifact.getVersion()) : null;
                    Predicate<Artifact> predicate = arg_0 -> this.lambda$buildVersionFilter$4((Artifact)artifact, versionRange, arg_0);
                    filters.add(new PredicateVersionFilter(predicate));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported filter expression: " + expression);
            }
        }
        if (filters.isEmpty()) {
            return null;
        }
        if (filters.size() == 1) {
            return (VersionFilter)filters.get(0);
        }
        return ChainedVersionFilter.newInstance(filters);
    }

    private Version parseVersion(String spec) {
        try {
            return this.versionScheme.parseVersion(spec);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    private VersionRange parseVersionRange(String spec) {
        try {
            return this.versionScheme.parseVersionRange(spec);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> createMergedProperties(MavenExecutionRequest request) {
        HashMap<String, String> mergedProps = new HashMap<String, String>();
        mergedProps.putAll(this.getPropertiesFromRequestedProfiles(request));
        mergedProps.putAll(new HashMap<Object, Object>(request.getSystemProperties()));
        mergedProps.putAll(new HashMap<Object, Object>(request.getUserProperties()));
        return mergedProps;
    }

    private Map<String, String> getPropertiesFromRequestedProfiles(MavenExecutionRequest request) {
        HashSet<String> activeProfileId = new HashSet<String>(request.getProfileActivation().getRequiredActiveProfileIds());
        activeProfileId.addAll(request.getProfileActivation().getOptionalActiveProfileIds());
        return request.getProfiles().stream().filter(profile -> activeProfileId.contains(profile.getId())).map(ModelBase::getProperties).flatMap(properties -> properties.entrySet().stream()).filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (k1, k2) -> k2));
    }

    private String getUserAgent() {
        Object version = this.runtimeInformation.getMavenVersion();
        version = ((String)version).isEmpty() ? version : "/" + (String)version;
        return "Apache-Maven" + (String)version + " (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
    }

    private /* synthetic */ boolean lambda$buildVersionFilter$4(Artifact artifact, VersionRange versionRange, Artifact a) {
        if (artifact.getGroupId().equals(a.getGroupId()) && artifact.getArtifactId().equals(a.getArtifactId())) {
            if (versionRange != null) {
                Version v = this.parseVersion(a.getVersion());
                return !versionRange.containsVersion(v);
            }
            return !artifact.getVersion().equals(a.getVersion());
        }
        return true;
    }
}

