/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.internal.transformation.ConsumerPomArtifactTransformer;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.internal.impl.DefaultDeployer;
import org.eclipse.sisu.Priority;

@Singleton
@Named
@Priority(value=100)
final class MavenDeployer
implements Deployer {
    private final DefaultDeployer deployer;
    private final ConsumerPomArtifactTransformer consumerPomArtifactTransformer;

    @Inject
    MavenDeployer(DefaultDeployer deployer, ConsumerPomArtifactTransformer consumerPomArtifactTransformer) {
        this.deployer = Objects.requireNonNull(deployer);
        this.consumerPomArtifactTransformer = Objects.requireNonNull(consumerPomArtifactTransformer);
    }

    public DeployResult deploy(RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        return this.deployer.deploy(session, this.consumerPomArtifactTransformer.remapDeployArtifacts(session, request));
    }
}

