/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.spi.PropertyContributor;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.internal.aether.MavenExecutionRequestExtender;

@Named
@Singleton
class PropertyContributorExtender
implements MavenExecutionRequestExtender {
    private final Lookup lookup;

    @Inject
    PropertyContributorExtender(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void extend(MavenExecutionRequest mavenExecutionRequest) {
        Map effectivePropertyContributors = this.lookup.lookupMap(PropertyContributor.class);
        if (!effectivePropertyContributors.isEmpty()) {
            HashMap<Object, Object> userPropertiesMap = new HashMap<Object, Object>(mavenExecutionRequest.getUserProperties());
            for (PropertyContributor contributor : effectivePropertyContributors.values()) {
                contributor.contribute(userPropertiesMap);
            }
            Properties newProperties = new Properties();
            newProperties.putAll((Map<?, ?>)userPropertiesMap);
            mavenExecutionRequest.setUserProperties(newProperties);
        }
    }
}

