/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.util.Objects;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Type;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.repository.internal.type.DefaultType;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;

class TypeRegistryAdapter
implements ArtifactTypeRegistry {
    private final TypeRegistry typeRegistry;

    TypeRegistryAdapter(TypeRegistry typeRegistry) {
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry");
    }

    public ArtifactType get(String typeId) {
        Type type = this.typeRegistry.require(typeId);
        if (type instanceof ArtifactType) {
            return (ArtifactType)type;
        }
        if (type != null) {
            return new DefaultType(type.id(), type.getLanguage(), type.getExtension(), type.getClassifier(), type.isIncludesDependencies(), type.getPathTypes().toArray(new PathType[0]));
        }
        return null;
    }
}

