/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.ExtensibleEnum;
import org.apache.maven.api.Packaging;
import org.apache.maven.api.Type;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.PackagingRegistry;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.api.spi.PackagingProvider;
import org.apache.maven.internal.impl.ExtensibleEnumRegistries;
import org.apache.maven.lifecycle.internal.DefaultLifecyclePluginAnalyzer;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecycleMojo;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultPackagingRegistry
extends ExtensibleEnumRegistries.DefaultExtensibleEnumRegistry<Packaging, PackagingProvider>
implements PackagingRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPackagingRegistry.class);
    private final Lookup lookup;
    private final TypeRegistry typeRegistry;

    @Inject
    public DefaultPackagingRegistry(Lookup lookup, TypeRegistry typeRegistry, List<PackagingProvider> providers) {
        super(providers, (ExtensibleEnum[])new Packaging[0]);
        this.lookup = lookup;
        this.typeRegistry = typeRegistry;
    }

    public Optional<Packaging> lookup(String id) {
        LifecycleMapping lifecycleMapping = this.lookup.lookupOptional(LifecycleMapping.class, id = id.toLowerCase(Locale.ROOT)).orElse(null);
        if (lifecycleMapping == null) {
            return Optional.empty();
        }
        Type type = this.typeRegistry.lookup(id).orElse(null);
        if (type == null) {
            return Optional.empty();
        }
        return Optional.of(new DefaultPackaging(id, type, this.getPlugins(lifecycleMapping)));
    }

    private Map<String, PluginContainer> getPlugins(LifecycleMapping lifecycleMapping) {
        HashMap<String, PluginContainer> lfs = new HashMap<String, PluginContainer>();
        lifecycleMapping.getLifecycles().forEach((id, lifecycle) -> {
            HashMap plugins = new HashMap();
            lifecycle.getLifecyclePhases().forEach((phase, lifecyclePhase) -> DefaultPackagingRegistry.parseLifecyclePhaseDefinitions(plugins, phase, lifecyclePhase));
            lfs.put((String)id, PluginContainer.newBuilder().plugins(plugins.values()).build());
        });
        return lfs;
    }

    static void parseLifecyclePhaseDefinitions(Map<String, Plugin> plugins, String phase, LifecyclePhase goals) {
        InputSource inputSource = new InputSource(DefaultLifecyclePluginAnalyzer.DEFAULTLIFECYCLEBINDINGS_MODELID, null);
        InputLocation location = new InputLocation(-1, -1, inputSource, (Object)0);
        List<LifecycleMojo> mojos = goals.getMojos();
        if (mojos != null) {
            for (int i = 0; i < mojos.size(); ++i) {
                String goal;
                String version;
                String artifactId;
                String groupId;
                LifecycleMojo mojo = mojos.get(i);
                String[] p = mojo.getGoal().trim().split(":");
                if (p.length == 3) {
                    groupId = p[0];
                    artifactId = p[1];
                    version = null;
                    goal = p[2];
                } else if (p.length == 4) {
                    groupId = p[0];
                    artifactId = p[1];
                    version = p[2];
                    goal = p[3];
                } else {
                    LOGGER.warn("Ignored invalid goal specification '{}' from lifecycle mapping for phase {}", (Object)mojo.getGoal(), (Object)phase);
                    continue;
                }
                String key = groupId + ":" + artifactId;
                ArrayList<PluginExecution> execs = new ArrayList<PluginExecution>();
                ArrayList deps = new ArrayList();
                Plugin existing = plugins.get(key);
                if (existing != null) {
                    if (version == null) {
                        version = existing.getVersion();
                    }
                    execs.addAll(existing.getExecutions());
                    deps.addAll(existing.getDependencies());
                }
                PluginExecution execution = PluginExecution.newBuilder().id(DefaultPackagingRegistry.getExecutionId(existing, goal)).priority(i - mojos.size()).phase(phase).goals(List.of(goal)).configuration(mojo.getConfiguration()).location((Object)"", location).location((Object)"id", location).location((Object)"phase", location).location((Object)"goals", location).build();
                execs.add(execution);
                if (mojo.getDependencies() != null) {
                    mojo.getDependencies().forEach(d -> deps.add(d.getDelegate()));
                }
                Plugin plugin = Plugin.newBuilder().groupId(groupId).artifactId(artifactId).version(version).location((Object)"", location).location((Object)"groupId", location).location((Object)"artifactId", location).location((Object)"version", location).executions(execs).dependencies(deps).build();
                plugins.put(key, plugin);
            }
        }
    }

    private static String getExecutionId(Plugin plugin, String goal) {
        String base;
        Set existingIds = plugin != null ? plugin.getExecutions().stream().map(PluginExecution::getId).collect(Collectors.toSet()) : Set.of();
        String id = base = "default-" + goal;
        int index = 1;
        while (existingIds.contains(id)) {
            id = base + "-" + index;
            ++index;
        }
        return id;
    }

    private record DefaultPackaging(String id, Type type, Map<String, PluginContainer> plugins) implements Packaging
    {
    }
}

