/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.Language;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Type;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.LanguageRegistry;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.api.spi.TypeProvider;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.LegacyArtifactHandlerManager;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.internal.impl.resolver.type.DefaultType;

@Named
@Singleton
public class DefaultTypeRegistry
extends AbstractEventSpy
implements TypeRegistry {
    private final Map<String, Type> types;
    private final LanguageRegistry languageRegistry;
    private final ConcurrentHashMap<String, Type> usedTypes;
    private final LegacyArtifactHandlerManager manager;

    @Inject
    public DefaultTypeRegistry(List<TypeProvider> providers, LanguageRegistry languageRegistry, LegacyArtifactHandlerManager manager) {
        this.types = ((List)Utils.nonNull(providers, (String)"providers")).stream().flatMap(p -> p.provides().stream()).collect(Collectors.toMap(Type::id, Function.identity()));
        this.languageRegistry = (LanguageRegistry)Utils.nonNull((Object)languageRegistry, (String)"languageRegistry");
        this.usedTypes = new ConcurrentHashMap();
        this.manager = (LegacyArtifactHandlerManager)Utils.nonNull((Object)manager, (String)"artifactHandlerManager");
    }

    @Override
    public void onEvent(Object event) {
        ExecutionEvent executionEvent;
        if (event instanceof ExecutionEvent && (executionEvent = (ExecutionEvent)event).getType() == ExecutionEvent.Type.SessionEnded) {
            this.usedTypes.clear();
        }
    }

    public Optional<Type> lookup(String id) {
        return Optional.of(this.require(id));
    }

    @Nonnull
    public Type require(String id) {
        Utils.nonNull((Object)id, (String)"id");
        return this.usedTypes.computeIfAbsent(id, i -> {
            Type type = this.types.get(id);
            if (type == null) {
                ArtifactHandler handler = this.manager.getArtifactHandler(id);
                type = new DefaultType(id, (Language)this.languageRegistry.require(handler.getLanguage()), handler.getExtension(), handler.getClassifier(), handler.isIncludesDependencies(), new PathType[]{JavaPathType.CLASSES, JavaPathType.MODULES});
            }
            return type;
        });
    }
}

