/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Names;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.di.Injector;
import org.apache.maven.di.Key;
import org.apache.maven.di.impl.Binding;
import org.apache.maven.di.impl.DIException;
import org.apache.maven.di.impl.InjectorImpl;
import org.codehaus.plexus.PlexusContainer;

@Named
class SisuDiBridgeModule
extends AbstractModule {
    SisuDiBridgeModule() {
    }

    protected void configure() {
        Provider containerProvider = this.getProvider(PlexusContainer.class);
        InjectorImpl injector = new InjectorImpl((javax.inject.Provider)containerProvider){
            final /* synthetic */ javax.inject.Provider val$containerProvider;
            {
                this.val$containerProvider = provider;
            }

            public <Q> Supplier<Q> getCompiledBinding(Key<Q> key) {
                Set res = this.getBindings(key);
                if (res != null && !res.isEmpty()) {
                    ArrayList<Binding> bindingList = new ArrayList<Binding>(res);
                    Comparator<Binding> comparing = Comparator.comparing(Binding::getPriority);
                    bindingList.sort(comparing.reversed());
                    Binding binding = (Binding)bindingList.get(0);
                    return this.compile(binding);
                }
                if (key.getRawType() == List.class) {
                    Set res2 = this.getBindings(key.getTypeParameter(0));
                    HashSet res3 = res2 != null ? new HashSet(res2) : new HashSet();
                    try {
                        List l = ((PlexusContainer)this.val$containerProvider.get()).lookupList(key.getTypeParameter(0).getRawType());
                        l.forEach(o -> res3.add(new Binding.BindingToInstance(o)));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    List list = res3.stream().map(x$0 -> this.compile((Binding)x$0)).collect(Collectors.toList());
                    return () -> this.list(list);
                }
                if (key.getRawType() == Map.class) {
                    Key k = key.getTypeParameter(0);
                    Key v = key.getTypeParameter(1);
                    if (k.getRawType() == String.class) {
                        Set res2 = this.getBindings(v);
                        HashSet res3 = res2 != null ? new HashSet(res2) : new HashSet();
                        Map<String, Supplier> map = res3.stream().filter(b -> b.getOriginalKey() == null || b.getOriginalKey().getQualifier() == null || b.getOriginalKey().getQualifier() instanceof String).collect(Collectors.toMap(b -> (String)(b.getOriginalKey() != null ? b.getOriginalKey().getQualifier() : null), x$0 -> this.compile((Binding)x$0)));
                        return () -> this.map(map);
                    }
                }
                try {
                    Object t = ((PlexusContainer)this.val$containerProvider.get()).lookup(key.getRawType());
                    return this.compile((Binding)new Binding.BindingToInstance(t));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw new DIException("No binding to construct an instance for key " + key.getDisplayString() + ".  Existing bindings:\n" + this.getBoundKeys().stream().map(Key::toString).map(String::trim).sorted().distinct().collect(Collectors.joining("\n - ", " - ", "")));
                }
            }
        };
        injector.bindInstance(Injector.class, (Object)injector);
        this.bind(Injector.class).toInstance((Object)injector);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        try {
            Iterator<URL> it = classLoader.getResources("META-INF/maven/org.apache.maven.api.di.Inject").asIterator();
            while (it.hasNext()) {
                List<String> lines;
                URL url = it.next();
                try (InputStream is = url.openStream();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    lines = reader.lines().map(String::trim).filter(s -> !s.isEmpty() && !s.startsWith("#")).toList();
                }
                for (String className : lines) {
                    try {
                        Class<?> clazz = classLoader.loadClass(className);
                        injector.bindImplicit(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MavenException((Throwable)e);
        }
        injector.getBindings().keySet().stream().filter(k -> k.getQualifier() != null).sorted(Comparator.comparing(k -> k.getRawType().getName())).distinct().forEach(key -> {
            Class<?> itf;
            Class<?> clazz = key.getRawType();
            Class<?> clazz2 = clazz.isInterface() ? null : (itf = clazz.getInterfaces().length > 0 ? clazz.getInterfaces()[0] : clazz);
            if (itf != null) {
                AnnotatedBindingBuilder binder = this.bind(itf);
                Object patt0$temp = key.getQualifier();
                if (patt0$temp instanceof String) {
                    String s = (String)patt0$temp;
                    binder.annotatedWith((Annotation)Names.named((String)s));
                } else {
                    Object patt1$temp = key.getQualifier();
                    if (patt1$temp instanceof Annotation) {
                        Annotation a = (Annotation)patt1$temp;
                        binder.annotatedWith(a);
                    }
                }
                binder.toProvider(() -> injector.getInstance(clazz));
            }
        });
    }
}

