/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.ModelResolver;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ModelTransformer;
import org.apache.maven.api.services.SuperPomProvider;
import org.apache.maven.api.services.model.DependencyManagementImporter;
import org.apache.maven.api.services.model.DependencyManagementInjector;
import org.apache.maven.api.services.model.InheritanceAssembler;
import org.apache.maven.api.services.model.LifecycleBindingsInjector;
import org.apache.maven.api.services.model.ModelInterpolator;
import org.apache.maven.api.services.model.ModelNormalizer;
import org.apache.maven.api.services.model.ModelPathTranslator;
import org.apache.maven.api.services.model.ModelProcessor;
import org.apache.maven.api.services.model.ModelUrlNormalizer;
import org.apache.maven.api.services.model.ModelValidator;
import org.apache.maven.api.services.model.ModelVersionParser;
import org.apache.maven.api.services.model.PluginConfigurationExpander;
import org.apache.maven.api.services.model.PluginManagementInjector;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.ProfileInjector;
import org.apache.maven.api.services.model.ProfileSelector;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.model.DefaultModelBuilder;
import org.apache.maven.internal.impl.model.DefaultProfileSelector;
import org.apache.maven.internal.impl.model.ProfileActivationFilePathInterpolator;
import org.apache.maven.internal.impl.resolver.DefaultModelCache;
import org.apache.maven.internal.transformation.impl.ConsumerPomBuilder;
import org.apache.maven.model.v4.MavenModelVersion;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class DefaultConsumerPomBuilder
implements ConsumerPomBuilder {
    private static final String BOM_PACKAGING = "bom";
    public static final String POM_PACKAGING = "pom";
    @Inject
    private ProfileInjector profileInjector;
    @Inject
    private InheritanceAssembler inheritanceAssembler;
    @Inject
    private DependencyManagementImporter dependencyManagementImporter;
    @Inject
    private DependencyManagementInjector dependencyManagementInjector;
    @Inject
    private LifecycleBindingsInjector lifecycleBindingsInjector;
    @Inject
    private ModelInterpolator modelInterpolator;
    @Inject
    private ModelNormalizer modelNormalizer;
    @Inject
    private ModelPathTranslator modelPathTranslator;
    @Inject
    private ModelProcessor modelProcessor;
    @Inject
    private ModelUrlNormalizer modelUrlNormalizer;
    @Inject
    private ModelValidator modelValidator;
    @Inject
    private PluginConfigurationExpander pluginConfigurationExpander;
    @Inject
    private PluginManagementInjector pluginManagementInjector;
    @Inject
    private SuperPomProvider superPomProvider;
    @Inject
    private ModelVersionParser versionParser;
    @Inject
    private ModelTransformer modelTransformer;
    @Inject
    private Provider<RepositorySystem> repositorySystem;
    @Inject
    private RemoteRepositoryManager remoteRepositoryManager;
    @Inject
    private ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    DefaultConsumerPomBuilder() {
    }

    @Override
    public Model build(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuilderException {
        Model model = project.getModel().getDelegate();
        String packaging = model.getPackaging();
        String originalPackaging = project.getOriginalModel().getPackaging();
        if (POM_PACKAGING.equals(packaging) && !BOM_PACKAGING.equals(originalPackaging)) {
            return this.buildPom(session, project, src);
        }
        return this.buildNonPom(session, project, src);
    }

    protected Model buildPom(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuilderException {
        ModelBuilderResult result = this.buildModel(session, project, src);
        Model model = result.getRawModel();
        return DefaultConsumerPomBuilder.transform(model, project);
    }

    protected Model buildNonPom(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuilderException {
        ModelBuilderResult result = this.buildModel(session, project, src);
        Model model = result.getEffectiveModel();
        return DefaultConsumerPomBuilder.transform(model, project);
    }

    private ModelBuilderResult buildModel(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuilderException {
        DefaultProfileSelector customSelector = new DefaultProfileSelector(){

            public List<Profile> getActiveProfiles(Collection<Profile> profiles, ProfileActivationContext context, ModelProblemCollector problems) {
                return new ArrayList<Profile>();
            }
        };
        DefaultModelBuilder modelBuilder = new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, (ProfileSelector)customSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.profileActivationFilePathInterpolator, this.modelTransformer, this.versionParser);
        InternalSession iSession = InternalSession.from((RepositorySystemSession)session);
        ModelBuilderRequest.ModelBuilderRequestBuilder request = ModelBuilderRequest.builder();
        request.projectBuild(true);
        request.session((Session)iSession);
        request.source(ModelSource.fromPath((Path)src));
        request.validationLevel(0);
        request.locationTracking(false);
        request.modelResolver((ModelResolver)iSession.getData().get(SessionData.key(ModelResolver.class)));
        request.transformerContextBuilder(modelBuilder.newTransformerContextBuilder());
        request.systemProperties(session.getSystemProperties());
        request.userProperties(session.getUserProperties());
        request.modelCache(DefaultModelCache.newInstance((RepositorySystemSession)session, (boolean)false));
        if (session.getCache() != null) {
            Map map = (Map)session.getCache().get(session, (Object)DefaultModelCache.class.getName());
            List<String> paths = map.keySet().stream().map(Object::toString).filter(s -> s.startsWith("SourceCacheKey")).map(s -> s.substring("SourceCacheKey[location=".length(), s.indexOf(", tag"))).sorted().distinct().toList();
            this.logger.debug("ModelCache contains " + paths.size());
            paths.forEach(s -> this.logger.debug("    " + s));
        }
        return modelBuilder.build(request.build());
    }

    static Model transform(Model model, MavenProject project) {
        String packaging = model.getPackaging();
        if (POM_PACKAGING.equals(packaging)) {
            if ((model = model.withRoot(false).withModules(null)).getParent() != null) {
                model = model.withParent(model.getParent().withRelativePath(null));
            }
            if (!model.isPreserveModelVersion()) {
                model = model.withPreserveModelVersion(false);
                String modelVersion = new MavenModelVersion().getModelVersion(model);
                model = model.withModelVersion(modelVersion);
            }
        } else if (BOM_PACKAGING.equals(packaging)) {
            DependencyManagement dependencyManagement = project.getOriginalModel().getDependencyManagement().getDelegate();
            ArrayList dependencies = new ArrayList();
            String version = model.getVersion();
            dependencyManagement.getDependencies().forEach(dependency -> dependencies.add(dependency.withVersion(version)));
            Model.Builder builder = DefaultConsumerPomBuilder.prune(Model.newBuilder((Model)model, (boolean)true).preserveModelVersion(false).root(false).parent(null).dependencyManagement(dependencyManagement.withDependencies(dependencies)).build(null), (ModelBase)model);
            builder.packaging(POM_PACKAGING);
            builder.profiles(DefaultConsumerPomBuilder.prune(model.getProfiles()));
            model = builder.build();
            String modelVersion = new MavenModelVersion().getModelVersion(model);
            model = model.withModelVersion(modelVersion);
        } else {
            Model.Builder builder = DefaultConsumerPomBuilder.prune(Model.newBuilder((Model)model, (boolean)true).preserveModelVersion(false).root(false).parent(null).build(null), (ModelBase)model);
            builder.profiles(DefaultConsumerPomBuilder.prune(model.getProfiles()));
            model = builder.build();
            String modelVersion = new MavenModelVersion().getModelVersion(model);
            model = model.withModelVersion(modelVersion);
        }
        return model;
    }

    private static List<Profile> prune(List<Profile> profiles) {
        return profiles.stream().map(p -> {
            Profile.Builder builder = Profile.newBuilder((Profile)p, (boolean)true);
            DefaultConsumerPomBuilder.prune(builder, (ModelBase)p);
            return builder.build(null).build();
        }).filter(p -> !DefaultConsumerPomBuilder.isEmpty(p)).collect(Collectors.toList());
    }

    private static boolean isEmpty(Profile profile) {
        return profile.getActivation() == null && profile.getBuild() == null && profile.getDependencies().isEmpty() && (profile.getDependencyManagement() == null || profile.getDependencyManagement().getDependencies().isEmpty()) && profile.getDistributionManagement() == null && profile.getModules().isEmpty() && profile.getProperties().isEmpty() && profile.getRepositories().isEmpty() && profile.getPluginRepositories().isEmpty() && profile.getReporting() == null;
    }

    private static <T extends ModelBase.Builder> T prune(T builder, ModelBase model) {
        builder.properties(null).reporting(null);
        if (model.getDistributionManagement() != null && model.getDistributionManagement().getRelocation() != null) {
            builder.distributionManagement(DistributionManagement.newBuilder().relocation(model.getDistributionManagement().getRelocation()).build());
        }
        builder.pluginRepositories(DefaultConsumerPomBuilder.pruneRepositories(model.getPluginRepositories()));
        builder.repositories(DefaultConsumerPomBuilder.pruneRepositories(model.getRepositories()));
        return builder;
    }

    private static List<Repository> pruneRepositories(List<Repository> repositories) {
        return repositories.stream().filter(r -> !"central".equals(r.getId())).collect(Collectors.toList());
    }
}

