/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.services.LifecycleRegistry;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.LookupException;
import org.apache.maven.lifecycle.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultLifecycles {
    public static final String[] STANDARD_LIFECYCLES = new String[]{"clean", "default", "site", "wrapper"};
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Lookup lookup;
    private final LifecycleRegistry registry;
    private Map<String, Lifecycle> customLifecycles;

    public DefaultLifecycles() {
        this.lookup = null;
        this.registry = null;
    }

    @Deprecated
    public DefaultLifecycles(Map<String, Lifecycle> lifecycles, org.codehaus.plexus.logging.Logger logger) {
        this.customLifecycles = lifecycles;
        this.lookup = null;
        this.registry = null;
    }

    @Inject
    public DefaultLifecycles(LifecycleRegistry registry, Lookup lookup) {
        this.lookup = lookup;
        this.registry = registry;
    }

    public Lifecycle get(String phase) {
        return this.getPhaseToLifecycleMap().get(phase);
    }

    public Map<String, Lifecycle> getPhaseToLifecycleMap() {
        HashMap<String, Lifecycle> phaseToLifecycleMap = new HashMap<String, Lifecycle>();
        for (Lifecycle lifecycle : this.getLifeCycles()) {
            this.logger.debug("Lifecycle {}", (Object)lifecycle);
            for (String phase : lifecycle.getPhases()) {
                if (!phaseToLifecycleMap.containsKey(phase)) {
                    phaseToLifecycleMap.put(phase, lifecycle);
                    continue;
                }
                if (!this.logger.isWarnEnabled()) continue;
                Lifecycle original = (Lifecycle)phaseToLifecycleMap.get(phase);
                this.logger.warn("Duplicated lifecycle phase {}. Defined in {} but also in {}", new Object[]{phase, original.getId(), lifecycle.getId()});
            }
        }
        return phaseToLifecycleMap;
    }

    public List<Lifecycle> getLifeCycles() {
        List<String> lifecycleIds = Arrays.asList(STANDARD_LIFECYCLES);
        Comparator comparator = (l, r) -> {
            int lx = lifecycleIds.indexOf(l);
            int rx = lifecycleIds.indexOf(r);
            if (lx < 0 || rx < 0) {
                return rx - lx;
            }
            return lx - rx;
        };
        Map<String, Lifecycle> lifecyclesMap = this.lookupLifecycles();
        return lifecyclesMap.values().stream().peek(l -> Objects.requireNonNull(l.getId(), "A lifecycle must have an id.")).sorted(Comparator.comparing(Lifecycle::getId, comparator)).collect(Collectors.toList());
    }

    private Map<String, Lifecycle> lookupLifecycles() {
        if (this.lookup == null) {
            return this.customLifecycles != null ? this.customLifecycles : new HashMap<String, Lifecycle>();
        }
        try {
            return this.registry != null ? this.registry.stream().collect(Collectors.toMap(lf -> lf.id(), lf -> new Lifecycle((org.apache.maven.api.Lifecycle)lf))) : Map.of();
        }
        catch (LookupException e) {
            throw new IllegalStateException("Unable to lookup lifecycles from the plexus container", e);
        }
    }

    public String getLifecyclePhaseList() {
        return this.getLifeCycles().stream().flatMap(l -> l.getPhases().stream()).collect(Collectors.joining(", "));
    }
}

