/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.MultilineMessageHelper;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.MissingProjectException;
import org.apache.maven.lifecycle.internal.DependencyContext;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleDependencyResolver;
import org.apache.maven.lifecycle.internal.PhaseRecorder;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoExecutionRunner;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.MojosExecutionStrategy;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginIncompatibleException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class MojoExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MojoExecutor.class);
    private static final SessionData.Key<ProjectIndex> PROJECT_INDEX = SessionData.key(ProjectIndex.class);
    private static final SessionData.Key<Map<MavenProject, OwnerReentrantLock>> PROJECT_LOCKS = SessionData.key(Map.class, ProjectLock.class);
    private final BuildPluginManager pluginManager;
    private final MavenPluginManager mavenPluginManager;
    private final LifecycleDependencyResolver lifeCycleDependencyResolver;
    private final ExecutionEventCatapult eventCatapult;
    private final OwnerReentrantReadWriteLock aggregatorLock = new OwnerReentrantReadWriteLock();
    private final Provider<MojosExecutionStrategy> mojosExecutionStrategy;
    private final MessageBuilderFactory messageBuilderFactory;
    private final Map<Thread, MojoDescriptor> mojos = new ConcurrentHashMap<Thread, MojoDescriptor>();

    @Inject
    public MojoExecutor(BuildPluginManager pluginManager, MavenPluginManager mavenPluginManager, LifecycleDependencyResolver lifeCycleDependencyResolver, ExecutionEventCatapult eventCatapult, Provider<MojosExecutionStrategy> mojosExecutionStrategy, MessageBuilderFactory messageBuilderFactory) {
        this.pluginManager = pluginManager;
        this.mavenPluginManager = mavenPluginManager;
        this.lifeCycleDependencyResolver = lifeCycleDependencyResolver;
        this.eventCatapult = eventCatapult;
        this.mojosExecutionStrategy = mojosExecutionStrategy;
        this.messageBuilderFactory = messageBuilderFactory;
    }

    public DependencyContext newDependencyContext(MavenSession session, List<MojoExecution> mojoExecutions) {
        TreeSet<String> scopesToCollect = new TreeSet<String>();
        TreeSet<String> scopesToResolve = new TreeSet<String>();
        this.collectDependencyRequirements(scopesToResolve, scopesToCollect, mojoExecutions);
        return new DependencyContext(session.getCurrentProject(), scopesToCollect, scopesToResolve);
    }

    private void collectDependencyRequirements(Set<String> scopesToResolve, Set<String> scopesToCollect, Collection<MojoExecution> mojoExecutions) {
        for (MojoExecution mojoExecution : mojoExecutions) {
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            scopesToResolve.addAll(this.toScopes(mojoDescriptor.getDependencyResolutionRequired()));
            scopesToCollect.addAll(this.toScopes(mojoDescriptor.getDependencyCollectionRequired()));
        }
    }

    private Collection<String> toScopes(String classpath) {
        List<Object> scopes = Collections.emptyList();
        if (classpath != null && !classpath.isEmpty()) {
            if ("compile".equals(classpath)) {
                scopes = Arrays.asList("compile", "system", "provided");
            } else if ("runtime".equals(classpath)) {
                scopes = Arrays.asList("compile", "runtime");
            } else if ("compile+runtime".equals(classpath)) {
                scopes = Arrays.asList("compile", "system", "provided", "runtime");
            } else if ("runtime+system".equals(classpath)) {
                scopes = Arrays.asList("compile", "system", "runtime");
            } else if ("test".equals(classpath)) {
                scopes = Arrays.asList("compile", "system", "provided", "runtime", "test");
            }
        }
        return Collections.unmodifiableCollection(scopes);
    }

    public void execute(final MavenSession session, List<MojoExecution> mojoExecutions) throws LifecycleExecutionException {
        final DependencyContext dependencyContext = this.newDependencyContext(session, mojoExecutions);
        final PhaseRecorder phaseRecorder = new PhaseRecorder(session.getCurrentProject());
        ((MojosExecutionStrategy)this.mojosExecutionStrategy.get()).execute(mojoExecutions, session, new MojoExecutionRunner(){

            @Override
            public void run(MojoExecution mojoExecution) throws LifecycleExecutionException {
                MojoExecutor.this.execute(session, mojoExecution, dependencyContext, phaseRecorder);
            }
        });
    }

    private void execute(MavenSession session, MojoExecution mojoExecution, DependencyContext dependencyContext, PhaseRecorder phaseRecorder) throws LifecycleExecutionException {
        this.execute(session, mojoExecution, dependencyContext);
        phaseRecorder.observeExecution(mojoExecution);
    }

    private void execute(MavenSession session, MojoExecution mojoExecution, DependencyContext dependencyContext) throws LifecycleExecutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        try {
            this.mavenPluginManager.checkPrerequisites(mojoDescriptor.getPluginDescriptor());
        }
        catch (PluginIncompatibleException e) {
            throw new LifecycleExecutionException(this.messageBuilderFactory, mojoExecution, session.getCurrentProject(), (Throwable)e);
        }
        if (mojoDescriptor.isProjectRequired() && !session.getRequest().isProjectPresent()) {
            MissingProjectException cause = new MissingProjectException("Goal requires a project to execute but there is no POM in this directory (" + session.getExecutionRootDirectory() + "). Please verify you invoked Maven from the correct directory.");
            throw new LifecycleExecutionException(this.messageBuilderFactory, mojoExecution, null, (Throwable)cause);
        }
        if (mojoDescriptor.isOnlineRequired() && session.isOffline()) {
            if (MojoExecution.Source.CLI.equals((Object)mojoExecution.getSource())) {
                IllegalStateException cause = new IllegalStateException("Goal requires online mode for execution but Maven is currently offline.");
                throw new LifecycleExecutionException(this.messageBuilderFactory, mojoExecution, session.getCurrentProject(), (Throwable)cause);
            }
            this.eventCatapult.fire(ExecutionEvent.Type.MojoSkipped, session, mojoExecution);
            return;
        }
        this.doExecute(session, mojoExecution, dependencyContext);
    }

    private static void warn(String msg) {
        for (String s : MultilineMessageHelper.format(msg)) {
            LOGGER.warn(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(MavenSession session, MojoExecution mojoExecution, DependencyContext dependencyContext) throws LifecycleExecutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        List<MavenProject> forkedProjects = this.executeForkedExecutions(mojoExecution, session);
        this.ensureDependenciesAreResolved(mojoDescriptor, session, dependencyContext);
        try (ProjectLock lock = new ProjectLock(session, mojoDescriptor);){
            this.doExecute2(session, mojoExecution);
        }
        finally {
            for (MavenProject forkedProject : forkedProjects) {
                forkedProject.setExecutionProject(null);
            }
        }
    }

    private void doExecute2(MavenSession session, MojoExecution mojoExecution) throws LifecycleExecutionException {
        this.eventCatapult.fire(ExecutionEvent.Type.MojoStarted, session, mojoExecution);
        try {
            try {
                this.pluginManager.executeMojo(session, mojoExecution);
            }
            catch (MojoExecutionException | MojoFailureException | PluginConfigurationException | PluginManagerException e) {
                throw new LifecycleExecutionException(this.messageBuilderFactory, mojoExecution, session.getCurrentProject(), e);
            }
            this.eventCatapult.fire(ExecutionEvent.Type.MojoSucceeded, session, mojoExecution);
        }
        catch (LifecycleExecutionException e) {
            this.eventCatapult.fire(ExecutionEvent.Type.MojoFailed, session, mojoExecution, e);
            throw e;
        }
    }

    public void ensureDependenciesAreResolved(MojoDescriptor mojoDescriptor, MavenSession session, DependencyContext dependencyContext) throws LifecycleExecutionException {
        Collection<String> scopesToResolve;
        Collection<String> scopesToCollect;
        MavenProject project = dependencyContext.getProject();
        boolean aggregating = mojoDescriptor.isAggregator();
        if (dependencyContext.isResolutionRequiredForCurrentProject()) {
            scopesToCollect = dependencyContext.getScopesToCollectForCurrentProject();
            scopesToResolve = dependencyContext.getScopesToResolveForCurrentProject();
            this.lifeCycleDependencyResolver.resolveProjectDependencies(project, scopesToCollect, scopesToResolve, session, aggregating, Collections.emptySet());
            dependencyContext.synchronizeWithProjectState();
        }
        if (aggregating && dependencyContext.isResolutionRequiredForAggregatedProjects(scopesToCollect = this.toScopes(mojoDescriptor.getDependencyCollectionRequired()), scopesToResolve = this.toScopes(mojoDescriptor.getDependencyResolutionRequired()))) {
            for (MavenProject aggregatedProject : session.getProjects()) {
                if (aggregatedProject == project) continue;
                this.lifeCycleDependencyResolver.resolveProjectDependencies(aggregatedProject, scopesToCollect, scopesToResolve, session, aggregating, Collections.emptySet());
            }
        }
        ArtifactFilter artifactFilter = this.getArtifactFilter(mojoDescriptor);
        List<MavenProject> projectsToResolve = LifecycleDependencyResolver.getProjects(session.getCurrentProject(), session, mojoDescriptor.isAggregator());
        for (MavenProject projectToResolve : projectsToResolve) {
            projectToResolve.setArtifactFilter(artifactFilter);
        }
    }

    private ArtifactFilter getArtifactFilter(MojoDescriptor mojoDescriptor) {
        String scopeToResolve = mojoDescriptor.getDependencyResolutionRequired();
        String scopeToCollect = mojoDescriptor.getDependencyCollectionRequired();
        ArrayList<String> scopes = new ArrayList<String>(2);
        if (scopeToCollect != null && !scopeToCollect.isEmpty()) {
            scopes.add(scopeToCollect);
        }
        if (scopeToResolve != null && !scopeToResolve.isEmpty()) {
            scopes.add(scopeToResolve);
        }
        if (scopes.isEmpty()) {
            return null;
        }
        return new CumulativeScopeArtifactFilter(scopes);
    }

    public List<MavenProject> executeForkedExecutions(MojoExecution mojoExecution, MavenSession session) throws LifecycleExecutionException {
        List<MavenProject> forkedProjects = Collections.emptyList();
        Map<String, List<MojoExecution>> forkedExecutions = mojoExecution.getForkedExecutions();
        if (!forkedExecutions.isEmpty()) {
            this.eventCatapult.fire(ExecutionEvent.Type.ForkStarted, session, mojoExecution);
            MavenProject project = session.getCurrentProject();
            forkedProjects = new ArrayList<MavenProject>(forkedExecutions.size());
            try {
                for (Map.Entry<String, List<MojoExecution>> fork : forkedExecutions.entrySet()) {
                    String projectId = fork.getKey();
                    ProjectIndex projectIndex = (ProjectIndex)session.getSession().getData().computeIfAbsent(PROJECT_INDEX, () -> new ProjectIndex(session.getProjects()));
                    int index = projectIndex.getIndices().get(projectId);
                    MavenProject forkedProject = projectIndex.getProjects().get(projectId);
                    forkedProjects.add(forkedProject);
                    MavenProject executedProject = forkedProject.clone();
                    forkedProject.setExecutionProject(executedProject);
                    List<MojoExecution> mojoExecutions = fork.getValue();
                    if (mojoExecutions.isEmpty()) continue;
                    try {
                        session.setCurrentProject(executedProject);
                        session.getProjects().set(index, executedProject);
                        projectIndex.getProjects().put(projectId, executedProject);
                        this.eventCatapult.fire(ExecutionEvent.Type.ForkedProjectStarted, session, mojoExecution);
                        this.execute(session, mojoExecutions);
                        this.eventCatapult.fire(ExecutionEvent.Type.ForkedProjectSucceeded, session, mojoExecution);
                    }
                    catch (LifecycleExecutionException e) {
                        this.eventCatapult.fire(ExecutionEvent.Type.ForkedProjectFailed, session, mojoExecution, e);
                        throw e;
                    }
                    finally {
                        projectIndex.getProjects().put(projectId, forkedProject);
                        session.getProjects().set(index, forkedProject);
                        session.setCurrentProject(project);
                    }
                }
                this.eventCatapult.fire(ExecutionEvent.Type.ForkSucceeded, session, mojoExecution);
            }
            catch (LifecycleExecutionException e) {
                this.eventCatapult.fire(ExecutionEvent.Type.ForkFailed, session, mojoExecution, e);
                throw e;
            }
        }
        return forkedProjects;
    }

    static class OwnerReentrantReadWriteLock
    extends ReentrantReadWriteLock {
        OwnerReentrantReadWriteLock() {
        }

        @Override
        public Thread getOwner() {
            return super.getOwner();
        }
    }

    private class ProjectLock
    implements AutoCloseable {
        final Lock acquiredAggregatorLock;
        final OwnerReentrantLock acquiredProjectLock;

        ProjectLock(MavenSession session, MojoDescriptor mojoDescriptor) {
            MojoExecutor.this.mojos.put(Thread.currentThread(), mojoDescriptor);
            if (session.getRequest().getDegreeOfConcurrency() > 1) {
                String msg;
                String str;
                MojoDescriptor ownerMojo;
                Thread owner;
                boolean aggregator = mojoDescriptor.isAggregator();
                this.acquiredAggregatorLock = aggregator ? MojoExecutor.this.aggregatorLock.writeLock() : MojoExecutor.this.aggregatorLock.readLock();
                this.acquiredProjectLock = this.getProjectLock(session);
                if (!this.acquiredAggregatorLock.tryLock()) {
                    owner = MojoExecutor.this.aggregatorLock.getOwner();
                    ownerMojo = owner != null ? MojoExecutor.this.mojos.get(owner) : null;
                    str = ownerMojo != null ? " The " + ownerMojo.getId() : "An";
                    msg = str + " aggregator mojo is already being executed in this parallel build, those kind of mojos require exclusive access to reactor to prevent race conditions. This mojo execution will be blocked until the aggregator mojo is done.";
                    MojoExecutor.warn(msg);
                    this.acquiredAggregatorLock.lock();
                }
                if (!this.acquiredProjectLock.tryLock()) {
                    owner = this.acquiredProjectLock.getOwner();
                    ownerMojo = owner != null ? MojoExecutor.this.mojos.get(owner) : null;
                    str = ownerMojo != null ? " The " + ownerMojo.getId() : "A";
                    msg = str + " mojo is already being executed on the project " + session.getCurrentProject().getGroupId() + ":" + session.getCurrentProject().getArtifactId() + ". This mojo execution will be blocked until the mojo is done.";
                    MojoExecutor.warn(msg);
                    this.acquiredProjectLock.lock();
                }
            } else {
                this.acquiredAggregatorLock = null;
                this.acquiredProjectLock = null;
            }
        }

        @Override
        public void close() {
            if (this.acquiredProjectLock != null) {
                this.acquiredProjectLock.unlock();
            }
            if (this.acquiredAggregatorLock != null) {
                this.acquiredAggregatorLock.unlock();
            }
            MojoExecutor.this.mojos.remove(Thread.currentThread());
        }

        private OwnerReentrantLock getProjectLock(MavenSession session) {
            SessionData data = session.getSession().getData();
            Map locks = (Map)data.computeIfAbsent(PROJECT_LOCKS, ConcurrentHashMap::new);
            return locks.computeIfAbsent(session.getCurrentProject(), p -> new OwnerReentrantLock());
        }
    }

    static class OwnerReentrantLock
    extends ReentrantLock {
        OwnerReentrantLock() {
        }

        @Override
        public Thread getOwner() {
            return super.getOwner();
        }
    }
}

