/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.session.scope.internal;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SessionScope
implements Scope {
    private static final Provider<Object> SEEDED_KEY_PROVIDER = () -> {
        throw new IllegalStateException();
    };
    private final List<ScopeState> values = new CopyOnWriteArrayList<ScopeState>();

    public void enter() {
        this.values.add(0, new ScopeState());
    }

    protected ScopeState getScopeState() {
        if (this.values.isEmpty()) {
            throw new OutOfScopeException("Cannot access session scope outside of a scoping block");
        }
        return this.values.get(0);
    }

    public void exit() {
        if (this.values.isEmpty()) {
            throw new IllegalStateException();
        }
        this.values.remove(0);
    }

    public <T> void seed(Class<T> clazz, Provider<T> value) {
        this.getScopeState().seed(clazz, value);
    }

    public <T> void seed(Class<T> clazz, T value) {
        this.seed(clazz, (T)((Provider)() -> value));
    }

    public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
        return () -> {
            if (this.values.isEmpty()) {
                return this.createProxy(key, unscoped);
            }
            return this.getScopeState().scope(key, unscoped).get();
        };
    }

    private <T> T createProxy(Key<T> key, Provider<T> unscoped) {
        InvocationHandler dispatcher = (proxy, method, args) -> {
            method.setAccessible(true);
            try {
                return method.invoke(this.getScopeState().scope(key, unscoped).get(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        };
        Class superType = key.getTypeLiteral().getRawType();
        Class<?>[] interfaces = this.getInterfaces(superType);
        return (T)Proxy.newProxyInstance(superType.getClassLoader(), interfaces, dispatcher);
    }

    private Class<?>[] getInterfaces(Class<?> superType) {
        if (superType.isInterface()) {
            return new Class[]{superType};
        }
        for (Annotation a : superType.getAnnotations()) {
            Class<? extends Annotation> annotationType = a.annotationType();
            if (!"org.eclipse.sisu.Typed".equals(annotationType.getName()) && !"javax.enterprise.inject.Typed".equals(annotationType.getName()) && !"jakarta.enterprise.inject.Typed".equals(annotationType.getName())) continue;
            try {
                List nonInterfaces;
                Class[] value = (Class[])annotationType.getMethod("value", new Class[0]).invoke((Object)a, new Object[0]);
                if (value.length == 0) {
                    value = superType.getInterfaces();
                }
                if (!(nonInterfaces = Stream.of(value).filter(c -> !c.isInterface()).collect(Collectors.toList())).isEmpty()) {
                    throw new IllegalArgumentException("The Typed annotation must contain only interfaces but the following types are not: " + String.valueOf(nonInterfaces));
                }
                return value;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalArgumentException("The use of session scoped proxies require a org.eclipse.sisu.Typed or javax.enterprise.inject.Typed annotation");
    }

    public static <T> Provider<T> seededKeyProvider() {
        return SEEDED_KEY_PROVIDER;
    }

    public static <T> Provider<T> seededKeyProvider(Class<? extends T> clazz) {
        return () -> {
            throw new IllegalStateException("No instance of " + clazz.getName() + " is bound to the session scope.");
        };
    }

    protected static final class ScopeState {
        private final Map<Key<?>, CachingProvider<?>> provided = new ConcurrentHashMap();

        protected ScopeState() {
        }

        public <T> void seed(Class<T> clazz, Provider<T> value) {
            this.provided.put(Key.get(clazz), new CachingProvider<T>(value));
        }

        public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
            Provider provider = this.provided.computeIfAbsent(key, k -> new CachingProvider(unscoped));
            return provider;
        }

        public Collection<CachingProvider<?>> providers() {
            return this.provided.values();
        }
    }

    protected static class CachingProvider<T>
    implements Provider<T> {
        private final Provider<T> provider;
        private volatile T value;

        CachingProvider(Provider<T> provider) {
            this.provider = provider;
        }

        public T value() {
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            if (this.value == null) {
                CachingProvider cachingProvider = this;
                synchronized (cachingProvider) {
                    if (this.value == null) {
                        this.value = this.provider.get();
                    }
                }
            }
            return this.value;
        }
    }
}

