/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblem;

class DefaultModelBuilderResult
implements ModelBuilderResult {
    private Model fileModel;
    private Model activatedFileModel;
    private Model effectiveModel;
    private List<String> modelIds = new ArrayList<String>();
    private Map<String, Model> rawModels = new HashMap<String, Model>();
    private Map<String, List<Profile>> activePomProfiles = new HashMap<String, List<Profile>>();
    private List<Profile> activeExternalProfiles = new ArrayList<Profile>();
    private List<ModelProblem> problems = new ArrayList<ModelProblem>();

    DefaultModelBuilderResult() {
    }

    DefaultModelBuilderResult(ModelBuilderResult result) {
        this();
        this.activeExternalProfiles.addAll(result.getActiveExternalProfiles());
        this.effectiveModel = result.getEffectiveModel();
        this.fileModel = result.getFileModel();
        this.problems.addAll(result.getProblems());
        for (String modelId : result.getModelIds()) {
            this.modelIds.add(modelId);
            this.rawModels.put(modelId, (Model)result.getRawModel(modelId).orElseThrow());
            this.activePomProfiles.put(modelId, result.getActivePomProfiles(modelId));
        }
    }

    public Model getFileModel() {
        return this.fileModel;
    }

    public DefaultModelBuilderResult setFileModel(Model fileModel) {
        this.fileModel = fileModel;
        return this;
    }

    public Model getActivatedFileModel() {
        return this.activatedFileModel;
    }

    public DefaultModelBuilderResult setActivatedFileModel(Model activatedFileModel) {
        this.activatedFileModel = activatedFileModel;
        return this;
    }

    public Model getEffectiveModel() {
        return this.effectiveModel;
    }

    public DefaultModelBuilderResult setEffectiveModel(Model model) {
        this.effectiveModel = model;
        return this;
    }

    public List<String> getModelIds() {
        return this.modelIds;
    }

    public DefaultModelBuilderResult addModelId(String modelId) {
        Objects.requireNonNull(modelId, "modelId cannot be null");
        this.modelIds.add(modelId);
        return this;
    }

    public Model getRawModel() {
        return this.rawModels.get(this.modelIds.get(0));
    }

    public Optional<Model> getRawModel(String modelId) {
        return Optional.ofNullable(this.rawModels.get(modelId));
    }

    public DefaultModelBuilderResult setRawModel(String modelId, Model rawModel) {
        Objects.requireNonNull(modelId, "modelId cannot be null");
        this.rawModels.put(modelId, rawModel);
        return this;
    }

    public List<Profile> getActivePomProfiles(String modelId) {
        List<Profile> profiles = this.activePomProfiles.get(modelId);
        return profiles != null ? profiles : List.of();
    }

    public DefaultModelBuilderResult setActivePomProfiles(String modelId, List<Profile> activeProfiles) {
        Objects.requireNonNull(modelId, "modelId cannot be null");
        if (activeProfiles != null) {
            this.activePomProfiles.put(modelId, new ArrayList<Profile>(activeProfiles));
        } else {
            this.activePomProfiles.remove(modelId);
        }
        return this;
    }

    public List<Profile> getActiveExternalProfiles() {
        return this.activeExternalProfiles;
    }

    public DefaultModelBuilderResult setActiveExternalProfiles(List<Profile> activeProfiles) {
        if (activeProfiles != null) {
            this.activeExternalProfiles = new ArrayList<Profile>(activeProfiles);
        } else {
            this.activeExternalProfiles.clear();
        }
        return this;
    }

    public List<ModelProblem> getProblems() {
        return this.problems;
    }

    public DefaultModelBuilderResult setProblems(List<ModelProblem> problems) {
        if (problems != null) {
            this.problems = new ArrayList<ModelProblem>(problems);
        } else {
            this.problems.clear();
        }
        return this;
    }

    public String toString() {
        if (!this.modelIds.isEmpty()) {
            String modelId = this.modelIds.get(0);
            StringBuilder sb = new StringBuilder();
            sb.append(this.problems.size()).append(this.problems.size() == 1 ? " problem was " : " problems were encountered while building the effective model");
            if (modelId != null && !modelId.isEmpty()) {
                sb.append(" for ");
                sb.append(modelId);
            }
            for (ModelProblem problem : this.problems) {
                sb.append(System.lineSeparator());
                sb.append("    - [");
                sb.append(problem.getSeverity());
                sb.append("] ");
                sb.append(problem.getMessage());
                String[] stringArray = new String[4];
                stringArray[0] = problem.getModelId().equals(modelId) ? problem.getModelId() : "";
                stringArray[1] = problem.getModelId().equals(modelId) ? problem.getSource() : "";
                stringArray[2] = problem.getLineNumber() > 0 ? "line " + problem.getLineNumber() : "";
                String string = stringArray[3] = problem.getColumnNumber() > 0 ? "column " + problem.getColumnNumber() : "";
                String loc = Stream.of(stringArray).filter(s -> !s.isEmpty()).collect(Collectors.joining(", "));
                if (loc.isEmpty()) continue;
                sb.append(" @ ").append(loc);
            }
            return sb.toString();
        }
        return null;
    }
}

