/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model.profile;

import java.io.File;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.ProfileActivator;
import org.apache.maven.internal.impl.model.ProfileActivationFilePathInterpolator;
import org.codehaus.plexus.interpolation.InterpolationException;

@Named(value="file")
@Singleton
public class FileProfileActivator
implements ProfileActivator {
    private final ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator;

    @Inject
    public FileProfileActivator(ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator) {
        this.profileActivationFilePathInterpolator = profileActivationFilePathInterpolator;
    }

    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        boolean missing;
        String path;
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file = activation.getFile();
        if (file == null) {
            return false;
        }
        if (file.getExists() != null && !file.getExists().isEmpty()) {
            path = file.getExists();
            missing = false;
        } else if (file.getMissing() != null && !file.getMissing().isEmpty()) {
            path = file.getMissing();
            missing = true;
        } else {
            return false;
        }
        try {
            path = this.profileActivationFilePathInterpolator.interpolate(path, context);
        }
        catch (InterpolationException e) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Failed to interpolate file location " + path + " for profile " + profile.getId() + ": " + e.getMessage(), file.getLocation((Object)(missing ? "missing" : "exists")), (Exception)((Object)e));
            return false;
        }
        if (path == null) {
            return false;
        }
        File f = new File(path);
        if (!f.isAbsolute()) {
            return false;
        }
        boolean fileExists = f.exists();
        return missing != fileExists;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file = activation.getFile();
        return file != null;
    }
}

