/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.maven.doxia.module.fml.model.Faq;
import org.apache.maven.doxia.module.fml.model.Faqs;
import org.apache.maven.doxia.module.fml.model.Part;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class FmlParser
implements Parser {
    public void parse(Reader reader, Sink sink) throws ParseException {
        Faqs faqs;
        try {
            MXParser parser = new MXParser();
            parser.setInput(reader);
            faqs = this.parseFml((XmlPullParser)parser, sink);
        }
        catch (XmlPullParserException ex) {
            throw new ParseException("Error parsing the model: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new ParseException("Error reading the model: " + ex.getMessage(), (Exception)ex);
        }
        try {
            this.createSink(faqs, sink);
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Error creating sink: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ParseException("Error writing to sink: " + e.getMessage(), (Exception)e);
        }
    }

    public int getType() {
        return 2;
    }

    public Faqs parseFml(XmlPullParser parser, Sink sink) throws IOException, XmlPullParserException {
        Faqs faqs = new Faqs();
        Part currentPart = null;
        Faq currentFaq = null;
        boolean inQuestion = false;
        boolean inAnswer = false;
        StringBuffer buffer = null;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals("faqs")) {
                    String toplink;
                    String title = parser.getAttributeValue(null, "title");
                    if (title != null) {
                        faqs.setTitle(title);
                    }
                    if ((toplink = parser.getAttributeValue(null, "toplink")) != null) {
                        if (toplink.equalsIgnoreCase("true")) {
                            faqs.setToplink(true);
                        } else {
                            faqs.setToplink(false);
                        }
                    }
                } else if (parser.getName().equals("part")) {
                    currentPart = new Part();
                    currentPart.setId(parser.getAttributeValue(null, "id"));
                } else if (parser.getName().equals("title")) {
                    currentPart.setTitle(parser.nextText().trim());
                } else if (parser.getName().equals("faq")) {
                    currentFaq = new Faq();
                    currentFaq.setId(parser.getAttributeValue(null, "id"));
                }
                if (parser.getName().equals("question")) {
                    buffer = new StringBuffer();
                    inQuestion = true;
                } else if (parser.getName().equals("answer")) {
                    buffer = new StringBuffer();
                    inAnswer = true;
                } else if (inQuestion || inAnswer) {
                    buffer.append("<");
                    buffer.append(parser.getName());
                    int count = parser.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        buffer.append(" ");
                        buffer.append(parser.getAttributeName(i));
                        buffer.append("=");
                        buffer.append("\"");
                        buffer.append(HtmlTools.escapeHTML((String)parser.getAttributeValue(i)));
                        buffer.append("\"");
                    }
                    buffer.append(">");
                }
            } else if (eventType == 3) {
                if (!parser.getName().equals("faqs")) {
                    if (parser.getName().equals("part")) {
                        faqs.addPart(currentPart);
                        currentPart = null;
                    } else if (parser.getName().equals("faq")) {
                        currentPart.addFaq(currentFaq);
                        currentFaq = null;
                    }
                }
                if (parser.getName().equals("question")) {
                    currentFaq.setQuestion(buffer.toString());
                    inQuestion = false;
                } else if (parser.getName().equals("answer")) {
                    currentFaq.setAnswer(buffer.toString());
                    inAnswer = false;
                } else if (inQuestion || inAnswer) {
                    if (buffer.charAt(buffer.length() - 1) == ' ') {
                        buffer.deleteCharAt(buffer.length() - 1);
                    }
                    buffer.append("</");
                    buffer.append(parser.getName());
                    buffer.append(">");
                }
            } else if (eventType == 5) {
                if (buffer != null && parser.getText() != null) {
                    buffer.append("<![CDATA[");
                    buffer.append(parser.getText());
                    buffer.append("]]>");
                }
            } else if (eventType == 4) {
                if (buffer != null && parser.getText() != null) {
                    buffer.append(parser.getText());
                }
            } else if (eventType == 6 && buffer != null && parser.getText() != null) {
                buffer.append(HtmlTools.escapeHTML((String)parser.getText()));
            }
            eventType = parser.nextToken();
        }
        return faqs;
    }

    private void createSink(Faqs faqs, Sink sink) throws IOException, XmlPullParserException {
        Faq faq;
        Iterator faqIterator;
        Part part;
        sink.head();
        sink.title();
        sink.text(faqs.getTitle());
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.anchor("top");
        sink.text(faqs.getTitle());
        sink.anchor_();
        sink.sectionTitle1_();
        Iterator partIterator = faqs.getParts().iterator();
        while (partIterator.hasNext()) {
            part = (Part)partIterator.next();
            if (StringUtils.isNotEmpty((String)part.getTitle())) {
                sink.paragraph();
                sink.bold();
                sink.text(part.getTitle());
                sink.bold_();
                sink.paragraph_();
            }
            sink.numberedList(0);
            faqIterator = part.getFaqs().iterator();
            while (faqIterator.hasNext()) {
                faq = (Faq)faqIterator.next();
                sink.numberedListItem();
                sink.link("#" + HtmlTools.encodeId((String)faq.getId()));
                sink.rawText(faq.getQuestion());
                sink.link_();
                sink.numberedListItem_();
            }
            sink.numberedList_();
        }
        sink.section1_();
        partIterator = faqs.getParts().iterator();
        while (partIterator.hasNext()) {
            part = (Part)partIterator.next();
            if (StringUtils.isNotEmpty((String)part.getTitle())) {
                sink.section1();
                sink.sectionTitle1();
                sink.text(part.getTitle());
                sink.sectionTitle1_();
            }
            sink.definitionList();
            faqIterator = part.getFaqs().iterator();
            while (faqIterator.hasNext()) {
                faq = (Faq)faqIterator.next();
                sink.definedTerm();
                sink.anchor(faq.getId());
                sink.rawText(faq.getQuestion());
                sink.anchor_();
                sink.definedTerm_();
                sink.definition();
                sink.paragraph();
                this.writeAnswer(sink, faq.getAnswer());
                sink.paragraph_();
                if (faqs.isToplink()) {
                    this.writeTopLink(sink);
                }
                if (faqIterator.hasNext()) {
                    sink.horizontalRule();
                }
                sink.definition_();
            }
            sink.definitionList_();
            if (!StringUtils.isNotEmpty((String)part.getTitle())) continue;
            sink.section1_();
        }
        sink.body_();
    }

    private void writeAnswer(Sink sink, String answer) throws IOException, XmlPullParserException {
        int startSource = answer.indexOf("<source>");
        if (startSource != -1) {
            this.writeAnswerWithSource(sink, answer);
        } else {
            sink.rawText(answer);
        }
    }

    private void writeTopLink(Sink sink) {
        sink.rawText("<table border=\"0\">");
        sink.rawText("<tr><td align=\"right\">");
        sink.link("#top");
        sink.text("[top]");
        sink.link_();
        sink.rawText("</td></tr>");
        sink.rawText("</table>");
    }

    private void writeAnswerWithSource(Sink sink, String answer) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput((Reader)new StringReader("<answer>" + answer + "</answer>"));
        int countSource = 0;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals("source") && countSource == 0) {
                    sink.verbatim(true);
                    ++countSource;
                } else if (parser.getName().equals("source")) {
                    sink.rawText(HtmlTools.escapeHTML((String)("<" + parser.getName() + ">")));
                    ++countSource;
                } else if (!parser.getName().equals("answer")) {
                    if (countSource > 0) {
                        sink.rawText(HtmlTools.escapeHTML((String)("<" + parser.getName() + ">")));
                    } else {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("<" + parser.getName());
                        int count = parser.getAttributeCount();
                        for (int i = 0; i < count; ++i) {
                            buffer.append(" ");
                            buffer.append(parser.getAttributeName(i));
                            buffer.append("=");
                            buffer.append("\"");
                            buffer.append(HtmlTools.escapeHTML((String)parser.getAttributeValue(i)));
                            buffer.append("\"");
                        }
                        buffer.append(">");
                        sink.rawText(buffer.toString());
                    }
                }
            } else if (eventType == 3) {
                if (parser.getName().equals("source") && countSource == 1) {
                    --countSource;
                    sink.verbatim_();
                } else if (parser.getName().equals("source")) {
                    sink.rawText(HtmlTools.escapeHTML((String)("</" + parser.getName() + ">")));
                    --countSource;
                } else if (!parser.getName().equals("answer")) {
                    if (countSource > 0) {
                        sink.rawText(HtmlTools.escapeHTML((String)("</" + parser.getName() + ">")));
                    } else {
                        sink.rawText("</" + parser.getName() + ">");
                    }
                }
            } else if (eventType == 5) {
                sink.rawText(HtmlTools.escapeHTML((String)parser.getText()));
            } else if (eventType == 4) {
                sink.rawText(HtmlTools.escapeHTML((String)parser.getText()));
            } else if (eventType == 6) {
                sink.rawText(HtmlTools.escapeHTML((String)parser.getText()));
            }
            eventType = parser.nextToken();
        }
    }
}

