/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml5;

import java.io.Writer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.module.xhtml5.Xhtml5Markup;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.impl.Xhtml5BaseSink;
import org.apache.maven.doxia.util.HtmlTools;

public class Xhtml5Sink
extends Xhtml5BaseSink
implements Xhtml5Markup {
    private String encoding;
    private String languageId;
    private boolean headTitleFlag;

    protected Xhtml5Sink(Writer writer) {
        super(writer);
    }

    protected Xhtml5Sink(Writer writer, String encoding) {
        super(writer);
        this.encoding = encoding;
    }

    protected Xhtml5Sink(Writer writer, String encoding, String languageId) {
        this(writer, encoding);
        this.languageId = languageId;
    }

    public void head() {
        this.init();
        this.setHeadFlag(true);
        this.write("<!DOCTYPE html>");
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        if (this.languageId != null) {
            atts.addAttribute(HTML.Attribute.LANG.toString(), this.languageId);
            atts.addAttribute("xml:lang", this.languageId);
        }
        this.writeStartTag(HTML, (MutableAttributeSet)atts);
        this.writeStartTag(HEAD);
    }

    public void head_() {
        if (!this.isHeadTitleFlag()) {
            this.writeStartTag(TITLE);
            this.writeEndTag(TITLE);
        }
        this.setHeadFlag(false);
        this.setHeadTitleFlag(false);
        if (this.encoding != null) {
            this.write("<meta charset=\"" + this.encoding + "\"/>");
        }
        this.writeEndTag(HEAD);
    }

    public void title() {
        this.setHeadTitleFlag(true);
        this.writeStartTag(TITLE);
    }

    public void title_() {
        this.content(this.getTextBuffer().toString());
        this.writeEndTag(TITLE);
        this.resetTextBuffer();
    }

    public void author_() {
        if (this.getTextBuffer().length() > 0) {
            SinkEventAttributeSet att = new SinkEventAttributeSet();
            att.addAttribute(HTML.Attribute.NAME, "author");
            String text = HtmlTools.escapeHTML((String)this.getTextBuffer().toString());
            text = StringUtils.replace((String)text, (String)"&amp;#", (String)"&#");
            att.addAttribute(HTML.Attribute.CONTENT, text);
            this.writeSimpleTag(META, (MutableAttributeSet)att);
            this.resetTextBuffer();
        }
    }

    public void date_() {
        if (this.getTextBuffer().length() > 0) {
            SinkEventAttributeSet att = new SinkEventAttributeSet();
            att.addAttribute(HTML.Attribute.NAME, "date");
            att.addAttribute(HTML.Attribute.CONTENT, this.getTextBuffer().toString());
            this.writeSimpleTag(META, (MutableAttributeSet)att);
            this.resetTextBuffer();
        }
    }

    public void body() {
        this.writeStartTag(BODY);
    }

    public void body_() {
        this.writeEndTag(BODY);
        this.writeEndTag(HTML);
        this.flush();
        this.init();
    }

    protected void setHeadTitleFlag(boolean headTitleFlag) {
        this.headTitleFlag = headTitleFlag;
    }

    protected boolean isHeadTitleFlag() {
        return this.headTitleFlag;
    }
}

