/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.lang.ArrayUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.logging.PlexusLoggerWrapper;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.parser.module.ParserModule;
import org.apache.maven.doxia.parser.module.ParserModuleManager;
import org.apache.maven.doxia.parser.module.ParserModuleNotFoundException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.PublishDate;
import org.apache.maven.doxia.site.skin.SkinModel;
import org.apache.maven.doxia.site.skin.io.xpp3.SkinXpp3Reader;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.DoxiaDocumentRenderer;
import org.apache.maven.doxia.siterenderer.ExtraDoxiaModuleReference;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.util.XmlValidator;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.config.EasyFactoryConfiguration;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.generic.AlternatorTool;
import org.apache.velocity.tools.generic.ClassTool;
import org.apache.velocity.tools.generic.ComparisonDateTool;
import org.apache.velocity.tools.generic.ContextTool;
import org.apache.velocity.tools.generic.ConversionTool;
import org.apache.velocity.tools.generic.DisplayTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.FieldTool;
import org.apache.velocity.tools.generic.LinkTool;
import org.apache.velocity.tools.generic.LoopTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.RenderTool;
import org.apache.velocity.tools.generic.ResourceTool;
import org.apache.velocity.tools.generic.SortTool;
import org.apache.velocity.tools.generic.XmlTool;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.SiteResourceLoader;
import org.codehaus.plexus.velocity.VelocityComponent;

@Component(role=Renderer.class)
public class DefaultSiteRenderer
extends AbstractLogEnabled
implements Renderer {
    @Requirement(hint="doxia-site-renderer")
    private VelocityComponent velocity;
    @Requirement
    private ParserModuleManager parserModuleManager;
    @Requirement
    private Doxia doxia;
    @Requirement
    private I18N i18n;
    @Requirement
    private PlexusContainer plexus;
    private static final String RESOURCE_DIR = "org/apache/maven/doxia/siterenderer/resources";
    private static final String DEFAULT_TEMPLATE = "org/apache/maven/doxia/siterenderer/resources/default-site.vm";
    private static final String SKIN_TEMPLATE_LOCATION = "META-INF/maven/site.vm";

    @Override
    public Map<String, DocumentRenderer> locateDocumentFiles(SiteRenderingContext siteRenderingContext) throws IOException, RendererException {
        LinkedHashMap<String, DocumentRenderer> files = new LinkedHashMap<String, DocumentRenderer>();
        Map<String, String> moduleExcludes = siteRenderingContext.getModuleExcludes();
        for (File siteDirectory : siteRenderingContext.getSiteDirectories()) {
            if (!siteDirectory.exists()) continue;
            Collection modules = this.parserModuleManager.getParserModules();
            for (ParserModule module : modules) {
                File moduleBasedir = new File(siteDirectory, module.getSourceDirectory());
                String excludes = moduleExcludes == null ? null : moduleExcludes.get(module.getParserId());
                this.addModuleFiles(moduleBasedir, module, excludes, files);
            }
        }
        for (ExtraDoxiaModuleReference module : siteRenderingContext.getModules()) {
            try {
                ParserModule parserModule = this.parserModuleManager.getParserModule(module.getParserId());
                String excludes = moduleExcludes == null ? null : moduleExcludes.get(module.getParserId());
                this.addModuleFiles(module.getBasedir(), parserModule, excludes, files);
            }
            catch (ParserModuleNotFoundException e) {
                throw new RendererException("Unable to find module: " + e.getMessage(), e);
            }
        }
        return files;
    }

    private List<String> filterExtensionIgnoreCase(List<String> fileNames, String extension) {
        LinkedList<String> filtered = new LinkedList<String>(fileNames);
        Iterator it = filtered.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (DefaultSiteRenderer.endsWithIgnoreCase(name, extension)) continue;
            it.remove();
        }
        return filtered;
    }

    private void addModuleFiles(File moduleBasedir, ParserModule module, String excludes, Map<String, DocumentRenderer> files) throws IOException, RendererException {
        if (!moduleBasedir.exists() || ArrayUtils.isEmpty((Object[])module.getExtensions())) {
            return;
        }
        List allFiles = FileUtils.getFileNames((File)moduleBasedir, (String)"**/*.*", (String)excludes, (boolean)false);
        for (String extension : module.getExtensions()) {
            String fullExtension = "." + extension;
            List<String> docs = this.filterExtensionIgnoreCase(allFiles, fullExtension);
            List<String> velocityFiles = this.filterExtensionIgnoreCase(allFiles, fullExtension + ".vm");
            docs.addAll(velocityFiles);
            for (String doc : docs) {
                RenderingContext context = new RenderingContext(moduleBasedir, doc, module.getParserId(), extension);
                if (DefaultSiteRenderer.endsWithIgnoreCase(doc, ".vm")) {
                    context.setAttribute("velocity", "true");
                }
                String key = context.getOutputName();
                if (files.containsKey(key = StringUtils.replace((String)key, (String)"\\", (String)"/"))) {
                    DocumentRenderer renderer = files.get(key);
                    RenderingContext originalContext = renderer.getRenderingContext();
                    File originalDoc = new File(originalContext.getBasedir(), originalContext.getInputName());
                    throw new RendererException("File '" + module.getSourceDirectory() + File.separator + doc + "' clashes with existing '" + originalDoc + "'.");
                }
                for (Map.Entry<String, DocumentRenderer> entry : files.entrySet()) {
                    if (!entry.getKey().equalsIgnoreCase(key)) continue;
                    RenderingContext originalContext = entry.getValue().getRenderingContext();
                    File originalDoc = new File(originalContext.getBasedir(), originalContext.getInputName());
                    if (Os.isFamily((String)"windows")) {
                        throw new RendererException("File '" + module.getSourceDirectory() + File.separator + doc + "' clashes with existing '" + originalDoc + "'.");
                    }
                    if (!this.getLogger().isWarnEnabled()) continue;
                    this.getLogger().warn("File '" + module.getSourceDirectory() + File.separator + doc + "' could clash with existing '" + originalDoc + "'.");
                }
                files.put(key, new DoxiaDocumentRenderer(context));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Collection<DocumentRenderer> documents, SiteRenderingContext siteRenderingContext, File outputDirectory) throws RendererException, IOException {
        for (DocumentRenderer docRenderer : documents) {
            boolean modified;
            RenderingContext renderingContext = docRenderer.getRenderingContext();
            File outputFile = new File(outputDirectory, docRenderer.getOutputName());
            File inputFile = new File(renderingContext.getBasedir(), renderingContext.getInputName());
            boolean bl = modified = !outputFile.exists() || inputFile.lastModified() > outputFile.lastModified() || siteRenderingContext.getDecoration().getLastModified() > outputFile.lastModified();
            if (modified || docRenderer.isOverwrite()) {
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Generating " + outputFile);
                }
                Writer writer = null;
                try {
                    if (!docRenderer.isExternalReport()) {
                        writer = WriterFactory.newWriter((File)outputFile, (String)siteRenderingContext.getOutputEncoding());
                    }
                    docRenderer.renderDocument(writer, this, siteRenderingContext);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
                IOUtil.close((Writer)writer);
                continue;
            }
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug(inputFile + " unchanged, not regenerating...");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void renderDocument(Writer writer, RenderingContext renderingContext, SiteRenderingContext siteContext) throws RendererException, FileNotFoundException, UnsupportedEncodingException {
        SiteRendererSink sink = new SiteRendererSink(renderingContext);
        File doc = new File(renderingContext.getBasedir(), renderingContext.getInputName());
        Object reader = null;
        try {
            String resource = doc.getAbsolutePath();
            Parser parser = this.doxia.getParser(renderingContext.getParserId());
            parser.setEmitComments(false);
            if (renderingContext.getAttribute("velocity") != null) {
                this.getLogger().debug("Processing Velocity for " + renderingContext.getInputName());
                try {
                    SiteResourceLoader.setResource((String)resource);
                    Context vc = this.createDocumentVelocityContext(renderingContext, siteContext);
                    StringWriter sw = new StringWriter();
                    this.velocity.getEngine().mergeTemplate(resource, siteContext.getInputEncoding(), vc, (Writer)sw);
                    String doxiaContent = sw.toString();
                    if (siteContext.getProcessedContentOutput() != null) {
                        if (!siteContext.getProcessedContentOutput().exists()) {
                            siteContext.getProcessedContentOutput().mkdirs();
                        }
                        String input = renderingContext.getInputName();
                        File outputFile = new File(siteContext.getProcessedContentOutput(), input.substring(0, input.length() - 3));
                        File outputParent = outputFile.getParentFile();
                        if (!outputParent.exists()) {
                            outputParent.mkdirs();
                        }
                        FileUtils.fileWrite((File)outputFile, (String)siteContext.getInputEncoding(), (String)doxiaContent);
                    }
                    reader = new StringReader(doxiaContent);
                }
                catch (Exception e) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().error("Error parsing " + resource + " as a velocity template, using as text.", (Throwable)e);
                    }
                    this.getLogger().error("Error parsing " + resource + " as a velocity template, using as text.");
                }
                if (parser.getType() == 2 && siteContext.isValidate()) {
                    reader = this.validate((Reader)reader, resource);
                }
            } else {
                switch (parser.getType()) {
                    case 2: {
                        reader = ReaderFactory.newXmlReader((File)doc);
                        if (!siteContext.isValidate()) break;
                        reader = this.validate((Reader)reader, resource);
                        break;
                    }
                    default: {
                        reader = ReaderFactory.newReader((File)doc, (String)siteContext.getInputEncoding());
                    }
                }
            }
            sink.enableLogging((Log)new PlexusLoggerWrapper(this.getLogger()));
            if (reader == null) {
                throw new RendererException("Error getting a parser for '" + doc + "'");
            }
            this.doxia.parse((Reader)reader, renderingContext.getParserId(), (Sink)sink);
        }
        catch (ParserNotFoundException e) {
            try {
                throw new RendererException("Error getting a parser for '" + doc + "': " + e.getMessage(), e);
                catch (ParseException e2) {
                    throw new RendererException("Error parsing '" + doc + "': line [" + e2.getLineNumber() + "] " + e2.getMessage(), e2);
                }
                catch (IOException e3) {
                    throw new RendererException("IOException when processing '" + doc + "'", e3);
                }
            }
            catch (Throwable throwable) {
                sink.flush();
                sink.close();
                IOUtil.close(reader);
                throw throwable;
            }
        }
        sink.flush();
        sink.close();
        IOUtil.close((Reader)reader);
        this.generateDocument(writer, sink, siteContext);
    }

    protected Context createToolManagedVelocityContext(SiteRenderingContext siteRenderingContext) {
        Locale locale = siteRenderingContext.getLocale();
        String dateFormat = siteRenderingContext.getDecoration().getPublishDate().getFormat();
        EasyFactoryConfiguration config = new EasyFactoryConfiguration(false);
        config.property("safeMode", (Object)Boolean.FALSE);
        config.toolbox("request").tool(ContextTool.class).tool(LinkTool.class).tool(LoopTool.class).tool(RenderTool.class);
        config.toolbox("application").property("locale", (Object)locale).tool(AlternatorTool.class).tool(ClassTool.class).tool(ComparisonDateTool.class).property("format", (Object)dateFormat).tool(ConversionTool.class).property("dateFormat", (Object)dateFormat).tool(DisplayTool.class).tool(EscapeTool.class).tool(FieldTool.class).tool(MathTool.class).tool(NumberTool.class).tool(ResourceTool.class).property("bundles", (Object)new String[]{"site-renderer"}).tool(SortTool.class).tool(XmlTool.class);
        ToolManager manager = new ToolManager(false, false);
        manager.configure((FactoryConfiguration)config);
        return manager.createContext();
    }

    protected Context createDocumentVelocityContext(RenderingContext renderingContext, SiteRenderingContext siteRenderingContext) {
        Context context = this.createToolManagedVelocityContext(siteRenderingContext);
        context.put("relativePath", (Object)renderingContext.getRelativePath());
        String currentFileName = renderingContext.getOutputName().replace('\\', '/');
        context.put("currentFileName", (Object)currentFileName);
        context.put("alignedFileName", (Object)PathTool.calculateLink((String)currentFileName, (String)renderingContext.getRelativePath()));
        context.put("decoration", (Object)siteRenderingContext.getDecoration());
        Locale locale = siteRenderingContext.getLocale();
        context.put("locale", (Object)locale);
        context.put("supportedLocales", Collections.unmodifiableList(siteRenderingContext.getSiteLocales()));
        context.put("currentDate", (Object)new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        context.put("dateRevision", (Object)sdf.format(new Date()));
        context.put("publishDate", (Object)siteRenderingContext.getPublishDate());
        PublishDate publishDate = siteRenderingContext.getDecoration().getPublishDate();
        SimpleDateFormat dateFormat = new SimpleDateFormat(publishDate.getFormat(), locale);
        context.put("dateFormat", (Object)dateFormat);
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/maven/org.apache.maven.doxia/doxia-site-renderer/pom.properties");
        Properties properties = PropertyUtils.loadProperties((InputStream)inputStream);
        if (inputStream == null) {
            this.getLogger().debug("pom.properties for doxia-site-renderer could not be found.");
        } else if (properties == null) {
            this.getLogger().debug("Failed to load pom.properties, so doxiaVersion is not available in the Velocity context.");
        } else {
            context.put("doxiaSiteRendererVersion", (Object)properties.getProperty("version"));
        }
        Map<String, ?> templateProperties = siteRenderingContext.getTemplateProperties();
        if (templateProperties != null) {
            for (Map.Entry<String, ?> entry : templateProperties.entrySet()) {
                context.put(entry.getKey(), entry.getValue());
            }
        }
        context.put("PathTool", (Object)new PathTool());
        context.put("FileUtils", (Object)new FileUtils());
        context.put("StringUtils", (Object)new StringUtils());
        context.put("i18n", (Object)this.i18n);
        context.put("plexus", (Object)this.plexus);
        return context;
    }

    protected Context createSiteTemplateVelocityContext(SiteRendererSink siteRendererSink, SiteRenderingContext siteRenderingContext) {
        Context context = this.createDocumentVelocityContext(siteRendererSink.getRenderingContext(), siteRenderingContext);
        context.put("authors", siteRendererSink.getAuthors());
        context.put("shortTitle", (Object)siteRendererSink.getTitle());
        String title = "";
        if (siteRenderingContext.getDecoration() != null && siteRenderingContext.getDecoration().getName() != null) {
            title = siteRenderingContext.getDecoration().getName();
        } else if (siteRenderingContext.getDefaultWindowTitle() != null) {
            title = siteRenderingContext.getDefaultWindowTitle();
        }
        if (title.length() > 0) {
            title = title + " &#x2013; ";
        }
        title = title + siteRendererSink.getTitle();
        context.put("title", (Object)title);
        context.put("headContent", (Object)siteRendererSink.getHead());
        context.put("bodyContent", (Object)siteRendererSink.getBody());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        if (StringUtils.isNotEmpty((String)siteRendererSink.getDate())) {
            String documentDate = siteRendererSink.getDate();
            try {
                Date creationDate = new SimpleDateFormat("yyyy-MM-dd").parse(documentDate);
                context.put("creationDate", (Object)creationDate);
                context.put("dateCreation", (Object)sdf.format(creationDate));
            }
            catch (java.text.ParseException e) {
                this.getLogger().warn("Could not parse date '" + documentDate + "' from " + siteRendererSink.getRenderingContext().getInputName() + " (expected yyyy-MM-dd format), ignoring!");
            }
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDocument(Writer writer, SiteRendererSink sink, SiteRenderingContext siteRenderingContext) throws RendererException {
        String templateName = siteRenderingContext.getTemplateName();
        this.getLogger().debug("Processing Velocity for template " + templateName + " on " + sink.getRenderingContext().getInputName());
        Context context = this.createSiteTemplateVelocityContext(sink, siteRenderingContext);
        ClassLoader old = null;
        if (siteRenderingContext.getTemplateClassLoader() != null) {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(siteRenderingContext.getTemplateClassLoader());
        }
        try {
            Template template;
            try {
                SkinModel skinModel = siteRenderingContext.getSkinModel();
                String encoding = skinModel == null ? null : skinModel.getEncoding();
                template = encoding == null ? this.velocity.getEngine().getTemplate(templateName) : this.velocity.getEngine().getTemplate(templateName, encoding);
            }
            catch (Exception e) {
                throw new RendererException("Could not find the site decoration template '" + templateName + "'", e);
            }
            try {
                template.merge(context, writer);
            }
            catch (Exception e) {
                throw new RendererException("Error while merging site decoration template.", e);
            }
        }
        finally {
            IOUtil.close((Writer)writer);
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    private SiteRenderingContext createSiteRenderingContext(Map<String, ?> attributes, DecorationModel decoration, String defaultWindowTitle, Locale locale) {
        SiteRenderingContext context = new SiteRenderingContext();
        context.setTemplateProperties(attributes);
        context.setLocale(locale);
        context.setDecoration(decoration);
        context.setDefaultWindowTitle(defaultWindowTitle);
        return context;
    }

    @Override
    public SiteRenderingContext createContextForSkin(File skinFile, Map<String, ?> attributes, DecorationModel decoration, String defaultWindowTitle, Locale locale) throws IOException, RendererException {
        SiteRenderingContext context = this.createSiteRenderingContext(attributes, decoration, defaultWindowTitle, locale);
        context.setSkinJarFile(skinFile);
        ZipFile zipFile = DefaultSiteRenderer.getZipFile(skinFile);
        InputStream in = null;
        try {
            if (zipFile.getEntry(SKIN_TEMPLATE_LOCATION) != null) {
                context.setTemplateName(SKIN_TEMPLATE_LOCATION);
                context.setTemplateClassLoader(new URLClassLoader(new URL[]{skinFile.toURI().toURL()}));
            } else {
                context.setTemplateName(DEFAULT_TEMPLATE);
                context.setTemplateClassLoader(this.getClass().getClassLoader());
                context.setUsingDefaultTemplate(true);
            }
            ZipEntry skinDescriptorEntry = zipFile.getEntry("META-INF/maven/skin.xml");
            if (skinDescriptorEntry != null) {
                String current;
                in = zipFile.getInputStream(skinDescriptorEntry);
                SkinModel skinModel = new SkinXpp3Reader().read(in);
                context.setSkinModel(skinModel);
                String toolsPrerequisite = skinModel.getPrerequisites() == null ? null : skinModel.getPrerequisites().getDoxiaSitetools();
                Package p = DefaultSiteRenderer.class.getPackage();
                String string = current = p == null ? null : p.getSpecificationVersion();
                if (StringUtils.isNotBlank((String)toolsPrerequisite) && current != null && !this.matchVersion(current, toolsPrerequisite)) {
                    throw new RendererException("Cannot use skin: has " + toolsPrerequisite + " Doxia Sitetools prerequisite, but current is " + current);
                }
            }
        }
        catch (XmlPullParserException e) {
            throw new RendererException("Failed to parse META-INF/maven/skin.xml skin descriptor from " + skinFile, e);
        }
        finally {
            IOUtil.close(in);
            DefaultSiteRenderer.closeZipFile(zipFile);
        }
        return context;
    }

    boolean matchVersion(String current, String prerequisite) throws RendererException {
        try {
            DefaultArtifactVersion v = new DefaultArtifactVersion(current);
            VersionRange vr = VersionRange.createFromVersionSpec((String)prerequisite);
            boolean matched = false;
            ArtifactVersion recommendedVersion = vr.getRecommendedVersion();
            if (recommendedVersion == null) {
                List restrictions = vr.getRestrictions();
                for (Restriction restriction : restrictions) {
                    if (!restriction.containsVersion((ArtifactVersion)v)) continue;
                    matched = true;
                    break;
                }
            } else {
                int compareTo = recommendedVersion.compareTo((Object)v);
                boolean bl = matched = compareTo <= 0;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Skin doxia-sitetools prerequisite: " + prerequisite + ", current: " + current + ", matched = " + matched);
            }
            return matched;
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RendererException("Invalid skin doxia-sitetools prerequisite: " + prerequisite, e);
        }
    }

    @Override
    @Deprecated
    public SiteRenderingContext createContextForTemplate(File templateFile, Map<String, ?> attributes, DecorationModel decoration, String defaultWindowTitle, Locale locale) throws MalformedURLException {
        SiteRenderingContext context = this.createSiteRenderingContext(attributes, decoration, defaultWindowTitle, locale);
        context.setTemplateName(templateFile.getName());
        context.setTemplateClassLoader(new URLClassLoader(new URL[]{templateFile.getParentFile().toURI().toURL()}));
        return context;
    }

    @Override
    public void copyResources(SiteRenderingContext siteRenderingContext, File resourcesDirectory, File outputDirectory) throws IOException {
        throw new AssertionError((Object)"copyResources( SiteRenderingContext, File, File ) is deprecated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyResources(SiteRenderingContext siteRenderingContext, File outputDirectory) throws IOException {
        block21: {
            InputStream resourceList;
            if (siteRenderingContext.getSkinJarFile() != null) {
                ZipFile file = DefaultSiteRenderer.getZipFile(siteRenderingContext.getSkinJarFile());
                try {
                    Enumeration<? extends ZipEntry> e = file.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        if (entry.getName().startsWith("META-INF/")) continue;
                        File destFile = new File(outputDirectory, entry.getName());
                        if (!entry.isDirectory()) {
                            if (destFile.exists()) continue;
                            destFile.getParentFile().mkdirs();
                            DefaultSiteRenderer.copyFileFromZip(file, entry, destFile);
                            continue;
                        }
                        destFile.mkdirs();
                    }
                }
                finally {
                    DefaultSiteRenderer.closeZipFile(file);
                }
            }
            if (!siteRenderingContext.isUsingDefaultTemplate() || (resourceList = this.getClass().getClassLoader().getResourceAsStream("org/apache/maven/doxia/siterenderer/resources/resources.txt")) == null) break block21;
            Reader r = null;
            LineNumberReader reader = null;
            try {
                String line;
                r = ReaderFactory.newReader((InputStream)resourceList, (String)"UTF-8");
                reader = new LineNumberReader(r);
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().length() == 0) continue;
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/maven/doxia/siterenderer/resources/" + line);
                    if (is == null) {
                        throw new IOException("The resource " + line + " doesn't exist.");
                    }
                    File outputFile = new File(outputDirectory, line);
                    if (outputFile.exists()) continue;
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    FileOutputStream os = null;
                    try {
                        os = new FileOutputStream(outputFile);
                        IOUtil.copy((InputStream)is, (OutputStream)os);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(os);
                        throw throwable;
                    }
                    IOUtil.close((OutputStream)os);
                    IOUtil.close((InputStream)is);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                IOUtil.close((Reader)r);
                throw throwable;
            }
            IOUtil.close((Reader)reader);
            IOUtil.close((Reader)r);
        }
        for (File siteDirectory : siteRenderingContext.getSiteDirectories()) {
            File resourcesDirectory = new File(siteDirectory, "resources");
            if (resourcesDirectory == null || !resourcesDirectory.exists()) continue;
            this.copyDirectory(resourcesDirectory, outputDirectory);
        }
        File siteCssFile = new File(outputDirectory, "/css/site.css");
        if (!siteCssFile.exists()) {
            File cssDirectory = new File(outputDirectory, "/css/");
            boolean created = cssDirectory.mkdirs();
            if (created && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The directory '" + cssDirectory.getAbsolutePath() + "' did not exist. It was created.");
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The file '" + siteCssFile.getAbsolutePath() + "' does not exist. Creating an empty file.");
            }
            Writer writer = null;
            try {
                writer = WriterFactory.newWriter((File)siteCssFile, (String)siteRenderingContext.getOutputEncoding());
                writer.write("/* You can override this file with your own styles */");
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
            IOUtil.close((Writer)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileFromZip(ZipFile file, ZipEntry entry, File destFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(destFile);
        try {
            IOUtil.copy((InputStream)file.getInputStream(entry), (OutputStream)fos);
        }
        finally {
            IOUtil.close((OutputStream)fos);
        }
    }

    protected void copyDirectory(File source, File destination) throws IOException {
        if (source.exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            String[] includedResources = new String[]{"**/**"};
            scanner.setIncludes(includedResources);
            scanner.addDefaultExcludes();
            scanner.setBasedir(source);
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            for (String name : includedFiles) {
                File sourceFile = new File(source, name);
                File destinationFile = new File(destination, name);
                FileUtils.copyFile((File)sourceFile, (File)destinationFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader validate(Reader source, String resource) throws ParseException, IOException {
        this.getLogger().debug("Validating: " + resource);
        try {
            String content = IOUtil.toString((Reader)new BufferedReader(source));
            new XmlValidator((Log)new PlexusLoggerWrapper(this.getLogger())).validate(content);
            StringReader stringReader = new StringReader(content);
            return stringReader;
        }
        finally {
            IOUtil.close((Reader)source);
        }
    }

    static boolean endsWithIgnoreCase(String str, String searchStr) {
        if (str.length() < searchStr.length()) {
            return false;
        }
        return str.regionMatches(true, str.length() - searchStr.length(), searchStr, 0, searchStr.length());
    }

    private static ZipFile getZipFile(File file) throws IOException {
        if (file == null) {
            throw new IOException("Error opening ZipFile: null");
        }
        try {
            return new ZipFile(file);
        }
        catch (ZipException ex) {
            IOException ioe = new IOException("Error opening ZipFile: " + file.getAbsolutePath());
            ioe.initCause(ex);
            throw ioe;
        }
    }

    private static void closeZipFile(ZipFile zipFile) {
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

