/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.hash;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.maven.buildcache.hash.CloseableBuffer;

public class ThreadLocalBuffer {
    private static final ConcurrentMap<CloseableBuffer, Boolean> LOCALS = new ConcurrentHashMap<CloseableBuffer, Boolean>();

    public static ByteBuffer get(ThreadLocal<CloseableBuffer> local, int capacity) {
        CloseableBuffer buffer = local.get();
        if (buffer == null) {
            return ThreadLocalBuffer.create(local, capacity);
        }
        if (ThreadLocalBuffer.capacity(buffer) < capacity) {
            ThreadLocalBuffer.close(buffer);
            return ThreadLocalBuffer.create(local, capacity * 2);
        }
        return ThreadLocalBuffer.clear(buffer);
    }

    public void finalize() {
        for (CloseableBuffer buffer : LOCALS.keySet()) {
            buffer.close();
        }
    }

    private static ByteBuffer create(ThreadLocal<CloseableBuffer> local, int capacity) {
        CloseableBuffer buffer = CloseableBuffer.directBuffer(capacity);
        local.set(buffer);
        LOCALS.put(buffer, false);
        return buffer.getBuffer();
    }

    private static int capacity(CloseableBuffer buffer) {
        return buffer.getBuffer().capacity();
    }

    private static ByteBuffer clear(CloseableBuffer buffer) {
        return (ByteBuffer)buffer.getBuffer().clear();
    }

    private static void close(CloseableBuffer buffer) {
        LOCALS.remove(buffer);
        buffer.close();
    }

    private ThreadLocalBuffer() {
    }
}

