/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.hash;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.openhft.hashing.LongHashFunction;
import org.apache.maven.buildcache.hash.CloseableBuffer;
import org.apache.maven.buildcache.hash.Hash;
import org.apache.maven.buildcache.hash.HexUtils;

public class Zah
implements Hash.Factory {
    private final String name;
    private final LongHashFunction hash;
    private final MemoryPolicy memoryPolicy;

    public Zah(String name, LongHashFunction hash, MemoryPolicy memoryPolicy) {
        this.name = name;
        this.hash = hash;
        this.memoryPolicy = memoryPolicy != null ? memoryPolicy : MemoryPolicy.Standard;
    }

    @Override
    public String getAlgorithm() {
        return this.name;
    }

    @Override
    public Hash.Algorithm algorithm() {
        switch (this.memoryPolicy) {
            case MemoryMappedBuffers: {
                return new AlgorithmWithMM();
            }
        }
        return new Algorithm();
    }

    @Override
    public Hash.Checksum checksum(int count) {
        return new Checksum(ByteBuffer.allocate(Zah.capacity(count)));
    }

    static int capacity(int count) {
        return count * 64 / 8;
    }

    public static enum MemoryPolicy {
        Standard,
        MemoryMappedBuffers;

    }

    class AlgorithmWithMM
    implements Hash.Algorithm {
        AlgorithmWithMM() {
        }

        @Override
        public byte[] hash(byte[] array) {
            return HexUtils.toByteArray(Zah.this.hash.hashBytes(array));
        }

        @Override
        public byte[] hash(Path path) throws IOException {
            try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
                CloseableBuffer buffer = CloseableBuffer.mappedBuffer(channel, FileChannel.MapMode.READ_ONLY);
                try {
                    byte[] byArray = HexUtils.toByteArray(Zah.this.hash.hashBytes(buffer.getBuffer()));
                    if (buffer != null) {
                        buffer.close();
                    }
                    return byArray;
                }
                catch (Throwable throwable) {
                    if (buffer != null) {
                        try {
                            buffer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    class Algorithm
    implements Hash.Algorithm {
        Algorithm() {
        }

        @Override
        public byte[] hash(byte[] array) {
            return HexUtils.toByteArray(Zah.this.hash.hashBytes(array));
        }

        @Override
        public byte[] hash(Path path) throws IOException {
            return this.hash(Files.readAllBytes(path));
        }
    }

    class Checksum
    implements Hash.Checksum {
        private final ByteBuffer buffer;

        Checksum(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void update(byte[] hash) {
            this.buffer.put(hash);
        }

        @Override
        public byte[] digest() {
            return HexUtils.toByteArray(Zah.this.hash.hashBytes(this.buffer, 0, this.buffer.position()));
        }
    }
}

