/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.xml;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.maven.SessionScoped;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.DefaultPluginScanConfig;
import org.apache.maven.buildcache.PluginScanConfig;
import org.apache.maven.buildcache.PluginScanConfigImpl;
import org.apache.maven.buildcache.hash.HashFactory;
import org.apache.maven.buildcache.xml.CacheState;
import org.apache.maven.buildcache.xml.XmlService;
import org.apache.maven.buildcache.xml.config.AttachedOutputs;
import org.apache.maven.buildcache.xml.config.CacheConfig;
import org.apache.maven.buildcache.xml.config.Configuration;
import org.apache.maven.buildcache.xml.config.CoordinatesBase;
import org.apache.maven.buildcache.xml.config.DirName;
import org.apache.maven.buildcache.xml.config.Exclude;
import org.apache.maven.buildcache.xml.config.Executables;
import org.apache.maven.buildcache.xml.config.ExecutionConfigurationScan;
import org.apache.maven.buildcache.xml.config.ExecutionControl;
import org.apache.maven.buildcache.xml.config.ExecutionIdsList;
import org.apache.maven.buildcache.xml.config.GoalReconciliation;
import org.apache.maven.buildcache.xml.config.GoalsList;
import org.apache.maven.buildcache.xml.config.Include;
import org.apache.maven.buildcache.xml.config.Input;
import org.apache.maven.buildcache.xml.config.Local;
import org.apache.maven.buildcache.xml.config.MultiModule;
import org.apache.maven.buildcache.xml.config.PathSet;
import org.apache.maven.buildcache.xml.config.PluginConfigurationScan;
import org.apache.maven.buildcache.xml.config.PluginSet;
import org.apache.maven.buildcache.xml.config.ProjectVersioning;
import org.apache.maven.buildcache.xml.config.PropertyName;
import org.apache.maven.buildcache.xml.config.Remote;
import org.apache.maven.buildcache.xml.config.TrackedProperty;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named
public class CacheConfigImpl
implements org.apache.maven.buildcache.xml.CacheConfig {
    public static final String CONFIG_PATH_PROPERTY_NAME = "maven.build.cache.configPath";
    public static final String CACHE_ENABLED_PROPERTY_NAME = "maven.build.cache.enabled";
    public static final String CACHE_LOCATION_PROPERTY_NAME = "maven.build.cache.location";
    public static final String REMOTE_ENABLED_PROPERTY_NAME = "maven.build.cache.remote.enabled";
    public static final String REMOTE_URL_PROPERTY_NAME = "maven.build.cache.remote.url";
    public static final String REMOTE_SERVER_ID_PROPERTY_NAME = "maven.build.cache.remote.server.id";
    public static final String SAVE_TO_REMOTE_PROPERTY_NAME = "maven.build.cache.remote.save.enabled";
    public static final String SAVE_NON_OVERRIDEABLE_NAME = "maven.build.cache.remote.save.final";
    public static final String FAIL_FAST_PROPERTY_NAME = "maven.build.cache.failFast";
    public static final String BASELINE_BUILD_URL_PROPERTY_NAME = "maven.build.cache.baselineUrl";
    public static final String LAZY_RESTORE_PROPERTY_NAME = "maven.build.cache.lazyRestore";
    public static final String RESTORE_ON_DISK_ARTIFACTS_PROPERTY_NAME = "maven.build.cache.restoreOnDiskArtifacts";
    public static final String RESTORE_GENERATED_SOURCES_PROPERTY_NAME = "maven.build.cache.restoreGeneratedSources";
    public static final String ALWAYS_RUN_PLUGINS = "maven.build.cache.alwaysRunPlugins";
    public static final String MANDATORY_CLEAN = "maven.build.cache.mandatoryClean";
    public static final String CACHE_SKIP = "maven.build.cache.skipCache";
    public static final String SKIP_SAVE = "maven.build.cache.skipSave";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheConfigImpl.class);
    private final XmlService xmlService;
    private final Provider<MavenSession> providerSession;
    private final RuntimeInformation rtInfo;
    private volatile CacheState state;
    private CacheConfig cacheConfig;
    private HashFactory hashFactory;
    private List<Pattern> excludePatterns;

    @Inject
    public CacheConfigImpl(XmlService xmlService, Provider<MavenSession> providerSession, RuntimeInformation rtInfo) {
        this.xmlService = xmlService;
        this.providerSession = providerSession;
        this.rtInfo = rtInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public CacheState initialize() {
        if (this.state == null) {
            CacheConfigImpl cacheConfigImpl = this;
            synchronized (cacheConfigImpl) {
                if (this.state == null) {
                    boolean enabled = this.getProperty(CACHE_ENABLED_PROPERTY_NAME, true);
                    if (!this.rtInfo.isMavenVersion("[3.9.0,)")) {
                        LOGGER.warn("Cache requires Maven >= 3.9, but version is {}. Disabling cache.", (Object)this.rtInfo.getMavenVersion());
                        this.state = CacheState.DISABLED;
                    } else if (!enabled) {
                        LOGGER.info("Cache disabled by command line flag, project will be built fully and not cached");
                        this.state = CacheState.DISABLED;
                    } else {
                        Path configPath;
                        String configPathText = this.getProperty(CONFIG_PATH_PROPERTY_NAME, null);
                        if (StringUtils.isNotBlank((CharSequence)configPathText)) {
                            configPath = Paths.get(configPathText, new String[0]);
                        } else {
                            MavenSession session = (MavenSession)this.providerSession.get();
                            configPath = CacheUtils.getMultimoduleRoot(session).resolve(".mvn").resolve("maven-build-cache-config.xml");
                        }
                        if (!Files.exists(configPath, new LinkOption[0])) {
                            LOGGER.info("Cache configuration is not available at configured path {}, cache is enabled with defaults", (Object)configPath);
                            this.cacheConfig = new CacheConfig();
                        } else {
                            try {
                                LOGGER.info("Loading cache configuration from {}", (Object)configPath);
                                this.cacheConfig = this.xmlService.loadCacheConfig(configPath.toFile());
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException("Cannot initialize cache because xml config is not valid or not available", e);
                            }
                        }
                        this.fillWithDefaults(this.cacheConfig);
                        boolean cacheEnabled = this.getProperty(CACHE_ENABLED_PROPERTY_NAME, this.getConfiguration().isEnabled());
                        if (!cacheEnabled) {
                            this.state = CacheState.DISABLED;
                        } else {
                            String hashAlgorithm = null;
                            try {
                                hashAlgorithm = this.getConfiguration().getHashAlgorithm();
                                this.hashFactory = HashFactory.of(hashAlgorithm);
                                LOGGER.info("Using {} hash algorithm for cache", (Object)hashAlgorithm);
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException("Unsupported hashing algorithm: " + hashAlgorithm, e);
                            }
                            this.excludePatterns = this.compileExcludePatterns();
                            this.state = CacheState.INITIALIZED;
                        }
                    }
                }
            }
        }
        return this.state;
    }

    private void fillWithDefaults(CacheConfig cacheConfig) {
        Input input;
        Configuration configuration;
        if (cacheConfig.getConfiguration() == null) {
            cacheConfig.setConfiguration(new Configuration());
        }
        if ((configuration = cacheConfig.getConfiguration()).getLocal() == null) {
            configuration.setLocal(new Local());
        }
        if (configuration.getRemote() == null) {
            configuration.setRemote(new Remote());
        }
        if (cacheConfig.getInput() == null) {
            cacheConfig.setInput(new Input());
        }
        if ((input = cacheConfig.getInput()).getGlobal() == null) {
            input.setGlobal(new PathSet());
        }
    }

    @Override
    @Nonnull
    public List<TrackedProperty> getTrackedProperties(MojoExecution mojoExecution) {
        this.checkInitializedState();
        GoalReconciliation reconciliationConfig = this.findReconciliationConfig(mojoExecution);
        if (reconciliationConfig != null) {
            return reconciliationConfig.getReconciles();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isLogAllProperties(MojoExecution mojoExecution) {
        GoalReconciliation reconciliationConfig = this.findReconciliationConfig(mojoExecution);
        if (reconciliationConfig != null && reconciliationConfig.isLogAll()) {
            return true;
        }
        return this.cacheConfig.getExecutionControl() != null && this.cacheConfig.getExecutionControl().getReconcile() != null && this.cacheConfig.getExecutionControl().getReconcile().isLogAllProperties();
    }

    private GoalReconciliation findReconciliationConfig(MojoExecution mojoExecution) {
        if (this.cacheConfig.getExecutionControl() == null) {
            return null;
        }
        ExecutionControl executionControl = this.cacheConfig.getExecutionControl();
        if (executionControl.getReconcile() == null) {
            return null;
        }
        List<GoalReconciliation> reconciliation = executionControl.getReconcile().getPlugins();
        for (GoalReconciliation goalReconciliationConfig : reconciliation) {
            String goal = mojoExecution.getGoal();
            if (!this.isPluginMatch(mojoExecution.getPlugin(), goalReconciliationConfig) || !Strings.CS.equals(goal, goalReconciliationConfig.getGoal())) continue;
            return goalReconciliationConfig;
        }
        return null;
    }

    @Override
    @Nonnull
    public List<PropertyName> getLoggedProperties(MojoExecution mojoExecution) {
        this.checkInitializedState();
        GoalReconciliation reconciliationConfig = this.findReconciliationConfig(mojoExecution);
        if (reconciliationConfig != null) {
            return reconciliationConfig.getLogs();
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<PropertyName> getNologProperties(MojoExecution mojoExecution) {
        this.checkInitializedState();
        GoalReconciliation reconciliationConfig = this.findReconciliationConfig(mojoExecution);
        if (reconciliationConfig != null) {
            return reconciliationConfig.getNologs();
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<String> getEffectivePomExcludeProperties(Plugin plugin) {
        this.checkInitializedState();
        PluginConfigurationScan pluginConfig = this.findPluginScanConfig(plugin);
        if (pluginConfig != null && pluginConfig.getEffectivePom() != null) {
            return pluginConfig.getEffectivePom().getExcludeProperties();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isPluginDependenciesExcluded(Plugin plugin) {
        this.checkInitializedState();
        PluginConfigurationScan pluginConfig = this.findPluginScanConfig(plugin);
        if (pluginConfig != null) {
            return pluginConfig.isExcludeDependencies();
        }
        return false;
    }

    @Override
    @Nullable
    public MultiModule getMultiModule() {
        this.checkInitializedState();
        return this.cacheConfig.getConfiguration().getMultiModule();
    }

    private PluginConfigurationScan findPluginScanConfig(Plugin plugin) {
        if (this.cacheConfig.getInput() == null) {
            return null;
        }
        List<PluginConfigurationScan> pluginConfigs = this.cacheConfig.getInput().getPlugins();
        for (PluginConfigurationScan pluginConfig : pluginConfigs) {
            if (!this.isPluginMatch(plugin, pluginConfig)) continue;
            return pluginConfig;
        }
        return null;
    }

    private boolean isPluginMatch(Plugin plugin, CoordinatesBase pluginConfig) {
        return Strings.CS.equals(pluginConfig.getArtifactId(), plugin.getArtifactId()) && (pluginConfig.getGroupId() == null || Strings.CS.equals(pluginConfig.getGroupId(), plugin.getGroupId()));
    }

    @Override
    @Nonnull
    public PluginScanConfig getPluginDirScanConfig(Plugin plugin) {
        this.checkInitializedState();
        PluginConfigurationScan pluginConfig = this.findPluginScanConfig(plugin);
        if (pluginConfig == null || pluginConfig.getDirScan() == null) {
            return new DefaultPluginScanConfig();
        }
        return new PluginScanConfigImpl(pluginConfig.getDirScan());
    }

    @Override
    @Nonnull
    public PluginScanConfig getExecutionDirScanConfig(Plugin plugin, PluginExecution exec) {
        ExecutionConfigurationScan executionScanConfig;
        this.checkInitializedState();
        PluginConfigurationScan pluginScanConfig = this.findPluginScanConfig(plugin);
        if (pluginScanConfig != null && (executionScanConfig = this.findExecutionScanConfig(exec, pluginScanConfig.getExecutions())) != null && executionScanConfig.getDirScan() != null) {
            return new PluginScanConfigImpl(executionScanConfig.getDirScan());
        }
        return new DefaultPluginScanConfig();
    }

    private ExecutionConfigurationScan findExecutionScanConfig(PluginExecution execution, List<ExecutionConfigurationScan> scanConfigs) {
        for (ExecutionConfigurationScan executionScanConfig : scanConfigs) {
            if (!executionScanConfig.getExecIds().contains(execution.getId())) continue;
            return executionScanConfig;
        }
        return null;
    }

    @Override
    public String isProcessPlugins() {
        this.checkInitializedState();
        return Boolean.TRUE.toString();
    }

    @Override
    public String getDefaultGlob() {
        this.checkInitializedState();
        return StringUtils.trim((String)this.cacheConfig.getInput().getGlobal().getGlob());
    }

    @Override
    @Nonnull
    public List<Include> getGlobalIncludePaths() {
        this.checkInitializedState();
        return this.cacheConfig.getInput().getGlobal().getIncludes();
    }

    @Override
    @Nonnull
    public List<Exclude> getGlobalExcludePaths() {
        this.checkInitializedState();
        return this.cacheConfig.getInput().getGlobal().getExcludes();
    }

    @Override
    @Nonnull
    public HashFactory getHashFactory() {
        this.checkInitializedState();
        return this.hashFactory;
    }

    @Override
    public boolean canIgnore(MojoExecution mojoExecution) {
        this.checkInitializedState();
        if (this.cacheConfig.getExecutionControl() == null || this.cacheConfig.getExecutionControl().getIgnoreMissing() == null) {
            return false;
        }
        return this.executionMatches(mojoExecution, this.cacheConfig.getExecutionControl().getIgnoreMissing());
    }

    @Override
    public boolean isForcedExecution(MojoExecution execution) {
        this.checkInitializedState();
        if (this.cacheConfig.getExecutionControl() == null || this.cacheConfig.getExecutionControl().getRunAlways() == null) {
            return false;
        }
        return this.executionMatches(execution, this.cacheConfig.getExecutionControl().getRunAlways());
    }

    private boolean executionMatches(MojoExecution execution, Executables executablesType) {
        List<PluginSet> pluginConfigs = executablesType.getPlugins();
        for (PluginSet pluginSet : pluginConfigs) {
            if (!this.isPluginMatch(execution.getPlugin(), pluginSet)) continue;
            return true;
        }
        List<ExecutionIdsList> executionIds = executablesType.getExecutions();
        for (ExecutionIdsList executionConfig : executionIds) {
            if (!this.isPluginMatch(execution.getPlugin(), executionConfig) || !executionConfig.getExecIds().contains(execution.getExecutionId())) continue;
            return true;
        }
        List<GoalsList> list = executablesType.getGoalsLists();
        for (GoalsList pluginGoals : list) {
            if (!this.isPluginMatch(execution.getPlugin(), pluginGoals) || !pluginGoals.getGoals().contains(execution.getGoal())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.state == CacheState.INITIALIZED;
    }

    @Override
    public boolean isRemoteCacheEnabled() {
        this.checkInitializedState();
        return this.getUrl() != null && this.getProperty(REMOTE_ENABLED_PROPERTY_NAME, this.getRemote().isEnabled());
    }

    @Override
    public boolean isSaveToRemote() {
        return this.isRemoteCacheEnabled() && this.getProperty(SAVE_TO_REMOTE_PROPERTY_NAME, this.getRemote().isSaveToRemote());
    }

    @Override
    public boolean isSaveToRemoteFinal() {
        return this.isSaveToRemote() && this.getProperty(SAVE_NON_OVERRIDEABLE_NAME, false);
    }

    @Override
    public boolean isSkipCache() {
        return this.getProperty(CACHE_SKIP, false);
    }

    @Override
    public boolean isFailFast() {
        return this.getProperty(FAIL_FAST_PROPERTY_NAME, false);
    }

    @Override
    public boolean isBaselineDiffEnabled() {
        return this.getProperty(BASELINE_BUILD_URL_PROPERTY_NAME, null) != null;
    }

    @Override
    public String getBaselineCacheUrl() {
        return this.getProperty(BASELINE_BUILD_URL_PROPERTY_NAME, null);
    }

    @Override
    public boolean isLazyRestore() {
        return this.getProperty(LAZY_RESTORE_PROPERTY_NAME, false);
    }

    @Override
    public boolean isRestoreGeneratedSources() {
        return this.getProperty(RESTORE_GENERATED_SOURCES_PROPERTY_NAME, true);
    }

    @Override
    public boolean isRestoreOnDiskArtifacts() {
        return this.getProperty(RESTORE_ON_DISK_ARTIFACTS_PROPERTY_NAME, true);
    }

    @Override
    public String getAlwaysRunPlugins() {
        return this.getProperty(ALWAYS_RUN_PLUGINS, null);
    }

    @Override
    public boolean isSkipSave() {
        return this.getProperty(SKIP_SAVE, false);
    }

    @Override
    public boolean isMandatoryClean() {
        return this.getProperty(MANDATORY_CLEAN, this.getConfiguration().isMandatoryClean());
    }

    @Override
    public String getId() {
        this.checkInitializedState();
        return this.getProperty(REMOTE_SERVER_ID_PROPERTY_NAME, this.getRemote().getId());
    }

    @Override
    public String getUrl() {
        this.checkInitializedState();
        return this.getProperty(REMOTE_URL_PROPERTY_NAME, this.getRemote().getUrl());
    }

    @Override
    public String getTransport() {
        this.checkInitializedState();
        return this.getRemote().getTransport();
    }

    @Override
    public int getMaxLocalBuildsCached() {
        this.checkInitializedState();
        return this.getLocal().getMaxBuildsCached();
    }

    @Override
    public String getLocalRepositoryLocation() {
        this.checkInitializedState();
        return this.getProperty(CACHE_LOCATION_PROPERTY_NAME, this.getLocal().getLocation());
    }

    @Override
    public List<DirName> getAttachedOutputs() {
        this.checkInitializedState();
        AttachedOutputs attachedOutputs = this.getConfiguration().getAttachedOutputs();
        return attachedOutputs == null ? Collections.emptyList() : attachedOutputs.getDirNames();
    }

    @Override
    public boolean isPreservePermissions() {
        this.checkInitializedState();
        AttachedOutputs attachedOutputs = this.getConfiguration().getAttachedOutputs();
        return attachedOutputs == null || attachedOutputs.isPreservePermissions();
    }

    @Override
    public boolean adjustMetaInfVersion() {
        if (this.isEnabled()) {
            return Optional.ofNullable(this.getConfiguration().getProjectVersioning()).map(ProjectVersioning::isAdjustMetaInf).orElse(false);
        }
        return false;
    }

    @Override
    public boolean calculateProjectVersionChecksum() {
        if (this.isEnabled()) {
            return Optional.ofNullable(this.getConfiguration().getProjectVersioning()).map(ProjectVersioning::isCalculateProjectVersionChecksum).orElse(false);
        }
        return false;
    }

    @Override
    @Nonnull
    public List<Pattern> getExcludePatterns() {
        this.checkInitializedState();
        return this.excludePatterns;
    }

    private List<Pattern> compileExcludePatterns() {
        if (this.cacheConfig.getOutput() != null && this.cacheConfig.getOutput().getExclude() != null) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String pattern : this.cacheConfig.getOutput().getExclude().getPatterns()) {
                patterns.add(Pattern.compile(pattern));
            }
            return patterns;
        }
        return Collections.emptyList();
    }

    private Remote getRemote() {
        return this.getConfiguration().getRemote();
    }

    private Local getLocal() {
        return this.getConfiguration().getLocal();
    }

    private Configuration getConfiguration() {
        return this.cacheConfig.getConfiguration();
    }

    private void checkInitializedState() {
        if (this.state != CacheState.INITIALIZED) {
            throw new IllegalStateException("Cache is not initialized. Actual state: " + (Object)((Object)this.state));
        }
    }

    private String getProperty(String key, String defaultValue) {
        MavenSession session = (MavenSession)this.providerSession.get();
        String value = session.getUserProperties().getProperty(key);
        if (value == null && (value = session.getSystemProperties().getProperty(key)) == null) {
            value = defaultValue;
        }
        return value;
    }

    private boolean getProperty(String key, boolean defaultValue) {
        MavenSession session = (MavenSession)this.providerSession.get();
        String value = session.getUserProperties().getProperty(key);
        if (value == null && (value = session.getSystemProperties().getProperty(key)) == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }
}

