/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.xml.config.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.buildcache.xml.config.AttachedOutputs;
import org.apache.maven.buildcache.xml.config.CacheConfig;
import org.apache.maven.buildcache.xml.config.Configuration;
import org.apache.maven.buildcache.xml.config.CoordinatesBase;
import org.apache.maven.buildcache.xml.config.DirName;
import org.apache.maven.buildcache.xml.config.DirScanConfig;
import org.apache.maven.buildcache.xml.config.Discovery;
import org.apache.maven.buildcache.xml.config.EffectivePom;
import org.apache.maven.buildcache.xml.config.Exclude;
import org.apache.maven.buildcache.xml.config.Executables;
import org.apache.maven.buildcache.xml.config.ExecutionConfigurationScan;
import org.apache.maven.buildcache.xml.config.ExecutionControl;
import org.apache.maven.buildcache.xml.config.ExecutionIdsList;
import org.apache.maven.buildcache.xml.config.GoalId;
import org.apache.maven.buildcache.xml.config.GoalReconciliation;
import org.apache.maven.buildcache.xml.config.GoalsList;
import org.apache.maven.buildcache.xml.config.Include;
import org.apache.maven.buildcache.xml.config.Input;
import org.apache.maven.buildcache.xml.config.Local;
import org.apache.maven.buildcache.xml.config.MultiModule;
import org.apache.maven.buildcache.xml.config.Output;
import org.apache.maven.buildcache.xml.config.OutputExclude;
import org.apache.maven.buildcache.xml.config.PathSet;
import org.apache.maven.buildcache.xml.config.PluginConfigurationScan;
import org.apache.maven.buildcache.xml.config.PluginSet;
import org.apache.maven.buildcache.xml.config.ProjectVersioning;
import org.apache.maven.buildcache.xml.config.PropertyName;
import org.apache.maven.buildcache.xml.config.Reconcile;
import org.apache.maven.buildcache.xml.config.Remote;
import org.apache.maven.buildcache.xml.config.TagExclude;
import org.apache.maven.buildcache.xml.config.TagScanConfig;
import org.apache.maven.buildcache.xml.config.TrackedProperty;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class BuildCacheConfigXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, CacheConfig cacheConfig) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(cacheConfig.getModelEncoding(), null);
        this.writeCacheConfig(cacheConfig, "cache", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, CacheConfig cacheConfig) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, cacheConfig.getModelEncoding());
        serializer.startDocument(cacheConfig.getModelEncoding(), null);
        this.writeCacheConfig(cacheConfig, "cache", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeAttachedOutputs(AttachedOutputs attachedOutputs, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!attachedOutputs.isPreservePermissions()) {
            serializer.startTag(NAMESPACE, "preservePermissions").text(String.valueOf(attachedOutputs.isPreservePermissions())).endTag(NAMESPACE, "preservePermissions");
        }
        if (attachedOutputs.getDirNames() != null && attachedOutputs.getDirNames().size() > 0) {
            serializer.startTag(NAMESPACE, "dirNames");
            for (DirName o : attachedOutputs.getDirNames()) {
                this.writeDirName(o, "dirName", serializer);
            }
            serializer.endTag(NAMESPACE, "dirNames");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCacheConfig(CacheConfig cacheConfig, String tagName, XmlSerializer serializer) throws IOException {
        if (this.fileComment != null) {
            serializer.comment(this.fileComment);
        }
        serializer.setPrefix("", "http://maven.apache.org/BUILD-CACHE-CONFIG/1.2.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/BUILD-CACHE-CONFIG/1.2.0 https://maven.apache.org/xsd/build-cache-config-1.2.0.xsd");
        if (cacheConfig.getConfiguration() != null) {
            this.writeConfiguration(cacheConfig.getConfiguration(), "configuration", serializer);
        }
        if (cacheConfig.getInput() != null) {
            this.writeInput(cacheConfig.getInput(), "input", serializer);
        }
        if (cacheConfig.getOutput() != null) {
            this.writeOutput(cacheConfig.getOutput(), "output", serializer);
        }
        if (cacheConfig.getExecutionControl() != null) {
            this.writeExecutionControl(cacheConfig.getExecutionControl(), "executionControl", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeConfiguration(Configuration configuration, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!configuration.isEnabled()) {
            serializer.startTag(NAMESPACE, "enabled").text(String.valueOf(configuration.isEnabled())).endTag(NAMESPACE, "enabled");
        }
        if (configuration.getHashAlgorithm() != null && !configuration.getHashAlgorithm().equals("XX")) {
            serializer.startTag(NAMESPACE, "hashAlgorithm").text(configuration.getHashAlgorithm()).endTag(NAMESPACE, "hashAlgorithm");
        }
        if (configuration.isValidateXml()) {
            serializer.startTag(NAMESPACE, "validateXml").text(String.valueOf(configuration.isValidateXml())).endTag(NAMESPACE, "validateXml");
        }
        if (configuration.isMandatoryClean()) {
            serializer.startTag(NAMESPACE, "mandatoryClean").text(String.valueOf(configuration.isMandatoryClean())).endTag(NAMESPACE, "mandatoryClean");
        }
        if (configuration.getMultiModule() != null) {
            this.writeMultiModule(configuration.getMultiModule(), "multiModule", serializer);
        }
        if (configuration.getProjectVersioning() != null) {
            this.writeProjectVersioning(configuration.getProjectVersioning(), "projectVersioning", serializer);
        }
        if (configuration.getRemote() != null) {
            this.writeRemote(configuration.getRemote(), "remote", serializer);
        }
        if (configuration.getAttachedOutputs() != null) {
            this.writeAttachedOutputs(configuration.getAttachedOutputs(), "attachedOutputs", serializer);
        }
        if (configuration.getLocal() != null) {
            this.writeLocal(configuration.getLocal(), "local", serializer);
        }
        if (configuration.getDebugs() != null && configuration.getDebugs().size() > 0) {
            serializer.startTag(NAMESPACE, "debugs");
            for (String debug : configuration.getDebugs()) {
                serializer.startTag(NAMESPACE, "debug").text(debug).endTag(NAMESPACE, "debug");
            }
            serializer.endTag(NAMESPACE, "debugs");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCoordinatesBase(CoordinatesBase coordinatesBase, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (coordinatesBase.getGroupId() != null) {
            serializer.attribute(NAMESPACE, "groupId", coordinatesBase.getGroupId());
        }
        if (coordinatesBase.getArtifactId() != null) {
            serializer.attribute(NAMESPACE, "artifactId", coordinatesBase.getArtifactId());
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDirName(DirName dirName, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (dirName.getGlob() != null && !dirName.getGlob().equals("*")) {
            serializer.attribute(NAMESPACE, "glob", dirName.getGlob());
        }
        serializer.text(dirName.getValue());
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDirScanConfig(DirScanConfig dirScanConfig, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (dirScanConfig.isIgnoreParent()) {
            serializer.attribute(NAMESPACE, "ignoreParent", String.valueOf(dirScanConfig.isIgnoreParent()));
        }
        if (dirScanConfig.getMode() != null) {
            serializer.attribute(NAMESPACE, "mode", dirScanConfig.getMode());
        }
        if (dirScanConfig.getIncludes() != null && dirScanConfig.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            for (TagScanConfig tagScanConfig : dirScanConfig.getIncludes()) {
                this.writeTagScanConfig(tagScanConfig, "include", serializer);
            }
            serializer.endTag(NAMESPACE, "includes");
        }
        if (dirScanConfig.getExcludes() != null && dirScanConfig.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (TagExclude tagExclude : dirScanConfig.getExcludes()) {
                this.writeTagExclude(tagExclude, "exclude", serializer);
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        if (dirScanConfig.getTagScanConfigs() != null && dirScanConfig.getTagScanConfigs().size() > 0) {
            serializer.startTag(NAMESPACE, "tagScanConfigs");
            for (TagScanConfig tagScanConfig : dirScanConfig.getTagScanConfigs()) {
                this.writeTagScanConfig(tagScanConfig, "tagScanConfig", serializer);
            }
            serializer.endTag(NAMESPACE, "tagScanConfigs");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDiscovery(Discovery discovery, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (discovery.getScanProfiles() != null && discovery.getScanProfiles().size() > 0) {
            serializer.startTag(NAMESPACE, "scanProfiles");
            for (String scanProfile : discovery.getScanProfiles()) {
                serializer.startTag(NAMESPACE, "scanProfile").text(scanProfile).endTag(NAMESPACE, "scanProfile");
            }
            serializer.endTag(NAMESPACE, "scanProfiles");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeEffectivePom(EffectivePom effectivePom, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (effectivePom.getExcludeProperties() != null && effectivePom.getExcludeProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "excludeProperties");
            for (String excludeProperty : effectivePom.getExcludeProperties()) {
                serializer.startTag(NAMESPACE, "excludeProperty").text(excludeProperty).endTag(NAMESPACE, "excludeProperty");
            }
            serializer.endTag(NAMESPACE, "excludeProperties");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeExclude(Exclude exclude, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (exclude.getGlob() != null && !exclude.getGlob().equals("**")) {
            serializer.attribute(NAMESPACE, "glob", exclude.getGlob());
        }
        if (exclude.getEntryType() != null && !exclude.getEntryType().equals("ALL")) {
            serializer.attribute(NAMESPACE, "entryType", exclude.getEntryType());
        }
        if (exclude.getMatcherType() != null && !exclude.getMatcherType().equals("FILENAME")) {
            serializer.attribute(NAMESPACE, "matcherType", exclude.getMatcherType());
        }
        serializer.text(exclude.getValue());
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeExecutables(Executables executables, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (executables.getPlugins() != null && executables.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "plugins");
            for (PluginSet pluginSet : executables.getPlugins()) {
                this.writePluginSet(pluginSet, "plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "plugins");
        }
        if (executables.getExecutions() != null && executables.getExecutions().size() > 0) {
            serializer.startTag(NAMESPACE, "executions");
            for (ExecutionIdsList executionIdsList : executables.getExecutions()) {
                this.writeExecutionIdsList(executionIdsList, "execution", serializer);
            }
            serializer.endTag(NAMESPACE, "executions");
        }
        if (executables.getGoalsLists() != null && executables.getGoalsLists().size() > 0) {
            serializer.startTag(NAMESPACE, "goalsLists");
            for (GoalsList goalsList : executables.getGoalsLists()) {
                this.writeGoalsList(goalsList, "goalsList", serializer);
            }
            serializer.endTag(NAMESPACE, "goalsLists");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeExecutionConfigurationScan(ExecutionConfigurationScan executionConfigurationScan, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (executionConfigurationScan.isIgnoreParentConfig()) {
            serializer.attribute(NAMESPACE, "ignoreParentConfig", String.valueOf(executionConfigurationScan.isIgnoreParentConfig()));
        }
        if (executionConfigurationScan.getExecIds() != null && executionConfigurationScan.getExecIds().size() > 0) {
            serializer.startTag(NAMESPACE, "execIds");
            for (String execId : executionConfigurationScan.getExecIds()) {
                serializer.startTag(NAMESPACE, "execId").text(execId).endTag(NAMESPACE, "execId");
            }
            serializer.endTag(NAMESPACE, "execIds");
        }
        if (executionConfigurationScan.getDirScan() != null) {
            this.writeDirScanConfig(executionConfigurationScan.getDirScan(), "dirScan", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeExecutionControl(ExecutionControl executionControl, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (executionControl.getRunAlways() != null) {
            this.writeExecutables(executionControl.getRunAlways(), "runAlways", serializer);
        }
        if (executionControl.getIgnoreMissing() != null) {
            this.writeExecutables(executionControl.getIgnoreMissing(), "ignoreMissing", serializer);
        }
        if (executionControl.getReconcile() != null) {
            this.writeReconcile(executionControl.getReconcile(), "reconcile", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeExecutionIdsList(ExecutionIdsList executionIdsList, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (executionIdsList.getGroupId() != null) {
            serializer.attribute(NAMESPACE, "groupId", executionIdsList.getGroupId());
        }
        if (executionIdsList.getArtifactId() != null) {
            serializer.attribute(NAMESPACE, "artifactId", executionIdsList.getArtifactId());
        }
        if (executionIdsList.getExecIds() != null && executionIdsList.getExecIds().size() > 0) {
            serializer.startTag(NAMESPACE, "execIds");
            for (String execId : executionIdsList.getExecIds()) {
                serializer.startTag(NAMESPACE, "execId").text(execId).endTag(NAMESPACE, "execId");
            }
            serializer.endTag(NAMESPACE, "execIds");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeGoalId(GoalId goalId, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (goalId.getGoal() != null) {
            serializer.attribute(NAMESPACE, "goal", goalId.getGoal());
        }
        if (goalId.getGroupId() != null) {
            serializer.attribute(NAMESPACE, "groupId", goalId.getGroupId());
        }
        if (goalId.getArtifactId() != null) {
            serializer.attribute(NAMESPACE, "artifactId", goalId.getArtifactId());
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeGoalReconciliation(GoalReconciliation goalReconciliation, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (goalReconciliation.getGoal() != null) {
            serializer.attribute(NAMESPACE, "goal", goalReconciliation.getGoal());
        }
        if (goalReconciliation.getGroupId() != null) {
            serializer.attribute(NAMESPACE, "groupId", goalReconciliation.getGroupId());
        }
        if (goalReconciliation.getArtifactId() != null) {
            serializer.attribute(NAMESPACE, "artifactId", goalReconciliation.getArtifactId());
        }
        if (goalReconciliation.getReconciles() != null && goalReconciliation.getReconciles().size() > 0) {
            serializer.startTag(NAMESPACE, "reconciles");
            for (TrackedProperty trackedProperty : goalReconciliation.getReconciles()) {
                this.writeTrackedProperty(trackedProperty, "reconcile", serializer);
            }
            serializer.endTag(NAMESPACE, "reconciles");
        }
        if (goalReconciliation.getLogs() != null && goalReconciliation.getLogs().size() > 0) {
            serializer.startTag(NAMESPACE, "logs");
            for (PropertyName propertyName : goalReconciliation.getLogs()) {
                this.writePropertyName(propertyName, "log", serializer);
            }
            serializer.endTag(NAMESPACE, "logs");
        }
        if (goalReconciliation.getNologs() != null && goalReconciliation.getNologs().size() > 0) {
            serializer.startTag(NAMESPACE, "nologs");
            for (PropertyName propertyName : goalReconciliation.getNologs()) {
                this.writePropertyName(propertyName, "nolog", serializer);
            }
            serializer.endTag(NAMESPACE, "nologs");
        }
        if (!goalReconciliation.isLogAll()) {
            serializer.startTag(NAMESPACE, "logAll").text(String.valueOf(goalReconciliation.isLogAll())).endTag(NAMESPACE, "logAll");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeGoalsList(GoalsList goalsList, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (goalsList.getGroupId() != null) {
            serializer.attribute(NAMESPACE, "groupId", goalsList.getGroupId());
        }
        if (goalsList.getArtifactId() != null) {
            serializer.attribute(NAMESPACE, "artifactId", goalsList.getArtifactId());
        }
        if (goalsList.getGoals() != null && goalsList.getGoals().size() > 0) {
            serializer.startTag(NAMESPACE, "goals");
            for (String goal : goalsList.getGoals()) {
                serializer.startTag(NAMESPACE, "goal").text(goal).endTag(NAMESPACE, "goal");
            }
            serializer.endTag(NAMESPACE, "goals");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeInclude(Include include, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!include.isRecursive()) {
            serializer.attribute(NAMESPACE, "recursive", String.valueOf(include.isRecursive()));
        }
        if (include.getGlob() != null) {
            serializer.attribute(NAMESPACE, "glob", include.getGlob());
        }
        serializer.text(include.getValue());
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeInput(Input input, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (input.getGlobal() != null) {
            this.writePathSet(input.getGlobal(), "global", serializer);
        }
        if (input.getPlugins() != null && input.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "plugins");
            for (PluginConfigurationScan o : input.getPlugins()) {
                this.writePluginConfigurationScan(o, "plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "plugins");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeLocal(Local local, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (local.getLocation() != null) {
            serializer.startTag(NAMESPACE, "location").text(local.getLocation()).endTag(NAMESPACE, "location");
        }
        if (local.getMaxBuildsCached() != 3) {
            serializer.startTag(NAMESPACE, "maxBuildsCached").text(String.valueOf(local.getMaxBuildsCached())).endTag(NAMESPACE, "maxBuildsCached");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeMultiModule(MultiModule multiModule, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (multiModule.getDiscovery() != null) {
            this.writeDiscovery(multiModule.getDiscovery(), "discovery", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeOutput(Output output, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (output.getExclude() != null) {
            this.writeOutputExclude(output.getExclude(), "exclude", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeOutputExclude(OutputExclude outputExclude, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (outputExclude.getPatterns() != null && outputExclude.getPatterns().size() > 0) {
            serializer.startTag(NAMESPACE, "patterns");
            for (String pattern : outputExclude.getPatterns()) {
                serializer.startTag(NAMESPACE, "pattern").text(pattern).endTag(NAMESPACE, "pattern");
            }
            serializer.endTag(NAMESPACE, "patterns");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePathSet(PathSet pathSet, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pathSet.getGlob() != null && !pathSet.getGlob().equals("*")) {
            serializer.startTag(NAMESPACE, "glob").text(pathSet.getGlob()).endTag(NAMESPACE, "glob");
        }
        if (pathSet.getIncludes() != null && pathSet.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            for (Include include : pathSet.getIncludes()) {
                this.writeInclude(include, "include", serializer);
            }
            serializer.endTag(NAMESPACE, "includes");
        }
        if (pathSet.getExcludes() != null && pathSet.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            for (Exclude exclude : pathSet.getExcludes()) {
                this.writeExclude(exclude, "exclude", serializer);
            }
            serializer.endTag(NAMESPACE, "excludes");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginConfigurationScan(PluginConfigurationScan pluginConfigurationScan, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginConfigurationScan.isExcludeDependencies()) {
            serializer.attribute(NAMESPACE, "excludeDependencies", String.valueOf(pluginConfigurationScan.isExcludeDependencies()));
        }
        if (pluginConfigurationScan.getGroupId() != null) {
            serializer.attribute(NAMESPACE, "groupId", pluginConfigurationScan.getGroupId());
        }
        if (pluginConfigurationScan.getArtifactId() != null) {
            serializer.attribute(NAMESPACE, "artifactId", pluginConfigurationScan.getArtifactId());
        }
        if (pluginConfigurationScan.getEffectivePom() != null) {
            this.writeEffectivePom(pluginConfigurationScan.getEffectivePom(), "effectivePom", serializer);
        }
        if (pluginConfigurationScan.getDirScan() != null) {
            this.writeDirScanConfig(pluginConfigurationScan.getDirScan(), "dirScan", serializer);
        }
        if (pluginConfigurationScan.getExecutions() != null && pluginConfigurationScan.getExecutions().size() > 0) {
            serializer.startTag(NAMESPACE, "executions");
            for (ExecutionConfigurationScan o : pluginConfigurationScan.getExecutions()) {
                this.writeExecutionConfigurationScan(o, "execution", serializer);
            }
            serializer.endTag(NAMESPACE, "executions");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginSet(PluginSet pluginSet, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginSet.getGroupId() != null) {
            serializer.attribute(NAMESPACE, "groupId", pluginSet.getGroupId());
        }
        if (pluginSet.getArtifactId() != null) {
            serializer.attribute(NAMESPACE, "artifactId", pluginSet.getArtifactId());
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeProjectVersioning(ProjectVersioning projectVersioning, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (projectVersioning.isAdjustMetaInf()) {
            serializer.attribute(NAMESPACE, "adjustMetaInf", String.valueOf(projectVersioning.isAdjustMetaInf()));
        }
        if (projectVersioning.isCalculateProjectVersionChecksum()) {
            serializer.attribute(NAMESPACE, "calculateProjectVersionChecksum", String.valueOf(projectVersioning.isCalculateProjectVersionChecksum()));
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePropertyName(PropertyName propertyName, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (propertyName.getPropertyName() != null) {
            serializer.attribute(NAMESPACE, "propertyName", propertyName.getPropertyName());
        }
        serializer.text(propertyName.getValue());
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeReconcile(Reconcile reconcile, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!reconcile.isLogAllProperties()) {
            serializer.attribute(NAMESPACE, "logAllProperties", String.valueOf(reconcile.isLogAllProperties()));
        }
        if (reconcile.getPlugins() != null && reconcile.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "plugins");
            for (GoalReconciliation o : reconcile.getPlugins()) {
                this.writeGoalReconciliation(o, "plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "plugins");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeRemote(Remote remote, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!remote.isEnabled()) {
            serializer.attribute(NAMESPACE, "enabled", String.valueOf(remote.isEnabled()));
        }
        if (remote.isSaveToRemote()) {
            serializer.attribute(NAMESPACE, "saveToRemote", String.valueOf(remote.isSaveToRemote()));
        }
        if (remote.getTransport() != null && !remote.getTransport().equals("resolver")) {
            serializer.attribute(NAMESPACE, "transport", remote.getTransport());
        }
        if (remote.getId() != null && !remote.getId().equals("cache")) {
            serializer.attribute(NAMESPACE, "id", remote.getId());
        }
        if (remote.getUrl() != null) {
            serializer.startTag(NAMESPACE, "url").text(remote.getUrl()).endTag(NAMESPACE, "url");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeTagExclude(TagExclude tagExclude, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (tagExclude.getTagName() != null) {
            serializer.attribute(NAMESPACE, "tagName", tagExclude.getTagName());
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeTagScanConfig(TagScanConfig tagScanConfig, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!tagScanConfig.isRecursive()) {
            serializer.attribute(NAMESPACE, "recursive", String.valueOf(tagScanConfig.isRecursive()));
        }
        if (tagScanConfig.getGlob() != null && !tagScanConfig.getGlob().equals("*")) {
            serializer.attribute(NAMESPACE, "glob", tagScanConfig.getGlob());
        }
        if (tagScanConfig.getTagName() != null) {
            serializer.attribute(NAMESPACE, "tagName", tagScanConfig.getTagName());
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeTrackedProperty(TrackedProperty trackedProperty, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (trackedProperty.getPropertyName() != null) {
            serializer.attribute(NAMESPACE, "propertyName", trackedProperty.getPropertyName());
        }
        if (trackedProperty.getSkipValue() != null) {
            serializer.attribute(NAMESPACE, "skipValue", trackedProperty.getSkipValue());
        }
        if (trackedProperty.getDefaultValue() != null) {
            serializer.attribute(NAMESPACE, "defaultValue", trackedProperty.getDefaultValue());
        }
        serializer.text(trackedProperty.getValue());
        serializer.endTag(NAMESPACE, tagName);
    }
}

