/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.api.Language;
import org.apache.maven.api.Listener;
import org.apache.maven.api.LocalRepository;
import org.apache.maven.api.Node;
import org.apache.maven.api.Packaging;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Project;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Service;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.Type;
import org.apache.maven.api.Version;
import org.apache.maven.api.VersionConstraint;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.services.ArtifactCoordinateFactory;
import org.apache.maven.api.services.ArtifactDeployer;
import org.apache.maven.api.services.ArtifactFactory;
import org.apache.maven.api.services.ArtifactInstaller;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.DependencyCollector;
import org.apache.maven.api.services.DependencyCoordinateFactory;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.DependencyResolverRequest;
import org.apache.maven.api.services.LanguageRegistry;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.LookupException;
import org.apache.maven.api.services.PackagingRegistry;
import org.apache.maven.api.services.PathScopeRegistry;
import org.apache.maven.api.services.ProjectScopeRegistry;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.VersionRangeResolver;
import org.apache.maven.api.services.VersionResolver;
import org.apache.maven.internal.impl.DefaultArtifact;
import org.apache.maven.internal.impl.DefaultArtifactCoordinate;
import org.apache.maven.internal.impl.DefaultDependency;
import org.apache.maven.internal.impl.DefaultDependencyCoordinate;
import org.apache.maven.internal.impl.DefaultLocalRepository;
import org.apache.maven.internal.impl.DefaultNode;
import org.apache.maven.internal.impl.DefaultRemoteRepository;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.LocalRepositoryManager;

public abstract class AbstractSession
implements InternalSession {
    protected final RepositorySystemSession session;
    protected final RepositorySystem repositorySystem;
    protected final List<RemoteRepository> repositories;
    protected final Lookup lookup;
    private final Map<Class<? extends Service>, Service> services = new ConcurrentHashMap<Class<? extends Service>, Service>();
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Map<DependencyNode, Node> allNodes = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Artifact, org.apache.maven.api.Artifact> allArtifacts = Collections.synchronizedMap(new WeakHashMap());
    private final Map<org.eclipse.aether.repository.RemoteRepository, RemoteRepository> allRepositories = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Dependency, org.apache.maven.api.Dependency> allDependencies = Collections.synchronizedMap(new WeakHashMap());

    public AbstractSession(RepositorySystemSession session, RepositorySystem repositorySystem, List<RemoteRepository> repositories, List<org.eclipse.aether.repository.RemoteRepository> resolverRepositories, Lookup lookup) {
        this.session = Utils.nonNull(session, "session");
        this.repositorySystem = repositorySystem;
        this.repositories = AbstractSession.getRepositories(repositories, resolverRepositories);
        this.lookup = lookup;
    }

    @Override
    public RemoteRepository getRemoteRepository(org.eclipse.aether.repository.RemoteRepository repository) {
        return this.allRepositories.computeIfAbsent(repository, DefaultRemoteRepository::new);
    }

    @Override
    public Node getNode(DependencyNode node) {
        return this.getNode(node, false);
    }

    @Override
    public Node getNode(DependencyNode node, boolean verbose) {
        return this.allNodes.computeIfAbsent(node, n -> new DefaultNode(this, (DependencyNode)n, verbose));
    }

    @Override
    @Nonnull
    public org.apache.maven.api.Artifact getArtifact(@Nonnull Artifact artifact) {
        return this.allArtifacts.computeIfAbsent(artifact, a -> new DefaultArtifact(this, (Artifact)a));
    }

    @Override
    @Nonnull
    public org.apache.maven.api.Dependency getDependency(@Nonnull Dependency dependency) {
        return this.allDependencies.computeIfAbsent(dependency, d -> new DefaultDependency(this, (Dependency)d));
    }

    @Override
    public List<org.eclipse.aether.repository.RemoteRepository> toRepositories(List<RemoteRepository> repositories) {
        return repositories == null ? null : Utils.map(repositories, this::toRepository);
    }

    @Override
    public org.eclipse.aether.repository.RemoteRepository toRepository(RemoteRepository repository) {
        if (repository instanceof DefaultRemoteRepository) {
            return ((DefaultRemoteRepository)repository).getRepository();
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public org.eclipse.aether.repository.LocalRepository toRepository(LocalRepository repository) {
        if (repository instanceof DefaultLocalRepository) {
            return ((DefaultLocalRepository)repository).getRepository();
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public List<Dependency> toDependencies(Collection<DependencyCoordinate> dependencies, boolean managed) {
        return dependencies == null ? null : Utils.map(dependencies, d -> this.toDependency((DependencyCoordinate)d, managed));
    }

    static List<RemoteRepository> getRepositories(List<RemoteRepository> repositories, List<org.eclipse.aether.repository.RemoteRepository> resolverRepositories) {
        if (repositories != null) {
            return repositories;
        }
        if (resolverRepositories != null) {
            return Utils.map(resolverRepositories, DefaultRemoteRepository::new);
        }
        throw new IllegalArgumentException("no remote repositories provided");
    }

    @Nonnull
    public List<RemoteRepository> getRemoteRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    @Nonnull
    public org.apache.maven.api.SessionData getData() {
        final SessionData data = this.session.getData();
        return new org.apache.maven.api.SessionData(){

            public <T> void set(@Nonnull SessionData.Key<T> key, @Nullable T value) {
                data.set(key, value);
            }

            public <T> boolean replace(@Nonnull SessionData.Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
                return data.set(key, oldValue, newValue);
            }

            @Nullable
            public <T> T get(@Nonnull SessionData.Key<T> key) {
                return (T)data.get(key);
            }

            @Nullable
            public <T> T computeIfAbsent(@Nonnull SessionData.Key<T> key, @Nonnull Supplier<T> supplier) {
                return (T)data.computeIfAbsent(key, supplier);
            }
        };
    }

    @Nonnull
    public LocalRepository getLocalRepository() {
        return new DefaultLocalRepository(this.session.getLocalRepository());
    }

    @Nonnull
    public Session withLocalRepository(@Nonnull LocalRepository localRepository) {
        Utils.nonNull(localRepository, "localRepository");
        if (this.session.getLocalRepository() != null && Objects.equals(this.session.getLocalRepository().getBasePath(), localRepository.getPath())) {
            return this;
        }
        org.eclipse.aether.repository.LocalRepository repository = this.toRepository(localRepository);
        LocalRepositoryManager localRepositoryManager = this.repositorySystem.newLocalRepositoryManager(this.session, repository);
        DefaultRepositorySystemSession repoSession = new DefaultRepositorySystemSession(this.session).setLocalRepositoryManager(localRepositoryManager);
        return this.newSession((RepositorySystemSession)repoSession, this.repositories);
    }

    @Nonnull
    public Session withRemoteRepositories(@Nonnull List<RemoteRepository> repositories) {
        return this.newSession(this.session, repositories);
    }

    protected abstract Session newSession(RepositorySystemSession var1, List<RemoteRepository> var2);

    @Nonnull
    public <T extends Service> T getService(Class<T> clazz) throws NoSuchElementException {
        Service t = this.services.computeIfAbsent(clazz, this::lookup);
        if (t == null) {
            throw new NoSuchElementException(clazz.getName());
        }
        return (T)t;
    }

    private Service lookup(Class<? extends Service> c) {
        try {
            return (Service)this.lookup.lookup(c);
        }
        catch (LookupException e) {
            NoSuchElementException nsee = new NoSuchElementException(c.getName());
            e.initCause((Throwable)e);
            throw nsee;
        }
    }

    @Override
    @Nonnull
    public RepositorySystemSession getSession() {
        return this.session;
    }

    @Override
    @Nonnull
    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    @Override
    public Dependency toDependency(DependencyCoordinate dependency, boolean managed) {
        Dependency dep = dependency instanceof DefaultDependencyCoordinate ? ((DefaultDependencyCoordinate)dependency).getDependency() : new Dependency((Artifact)new org.eclipse.aether.artifact.DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType().getExtension(), dependency.getVersion().toString(), null), dependency.getScope().id());
        if (!managed && "".equals(dep.getScope())) {
            dep = dep.setScope(DependencyScope.COMPILE.id());
        }
        return dep;
    }

    @Override
    public List<Artifact> toArtifacts(Collection<org.apache.maven.api.Artifact> artifacts) {
        return artifacts == null ? null : Utils.map(artifacts, this::toArtifact);
    }

    @Override
    public Artifact toArtifact(org.apache.maven.api.Artifact artifact) {
        Artifact a;
        Path path = this.getService(ArtifactManager.class).getPath(artifact).orElse(null);
        if (artifact instanceof DefaultArtifact && Objects.equals(path, (a = ((DefaultArtifact)artifact).getArtifact()).getPath())) {
            return a;
        }
        return new org.eclipse.aether.artifact.DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion().toString(), null, path);
    }

    @Override
    public Artifact toArtifact(ArtifactCoordinate coord) {
        if (coord instanceof DefaultArtifactCoordinate) {
            return ((DefaultArtifactCoordinate)coord).getCoordinate();
        }
        return new org.eclipse.aether.artifact.DefaultArtifact(coord.getGroupId(), coord.getArtifactId(), coord.getClassifier(), coord.getExtension(), coord.getVersion().toString(), null, (File)null);
    }

    public void registerListener(@Nonnull Listener listener) {
        this.listeners.add(Utils.nonNull(listener));
    }

    public void unregisterListener(@Nonnull Listener listener) {
        this.listeners.remove(Utils.nonNull(listener));
    }

    @Nonnull
    public Collection<Listener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public LocalRepository createLocalRepository(Path path) {
        return this.getService(RepositoryFactory.class).createLocal(path);
    }

    @Nonnull
    public RemoteRepository createRemoteRepository(@Nonnull String id, @Nonnull String url) {
        return this.getService(RepositoryFactory.class).createRemote(id, url);
    }

    @Nonnull
    public RemoteRepository createRemoteRepository(@Nonnull Repository repository) {
        return this.getService(RepositoryFactory.class).createRemote(repository);
    }

    public ArtifactCoordinate createArtifactCoordinate(String groupId, String artifactId, String version, String extension) {
        return this.getService(ArtifactCoordinateFactory.class).create((Session)this, groupId, artifactId, version, extension);
    }

    public ArtifactCoordinate createArtifactCoordinate(String coordString) {
        return this.getService(ArtifactCoordinateFactory.class).create((Session)this, coordString);
    }

    public ArtifactCoordinate createArtifactCoordinate(String groupId, String artifactId, String version, String classifier, String extension, String type) {
        return this.getService(ArtifactCoordinateFactory.class).create((Session)this, groupId, artifactId, version, classifier, extension, type);
    }

    public ArtifactCoordinate createArtifactCoordinate(org.apache.maven.api.Artifact artifact) {
        return this.getService(ArtifactCoordinateFactory.class).create((Session)this, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().asString(), artifact.getClassifier(), artifact.getExtension(), null);
    }

    public org.apache.maven.api.Artifact createArtifact(String groupId, String artifactId, String version, String extension) {
        return this.getService(ArtifactFactory.class).create((Session)this, groupId, artifactId, version, extension);
    }

    public org.apache.maven.api.Artifact createArtifact(String groupId, String artifactId, String version, String classifier, String extension, String type) {
        return this.getService(ArtifactFactory.class).create((Session)this, groupId, artifactId, version, classifier, extension, type);
    }

    public Map.Entry<org.apache.maven.api.Artifact, Path> resolveArtifact(ArtifactCoordinate coordinate) {
        return this.getService(ArtifactResolver.class).resolve((Session)this, Collections.singletonList(coordinate)).getArtifacts().entrySet().iterator().next();
    }

    public Map<org.apache.maven.api.Artifact, Path> resolveArtifacts(ArtifactCoordinate ... coordinates) {
        return this.resolveArtifacts(Arrays.asList(coordinates));
    }

    public Map<org.apache.maven.api.Artifact, Path> resolveArtifacts(Collection<? extends ArtifactCoordinate> coordinates) {
        return this.getService(ArtifactResolver.class).resolve((Session)this, coordinates).getArtifacts();
    }

    public Map.Entry<org.apache.maven.api.Artifact, Path> resolveArtifact(org.apache.maven.api.Artifact artifact) {
        ArtifactCoordinate coordinate = this.getService(ArtifactCoordinateFactory.class).create((Session)this, artifact);
        return this.resolveArtifact(coordinate);
    }

    public Map<org.apache.maven.api.Artifact, Path> resolveArtifacts(org.apache.maven.api.Artifact ... artifacts) {
        ArtifactCoordinateFactory acf = this.getService(ArtifactCoordinateFactory.class);
        List coords = Arrays.stream(artifacts).map(a -> acf.create((Session)this, a)).collect(Collectors.toList());
        return this.resolveArtifacts(coords);
    }

    public void installArtifacts(org.apache.maven.api.Artifact ... artifacts) {
        this.installArtifacts(Arrays.asList(artifacts));
    }

    public void installArtifacts(Collection<org.apache.maven.api.Artifact> artifacts) {
        this.getService(ArtifactInstaller.class).install((Session)this, artifacts);
    }

    public void deployArtifact(RemoteRepository repository, org.apache.maven.api.Artifact ... artifacts) {
        this.getService(ArtifactDeployer.class).deploy((Session)this, repository, Arrays.asList(artifacts));
    }

    public void setArtifactPath(@Nonnull org.apache.maven.api.Artifact artifact, @Nonnull Path path) {
        this.getService(ArtifactManager.class).setPath(artifact, path);
    }

    @Nonnull
    public Optional<Path> getArtifactPath(@Nonnull org.apache.maven.api.Artifact artifact) {
        return this.getService(ArtifactManager.class).getPath(artifact);
    }

    public boolean isVersionSnapshot(@Nonnull String version) {
        return this.getService(VersionParser.class).isSnapshot(version);
    }

    @Nonnull
    public DependencyCoordinate createDependencyCoordinate(@Nonnull ArtifactCoordinate coordinate) {
        return this.getService(DependencyCoordinateFactory.class).create((Session)this, coordinate);
    }

    @Nonnull
    public DependencyCoordinate createDependencyCoordinate(@Nonnull org.apache.maven.api.Dependency dependency) {
        return this.getService(DependencyCoordinateFactory.class).create((Session)this, dependency);
    }

    @Nonnull
    public Node collectDependencies(@Nonnull org.apache.maven.api.Artifact artifact) {
        return this.getService(DependencyCollector.class).collect((Session)this, artifact).getRoot();
    }

    @Nonnull
    public Node collectDependencies(@Nonnull Project project) {
        return this.getService(DependencyCollector.class).collect((Session)this, project).getRoot();
    }

    @Nonnull
    public Node collectDependencies(@Nonnull DependencyCoordinate dependency) {
        return this.getService(DependencyCollector.class).collect((Session)this, dependency).getRoot();
    }

    @Nonnull
    public List<Node> flattenDependencies(@Nonnull Node node, @Nonnull PathScope scope) {
        return this.getService(DependencyResolver.class).flatten((Session)this, node, scope);
    }

    public List<Path> resolveDependencies(DependencyCoordinate dependency) {
        return this.getService(DependencyResolver.class).resolve((Session)this, dependency).getPaths();
    }

    public List<Path> resolveDependencies(List<DependencyCoordinate> dependencies) {
        return this.getService(DependencyResolver.class).resolve((Session)this, dependencies).getPaths();
    }

    public List<Path> resolveDependencies(Project project, PathScope scope) {
        return this.getService(DependencyResolver.class).resolve((Session)this, project, scope).getPaths();
    }

    public Map<PathType, List<Path>> resolveDependencies(@Nonnull DependencyCoordinate dependency, @Nonnull PathScope scope, @Nonnull Collection<PathType> desiredTypes) {
        return this.getService(DependencyResolver.class).resolve(DependencyResolverRequest.builder().session((Session)this).dependency(dependency).pathScope(scope).pathTypeFilter(desiredTypes).build()).getDispatchedPaths();
    }

    public Map<PathType, List<Path>> resolveDependencies(@Nonnull Project project, @Nonnull PathScope scope, @Nonnull Collection<PathType> desiredTypes) {
        return this.getService(DependencyResolver.class).resolve(DependencyResolverRequest.builder().session((Session)this).project(project).pathScope(scope).pathTypeFilter(desiredTypes).build()).getDispatchedPaths();
    }

    public Path getPathForLocalArtifact(@Nonnull org.apache.maven.api.Artifact artifact) {
        return this.getService(org.apache.maven.api.services.LocalRepositoryManager.class).getPathForLocalArtifact((Session)this, this.getLocalRepository(), artifact);
    }

    public Path getPathForRemoteArtifact(RemoteRepository remote, org.apache.maven.api.Artifact artifact) {
        return this.getService(org.apache.maven.api.services.LocalRepositoryManager.class).getPathForRemoteArtifact((Session)this, this.getLocalRepository(), remote, artifact);
    }

    public Version parseVersion(String version) {
        return this.getService(VersionParser.class).parseVersion(version);
    }

    public VersionRange parseVersionRange(String versionRange) {
        return this.getService(VersionParser.class).parseVersionRange(versionRange);
    }

    public VersionConstraint parseVersionConstraint(String versionConstraint) {
        return this.getService(VersionParser.class).parseVersionConstraint(versionConstraint);
    }

    public Version resolveVersion(ArtifactCoordinate artifact) {
        return this.getService(VersionResolver.class).resolve((Session)this, artifact).getVersion();
    }

    public List<Version> resolveVersionRange(ArtifactCoordinate artifact) {
        return this.getService(VersionRangeResolver.class).resolve((Session)this, artifact).getVersions();
    }

    public Type requireType(String id) {
        return this.getService(TypeRegistry.class).require(id);
    }

    public Language requireLanguage(String id) {
        return (Language)this.getService(LanguageRegistry.class).require(id);
    }

    public Packaging requirePackaging(String id) {
        return (Packaging)this.getService(PackagingRegistry.class).require(id);
    }

    public ProjectScope requireProjectScope(String id) {
        return (ProjectScope)this.getService(ProjectScopeRegistry.class).require(id);
    }

    public DependencyScope requireDependencyScope(String id) {
        return DependencyScope.forId((String)Utils.nonNull(id, "id"));
    }

    public PathScope requirePathScope(String id) {
        return (PathScope)this.getService(PathScopeRegistry.class).require(id);
    }
}

