/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Objects;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.VersionConstraint;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.artifact.Artifact;

public class DefaultArtifactCoordinate
implements ArtifactCoordinate {
    @Nonnull
    private final InternalSession session;
    @Nonnull
    private final Artifact coordinate;

    public DefaultArtifactCoordinate(@Nonnull InternalSession session, @Nonnull Artifact coordinate) {
        this.session = Utils.nonNull(session, "session");
        this.coordinate = Utils.nonNull(coordinate, "coordinate");
    }

    public Artifact getCoordinate() {
        return this.coordinate;
    }

    @Nonnull
    public String getGroupId() {
        return this.coordinate.getGroupId();
    }

    @Nonnull
    public String getArtifactId() {
        return this.coordinate.getArtifactId();
    }

    @Nonnull
    public VersionConstraint getVersion() {
        return this.session.parseVersionConstraint(this.coordinate.getVersion());
    }

    public String getExtension() {
        return this.coordinate.getExtension();
    }

    @Nonnull
    public String getClassifier() {
        return this.coordinate.getClassifier();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultArtifactCoordinate that = (DefaultArtifactCoordinate)o;
        return Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getClassifier(), that.getClassifier());
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getClassifier());
    }

    public String toString() {
        return this.coordinate.toString();
    }
}

