/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ArtifactInstaller;
import org.apache.maven.api.services.ArtifactInstallerException;
import org.apache.maven.api.services.ArtifactInstallerRequest;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;

@Named
@Singleton
public class DefaultArtifactInstaller
implements ArtifactInstaller {
    private final RepositorySystem repositorySystem;

    @Inject
    DefaultArtifactInstaller(@Nonnull RepositorySystem repositorySystem) {
        this.repositorySystem = Utils.nonNull(repositorySystem);
    }

    public void install(ArtifactInstallerRequest request) throws ArtifactInstallerException, IllegalArgumentException {
        Utils.nonNull(request, "request");
        InternalSession session = InternalSession.from(request.getSession());
        try {
            InstallRequest installRequest = new InstallRequest().setArtifacts(session.toArtifacts(request.getArtifacts()));
            InstallResult installResult = this.repositorySystem.install(session.getSession(), installRequest);
        }
        catch (InstallationException e) {
            throw new ArtifactInstallerException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

