/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.internal.impl.DefaultBuilderProblem;

public class DefaultSettingsValidator {
    private static final String ID = "[\\w.-]+";
    private static final Pattern ID_REGEX = Pattern.compile("[\\w.-]+");
    private static final String ILLEGAL_REPO_ID_CHARS = "\\/:\"<>|?*";

    public void validate(Settings settings, boolean isProjectSettings, List<BuilderProblem> problems) {
        List proxies;
        List profiles;
        List mirrors;
        List servers;
        List pluginGroups;
        Server server;
        int i;
        if (isProjectSettings) {
            String msgS = "is not supported on project settings.";
            String msgP = "are not supported on project settings.";
            if (settings.getLocalRepository() != null && !settings.getLocalRepository().isEmpty()) {
                DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, "localRepository", null, msgS);
            }
            if (!settings.isInteractiveMode()) {
                DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, "interactiveMode", null, msgS);
            }
            if (settings.isOffline()) {
                DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, "offline", null, msgS);
            }
            if (!settings.getProxies().isEmpty()) {
                DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, "proxies", null, msgP);
            }
            if (settings.isUsePluginRegistry()) {
                DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, "usePluginRegistry", null, msgS);
            }
            List servers2 = settings.getServers();
            for (i = 0; i < servers2.size(); ++i) {
                server = (Server)servers2.get(i);
                String serverField = "servers.server[" + i + "]";
                DefaultSettingsValidator.validateStringEmpty(problems, (String)serverField + ".username", server.getUsername(), msgS);
                DefaultSettingsValidator.validateStringEmpty(problems, (String)serverField + ".password", server.getPassword(), msgS);
                DefaultSettingsValidator.validateStringEmpty(problems, (String)serverField + ".privateKey", server.getPrivateKey(), msgS);
                DefaultSettingsValidator.validateStringEmpty(problems, (String)serverField + ".passphrase", server.getPassphrase(), msgS);
                DefaultSettingsValidator.validateStringEmpty(problems, (String)serverField + ".filePermissions", server.getFilePermissions(), msgS);
                DefaultSettingsValidator.validateStringEmpty(problems, (String)serverField + ".directoryPermissions", server.getDirectoryPermissions(), msgS);
            }
        }
        if (settings.isUsePluginRegistry()) {
            DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, "usePluginRegistry", null, "is deprecated and has no effect.");
        }
        if ((pluginGroups = settings.getPluginGroups()) != null) {
            for (int i2 = 0; i2 < pluginGroups.size(); ++i2) {
                String pluginGroup = (String)pluginGroups.get(i2);
                DefaultSettingsValidator.validateStringNotEmpty(problems, "pluginGroups.pluginGroup[" + i2 + "]", pluginGroup, null);
                if (ID_REGEX.matcher(pluginGroup).matches()) continue;
                DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.ERROR, "pluginGroups.pluginGroup[" + i2 + "]", null, "must denote a valid group id and match the pattern [\\w.-]+");
            }
        }
        if ((servers = settings.getServers()) != null) {
            HashSet<String> serverIds = new HashSet<String>();
            for (i = 0; i < servers.size(); ++i) {
                server = (Server)servers.get(i);
                DefaultSettingsValidator.validateStringNotEmpty(problems, "servers.server[" + i + "].id", server.getId(), null);
                if (serverIds.add(server.getId())) continue;
                DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, "servers.server.id", null, "must be unique but found duplicate server with id " + server.getId());
            }
        }
        if ((mirrors = settings.getMirrors()) != null) {
            for (Mirror mirror : mirrors) {
                DefaultSettingsValidator.validateStringNotEmpty(problems, "mirrors.mirror.id", mirror.getId(), mirror.getUrl());
                DefaultSettingsValidator.validateBannedCharacters(problems, "mirrors.mirror.id", BuilderProblem.Severity.WARNING, mirror.getId(), null, ILLEGAL_REPO_ID_CHARS);
                if ("local".equals(mirror.getId())) {
                    DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, "mirrors.mirror.id", null, "must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.");
                }
                DefaultSettingsValidator.validateStringNotEmpty(problems, "mirrors.mirror.url", mirror.getUrl(), mirror.getId());
                DefaultSettingsValidator.validateStringNotEmpty(problems, "mirrors.mirror.mirrorOf", mirror.getMirrorOf(), mirror.getId());
            }
        }
        if ((profiles = settings.getProfiles()) != null) {
            HashSet<String> profileIds = new HashSet<String>();
            for (Profile profile : profiles) {
                if (!profileIds.add(profile.getId())) {
                    DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, "profiles.profile.id", null, "must be unique but found duplicate profile with id " + profile.getId());
                }
                String prefix = "profiles.profile[" + profile.getId() + "].";
                this.validateRepositories(problems, profile.getRepositories(), prefix + "repositories.repository");
                this.validateRepositories(problems, profile.getPluginRepositories(), prefix + "pluginRepositories.pluginRepository");
            }
        }
        if ((proxies = settings.getProxies()) != null) {
            HashSet<String> proxyIds = new HashSet<String>();
            for (Proxy proxy : proxies) {
                if (!proxyIds.add(proxy.getId())) {
                    DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, "proxies.proxy.id", null, "must be unique but found duplicate proxy with id " + proxy.getId());
                }
                DefaultSettingsValidator.validateStringNotEmpty(problems, "proxies.proxy.host", proxy.getHost(), proxy.getId());
                try {
                    Integer.parseInt(proxy.getPortString());
                }
                catch (NumberFormatException e) {
                    DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.ERROR, "proxies.proxy[" + proxy.getId() + "].port", null, "must be a valid integer but found '" + proxy.getPortString() + "'");
                }
            }
        }
    }

    private void validateRepositories(List<BuilderProblem> problems, List<Repository> repositories, String prefix) {
        HashSet<String> repoIds = new HashSet<String>();
        for (Repository repository : repositories) {
            DefaultSettingsValidator.validateStringNotEmpty(problems, prefix + ".id", repository.getId(), repository.getUrl());
            DefaultSettingsValidator.validateBannedCharacters(problems, prefix + ".id", BuilderProblem.Severity.WARNING, repository.getId(), null, ILLEGAL_REPO_ID_CHARS);
            if ("local".equals(repository.getId())) {
                DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, prefix + ".id", null, "must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.");
            }
            if (!repoIds.add(repository.getId())) {
                DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, prefix + ".id", null, "must be unique but found duplicate repository with id " + repository.getId());
            }
            DefaultSettingsValidator.validateStringNotEmpty(problems, prefix + ".url", repository.getUrl(), repository.getId());
            if (!"legacy".equals(repository.getLayout())) continue;
            DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, prefix + ".layout", repository.getId(), "uses the unsupported value 'legacy', artifact resolution might fail.");
        }
    }

    private static boolean validateStringEmpty(List<BuilderProblem> problems, String fieldName, String string, String message) {
        if (string == null || string.length() == 0) {
            return true;
        }
        DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.WARNING, fieldName, null, message);
        return false;
    }

    private static boolean validateStringNotEmpty(List<BuilderProblem> problems, String fieldName, String string, String sourceHint) {
        if (!DefaultSettingsValidator.validateNotNull(problems, fieldName, string, sourceHint)) {
            return false;
        }
        if (!string.isEmpty()) {
            return true;
        }
        DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.ERROR, fieldName, sourceHint, "is missing");
        return false;
    }

    private static boolean validateNotNull(List<BuilderProblem> problems, String fieldName, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        DefaultSettingsValidator.addViolation(problems, BuilderProblem.Severity.ERROR, fieldName, sourceHint, "is missing");
        return false;
    }

    private static boolean validateBannedCharacters(List<BuilderProblem> problems, String fieldName, BuilderProblem.Severity severity, String string, String sourceHint, String banned) {
        if (string != null) {
            for (int i = string.length() - 1; i >= 0; --i) {
                if (banned.indexOf(string.charAt(i)) < 0) continue;
                DefaultSettingsValidator.addViolation(problems, severity, fieldName, sourceHint, "must not contain any of these characters " + banned + " but found " + string.charAt(i));
                return false;
            }
        }
        return true;
    }

    private static void addViolation(List<BuilderProblem> problems, BuilderProblem.Severity severity, String fieldName, String sourceHint, String message) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('\'').append(fieldName).append('\'');
        if (sourceHint != null) {
            buffer.append(" for ").append(sourceHint);
        }
        buffer.append(' ').append(message);
        problems.add(new DefaultBuilderProblem(null, -1, -1, null, buffer.toString(), severity));
    }
}

