/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.ProfileActivator;
import org.apache.maven.api.services.model.ProfileSelector;

@Named
@Singleton
public class DefaultProfileSelector
implements ProfileSelector {
    private final List<ProfileActivator> activators;

    public DefaultProfileSelector() {
        this.activators = new ArrayList<ProfileActivator>();
    }

    @Inject
    public DefaultProfileSelector(List<ProfileActivator> activators) {
        this.activators = new ArrayList<ProfileActivator>(activators);
    }

    public DefaultProfileSelector addProfileActivator(ProfileActivator profileActivator) {
        if (profileActivator != null) {
            this.activators.add(profileActivator);
        }
        return this;
    }

    @Override
    public List<Profile> getActiveProfiles(Collection<Profile> profiles, ProfileActivationContext context, ModelProblemCollector problems) {
        HashSet<String> activatedIds = new HashSet<String>(context.getActiveProfileIds());
        HashSet<String> deactivatedIds = new HashSet<String>(context.getInactiveProfileIds());
        ArrayList<Profile> activeProfiles = new ArrayList<Profile>(profiles.size());
        ArrayList<Profile> activePomProfilesByDefault = new ArrayList<Profile>();
        boolean activatedPomProfileNotByDefault = false;
        for (Profile profile : profiles) {
            if (deactivatedIds.contains(profile.getId())) continue;
            if (activatedIds.contains(profile.getId()) || this.isActive(profile, context, problems)) {
                activeProfiles.add(profile);
                if (!"pom".equals(profile.getSource())) continue;
                activatedPomProfileNotByDefault = true;
                continue;
            }
            if (!this.isActiveByDefault(profile)) continue;
            if ("pom".equals(profile.getSource())) {
                activePomProfilesByDefault.add(profile);
                continue;
            }
            activeProfiles.add(profile);
        }
        if (!activatedPomProfileNotByDefault) {
            activeProfiles.addAll(activePomProfilesByDefault);
        }
        return activeProfiles;
    }

    private boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        boolean isActive = false;
        for (ProfileActivator activator : this.activators) {
            if (!activator.presentInConfig(profile, context, problems)) continue;
            isActive = true;
            try {
                if (activator.isActive(profile, context, problems)) continue;
                return false;
            }
            catch (RuntimeException e) {
                problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Failed to determine activation for profile " + profile.getId(), profile.getLocation((Object)""), (Exception)e);
                return false;
            }
        }
        return isActive;
    }

    private boolean isActiveByDefault(Profile profile) {
        Activation activation = profile.getActivation();
        return activation != null && activation.isActiveByDefault();
    }
}

