/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.internal.impl.resolver.artifact.FatArtifactTraverser;
import org.apache.maven.internal.impl.resolver.scopes.Maven4ScopeManagerConfiguration;
import org.apache.maven.internal.impl.resolver.type.DefaultTypeProvider;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.impl.scope.InternalScopeManager;
import org.eclipse.aether.impl.scope.ScopeManagerConfiguration;
import org.eclipse.aether.internal.impl.scope.ManagedDependencyContextRefiner;
import org.eclipse.aether.internal.impl.scope.ManagedScopeDeriver;
import org.eclipse.aether.internal.impl.scope.ManagedScopeSelector;
import org.eclipse.aether.internal.impl.scope.OptionalDependencySelector;
import org.eclipse.aether.internal.impl.scope.ScopeDependencySelector;
import org.eclipse.aether.internal.impl.scope.ScopeManagerImpl;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.scope.ScopeManager;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.graph.manager.ClassicDependencyManager;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConfigurableVersionSelector;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;

public class MavenSessionBuilderSupplier
implements Supplier<RepositorySystemSession.SessionBuilder> {
    protected final RepositorySystem repositorySystem;
    protected final InternalScopeManager scopeManager;

    public MavenSessionBuilderSupplier(RepositorySystem repositorySystem) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.scopeManager = new ScopeManagerImpl((ScopeManagerConfiguration)Maven4ScopeManagerConfiguration.INSTANCE);
    }

    protected DependencyTraverser getDependencyTraverser() {
        return new FatArtifactTraverser();
    }

    protected InternalScopeManager getScopeManager() {
        return this.scopeManager;
    }

    protected DependencyManager getDependencyManager() {
        return this.getDependencyManager(true);
    }

    public DependencyManager getDependencyManager(boolean transitive) {
        return new ClassicDependencyManager(transitive, (ScopeManager)this.getScopeManager());
    }

    protected DependencySelector getDependencySelector() {
        return new AndDependencySelector(new DependencySelector[]{ScopeDependencySelector.legacy(null, Arrays.asList(DependencyScope.TEST.id(), DependencyScope.PROVIDED.id())), OptionalDependencySelector.fromDirect(), new ExclusionDependencySelector()});
    }

    protected DependencyGraphTransformer getDependencyGraphTransformer() {
        return new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{new ConflictResolver((ConflictResolver.VersionSelector)new ConfigurableVersionSelector(), (ConflictResolver.ScopeSelector)new ManagedScopeSelector(this.getScopeManager()), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new ManagedScopeDeriver(this.getScopeManager())), new ManagedDependencyContextRefiner(this.getScopeManager())});
    }

    protected ArtifactTypeRegistry getArtifactTypeRegistry() {
        DefaultArtifactTypeRegistry stereotypes = new DefaultArtifactTypeRegistry();
        new DefaultTypeProvider().types().forEach(arg_0 -> ((DefaultArtifactTypeRegistry)stereotypes).add(arg_0));
        return stereotypes;
    }

    protected ArtifactDescriptorPolicy getArtifactDescriptorPolicy() {
        return new SimpleArtifactDescriptorPolicy(true, true);
    }

    protected void configureSessionBuilder(RepositorySystemSession.SessionBuilder session) {
        session.setDependencyTraverser(this.getDependencyTraverser());
        session.setDependencyManager(this.getDependencyManager());
        session.setDependencySelector(this.getDependencySelector());
        session.setDependencyGraphTransformer(this.getDependencyGraphTransformer());
        session.setArtifactTypeRegistry(this.getArtifactTypeRegistry());
        session.setArtifactDescriptorPolicy(this.getArtifactDescriptorPolicy());
        session.setScopeManager((ScopeManager)this.getScopeManager());
    }

    @Override
    public RepositorySystemSession.SessionBuilder get() {
        Objects.requireNonNull(this.repositorySystem, "repositorySystem");
        RepositorySystemSession.SessionBuilder builder = this.repositorySystem.createSessionBuilder();
        this.configureSessionBuilder(builder);
        return builder;
    }
}

