/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Objects;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.internal.impl.AetherDependencyWrapper;
import org.apache.maven.internal.impl.DefaultModelVersionParser;
import org.apache.maven.internal.impl.InternalSession;
import org.eclipse.aether.graph.Dependency;

public class DefaultDependency
extends AetherDependencyWrapper
implements org.apache.maven.api.Dependency {
    private final String key = this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getExtension() + (String)(!this.getClassifier().isEmpty() ? ":" + this.getClassifier() : "") + ":" + String.valueOf(this.getVersion());

    public DefaultDependency(@Nonnull InternalSession session, @Nonnull Dependency dependency) {
        super(session, dependency);
    }

    public String key() {
        return this.key;
    }

    public Version getVersion() {
        return this.session.parseVersion(this.dependency.getArtifact().getVersion());
    }

    public Version getBaseVersion() {
        return this.session.parseVersion(this.dependency.getArtifact().getBaseVersion());
    }

    public boolean isSnapshot() {
        return DefaultModelVersionParser.checkSnapshot(this.dependency.getArtifact().getVersion());
    }

    public boolean isOptional() {
        return this.dependency.isOptional();
    }

    @Nonnull
    public DependencyCoordinates toCoordinates() {
        return this.session.createDependencyCoordinates(this);
    }

    public boolean equals(Object o) {
        return o instanceof Artifact && Objects.equals(this.key(), ((Artifact)o).key());
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

