/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Resource;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.model.ModelPathTranslator;
import org.apache.maven.api.services.model.PathTranslator;

@Named
@Singleton
public class DefaultModelPathTranslator
implements ModelPathTranslator {
    private final PathTranslator pathTranslator;

    @Inject
    public DefaultModelPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
    }

    @Override
    public Model alignToBaseDirectory(Model model, Path basedir, ModelBuilderRequest request) {
        if (model == null || basedir == null) {
            return model;
        }
        Build build = model.getBuild();
        Build newBuild = null;
        if (build != null) {
            newBuild = Build.newBuilder((Build)build).directory(this.alignToBaseDirectory(build.getDirectory(), basedir)).sourceDirectory(this.alignToBaseDirectory(build.getSourceDirectory(), basedir)).testSourceDirectory(this.alignToBaseDirectory(build.getTestSourceDirectory(), basedir)).scriptSourceDirectory(this.alignToBaseDirectory(build.getScriptSourceDirectory(), basedir)).resources(this.map(build.getResources(), r -> this.alignToBaseDirectory((Resource)r, basedir))).testResources(this.map(build.getTestResources(), r -> this.alignToBaseDirectory((Resource)r, basedir))).filters(this.map(build.getFilters(), s -> this.alignToBaseDirectory((String)s, basedir))).outputDirectory(this.alignToBaseDirectory(build.getOutputDirectory(), basedir)).testOutputDirectory(this.alignToBaseDirectory(build.getTestOutputDirectory(), basedir)).build();
        }
        Reporting reporting = model.getReporting();
        Reporting newReporting = null;
        if (reporting != null) {
            newReporting = Reporting.newBuilder((Reporting)reporting).outputDirectory(this.alignToBaseDirectory(reporting.getOutputDirectory(), basedir)).build();
        }
        if (newBuild != build || newReporting != reporting) {
            model = Model.newBuilder((Model)model).build(newBuild).reporting(newReporting).build();
        }
        return model;
    }

    private <T> List<T> map(List<T> resources, Function<T, T> mapper) {
        ArrayList<T> newResources = null;
        if (resources != null) {
            for (int i = 0; i < resources.size(); ++i) {
                T resource = resources.get(i);
                T newResource = mapper.apply(resource);
                if (newResource == null) continue;
                if (newResources == null) {
                    newResources = new ArrayList<T>(resources);
                }
                newResources.set(i, newResource);
            }
        }
        return newResources;
    }

    private Resource alignToBaseDirectory(Resource resource, Path basedir) {
        String newDir;
        if (resource != null && (newDir = this.alignToBaseDirectory(resource.getDirectory(), basedir)) != null) {
            return resource.withDirectory(newDir);
        }
        return resource;
    }

    private String alignToBaseDirectory(String path, Path basedir) {
        String newPath = this.pathTranslator.alignToBaseDirectory(path, basedir);
        return Objects.equals(path, newPath) ? null : newPath;
    }
}

