/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.v4;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.xml.XmlNode;
import org.codehaus.stax2.util.StreamWriterDelegate;

@Generated
public class SettingsStaxWriter {
    private static final String NAMESPACE = "http://maven.apache.org/SETTINGS/1.2.0";
    private static final String SCHEMA_LOCATION = "http://maven.apache.org/xsd/settings-1.2.0.xsd";
    private String namespace = "http://maven.apache.org/SETTINGS/1.2.0";
    private String schemaLocation = "http://maven.apache.org/xsd/settings-1.2.0.xsd";
    private String fileComment = null;
    private boolean addLocationInformation = true;
    protected Function<InputLocation, String> stringFormatter;

    public void setNamespace(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
    }

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void setAddLocationInformation(boolean addLocationInformation) {
        this.addLocationInformation = addLocationInformation;
    }

    public void setStringFormatter(Function<InputLocation, String> stringFormatter) {
        this.stringFormatter = stringFormatter;
    }

    public void write(Writer writer, Settings settings) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        serializer.writeStartDocument(settings.getModelEncoding(), null);
        this.writeSettings("settings", settings, (XMLStreamWriter)((Object)serializer));
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, Settings settings) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, settings.getModelEncoding()));
        serializer.writeStartDocument(settings.getModelEncoding(), null);
        this.writeSettings("settings", settings, (XMLStreamWriter)((Object)serializer));
        serializer.writeEndDocument();
    }

    private void writeTrackableBase(String tagName, TrackableBase trackableBase, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (trackableBase != null) {
            serializer.writeStartElement(this.namespace, tagName);
            serializer.writeEndElement();
        }
    }

    private void writeIdentifiableBase(String tagName, IdentifiableBase identifiableBase, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (identifiableBase != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("id", "default", identifiableBase.getId(), serializer, (InputLocationTracker)identifiableBase);
            serializer.writeEndElement();
        }
    }

    private void writeSettings(String tagName, Settings settings, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (settings != null) {
            if (this.fileComment != null) {
                serializer.writeCharacters("\n");
                serializer.writeComment(this.fileComment);
                serializer.writeCharacters("\n");
            }
            serializer.writeStartElement("", tagName, this.namespace);
            serializer.writeNamespace("", this.namespace);
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", this.namespace + " " + this.schemaLocation);
            this.writeTag("localRepository", null, settings.getLocalRepository(), serializer, (InputLocationTracker)settings);
            this.writeTag("interactiveMode", "true", settings.isInteractiveMode() ? null : "false", serializer, (InputLocationTracker)settings);
            this.writeTag("usePluginRegistry", "false", settings.isUsePluginRegistry() ? "true" : null, serializer, (InputLocationTracker)settings);
            this.writeTag("offline", "false", settings.isOffline() ? "true" : null, serializer, (InputLocationTracker)settings);
            this.writeList("proxies", false, settings.getProxies(), serializer, (InputLocationTracker)settings, t -> this.writeProxy("proxy", (Proxy)t, serializer));
            this.writeList("servers", false, settings.getServers(), serializer, (InputLocationTracker)settings, t -> this.writeServer("server", (Server)t, serializer));
            this.writeList("mirrors", false, settings.getMirrors(), serializer, (InputLocationTracker)settings, t -> this.writeMirror("mirror", (Mirror)t, serializer));
            this.writeList("repositories", false, settings.getRepositories(), serializer, (InputLocationTracker)settings, t -> this.writeRepository("repository", (Repository)t, serializer));
            this.writeList("pluginRepositories", false, settings.getPluginRepositories(), serializer, (InputLocationTracker)settings, t -> this.writeRepository("pluginRepository", (Repository)t, serializer));
            this.writeList("profiles", false, settings.getProfiles(), serializer, (InputLocationTracker)settings, t -> this.writeProfile("profile", (Profile)t, serializer));
            this.writeList("activeProfiles", settings.getActiveProfiles(), serializer, (InputLocationTracker)settings, t -> this.writeTag("activeProfile", null, (String)t, serializer, null));
            this.writeList("pluginGroups", settings.getPluginGroups(), serializer, (InputLocationTracker)settings, t -> this.writeTag("pluginGroup", null, (String)t, serializer, null));
            serializer.writeEndElement();
        }
    }

    private void writeProxy(String tagName, Proxy proxy, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (proxy != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("active", "true", proxy.getActiveString(), serializer, (InputLocationTracker)proxy);
            this.writeTag("protocol", "http", proxy.getProtocol(), serializer, (InputLocationTracker)proxy);
            this.writeTag("username", null, proxy.getUsername(), serializer, (InputLocationTracker)proxy);
            this.writeTag("password", null, proxy.getPassword(), serializer, (InputLocationTracker)proxy);
            this.writeTag("port", "8080", proxy.getPortString(), serializer, (InputLocationTracker)proxy);
            this.writeTag("host", null, proxy.getHost(), serializer, (InputLocationTracker)proxy);
            this.writeTag("nonProxyHosts", null, proxy.getNonProxyHosts(), serializer, (InputLocationTracker)proxy);
            this.writeTag("id", "default", proxy.getId(), serializer, (InputLocationTracker)proxy);
            serializer.writeEndElement();
        }
    }

    private void writeServer(String tagName, Server server, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (server != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("username", null, server.getUsername(), serializer, (InputLocationTracker)server);
            this.writeTag("password", null, server.getPassword(), serializer, (InputLocationTracker)server);
            this.writeTag("privateKey", null, server.getPrivateKey(), serializer, (InputLocationTracker)server);
            this.writeTag("passphrase", null, server.getPassphrase(), serializer, (InputLocationTracker)server);
            this.writeTag("filePermissions", null, server.getFilePermissions(), serializer, (InputLocationTracker)server);
            this.writeTag("directoryPermissions", null, server.getDirectoryPermissions(), serializer, (InputLocationTracker)server);
            this.writeDom(server.getConfiguration(), serializer);
            this.writeTag("id", "default", server.getId(), serializer, (InputLocationTracker)server);
            serializer.writeEndElement();
        }
    }

    private void writeMirror(String tagName, Mirror mirror, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (mirror != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("mirrorOf", null, mirror.getMirrorOf(), serializer, (InputLocationTracker)mirror);
            this.writeTag("name", null, mirror.getName(), serializer, (InputLocationTracker)mirror);
            this.writeTag("url", null, mirror.getUrl(), serializer, (InputLocationTracker)mirror);
            this.writeTag("layout", "default", mirror.getLayout(), serializer, (InputLocationTracker)mirror);
            this.writeTag("mirrorOfLayouts", "default,legacy", mirror.getMirrorOfLayouts(), serializer, (InputLocationTracker)mirror);
            this.writeTag("blocked", "false", mirror.isBlocked() ? "true" : null, serializer, (InputLocationTracker)mirror);
            this.writeTag("id", "default", mirror.getId(), serializer, (InputLocationTracker)mirror);
            serializer.writeEndElement();
        }
    }

    private void writeProfile(String tagName, Profile profile, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (profile != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeActivation("activation", profile.getActivation(), serializer);
            this.writeProperties("properties", profile.getProperties(), serializer, (InputLocationTracker)profile);
            this.writeList("repositories", false, profile.getRepositories(), serializer, (InputLocationTracker)profile, t -> this.writeRepository("repository", (Repository)t, serializer));
            this.writeList("pluginRepositories", false, profile.getPluginRepositories(), serializer, (InputLocationTracker)profile, t -> this.writeRepository("pluginRepository", (Repository)t, serializer));
            this.writeTag("id", "default", profile.getId(), serializer, (InputLocationTracker)profile);
            serializer.writeEndElement();
        }
    }

    private void writeActivation(String tagName, Activation activation, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (activation != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("activeByDefault", "false", activation.isActiveByDefault() ? "true" : null, serializer, (InputLocationTracker)activation);
            this.writeTag("jdk", null, activation.getJdk(), serializer, (InputLocationTracker)activation);
            this.writeActivationOS("os", activation.getOs(), serializer);
            this.writeActivationProperty("property", activation.getProperty(), serializer);
            this.writeActivationFile("file", activation.getFile(), serializer);
            this.writeTag("packaging", null, activation.getPackaging(), serializer, (InputLocationTracker)activation);
            serializer.writeEndElement();
        }
    }

    private void writeRepositoryBase(String tagName, RepositoryBase repositoryBase, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (repositoryBase != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, repositoryBase.getName(), serializer, (InputLocationTracker)repositoryBase);
            this.writeTag("url", null, repositoryBase.getUrl(), serializer, (InputLocationTracker)repositoryBase);
            this.writeTag("layout", "default", repositoryBase.getLayout(), serializer, (InputLocationTracker)repositoryBase);
            this.writeTag("id", "default", repositoryBase.getId(), serializer, (InputLocationTracker)repositoryBase);
            serializer.writeEndElement();
        }
    }

    private void writeRepository(String tagName, Repository repository, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (repository != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeRepositoryPolicy("releases", repository.getReleases(), serializer);
            this.writeRepositoryPolicy("snapshots", repository.getSnapshots(), serializer);
            this.writeTag("name", null, repository.getName(), serializer, (InputLocationTracker)repository);
            this.writeTag("url", null, repository.getUrl(), serializer, (InputLocationTracker)repository);
            this.writeTag("layout", "default", repository.getLayout(), serializer, (InputLocationTracker)repository);
            this.writeTag("id", "default", repository.getId(), serializer, (InputLocationTracker)repository);
            serializer.writeEndElement();
        }
    }

    private void writeRepositoryPolicy(String tagName, RepositoryPolicy repositoryPolicy, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (repositoryPolicy != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("enabled", "true", repositoryPolicy.isEnabled() ? null : "false", serializer, (InputLocationTracker)repositoryPolicy);
            this.writeTag("updatePolicy", null, repositoryPolicy.getUpdatePolicy(), serializer, (InputLocationTracker)repositoryPolicy);
            this.writeTag("checksumPolicy", null, repositoryPolicy.getChecksumPolicy(), serializer, (InputLocationTracker)repositoryPolicy);
            serializer.writeEndElement();
        }
    }

    private void writeActivationProperty(String tagName, ActivationProperty activationProperty, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (activationProperty != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, activationProperty.getName(), serializer, (InputLocationTracker)activationProperty);
            this.writeTag("value", null, activationProperty.getValue(), serializer, (InputLocationTracker)activationProperty);
            serializer.writeEndElement();
        }
    }

    private void writeActivationOS(String tagName, ActivationOS activationOS, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (activationOS != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, activationOS.getName(), serializer, (InputLocationTracker)activationOS);
            this.writeTag("family", null, activationOS.getFamily(), serializer, (InputLocationTracker)activationOS);
            this.writeTag("arch", null, activationOS.getArch(), serializer, (InputLocationTracker)activationOS);
            this.writeTag("version", null, activationOS.getVersion(), serializer, (InputLocationTracker)activationOS);
            serializer.writeEndElement();
        }
    }

    private void writeActivationFile(String tagName, ActivationFile activationFile, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (activationFile != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("missing", null, activationFile.getMissing(), serializer, (InputLocationTracker)activationFile);
            this.writeTag("exists", null, activationFile.getExists(), serializer, (InputLocationTracker)activationFile);
            serializer.writeEndElement();
        }
    }

    private <T> void writeList(String tagName, List<T> list, XMLStreamWriter serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException, XMLStreamException {
        this.writeList(tagName, false, list, serializer, locationTracker, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XMLStreamWriter serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException, XMLStreamException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.writeStartElement(this.namespace, tagName);
            }
            int index = 0;
            InputLocation location = locationTracker != null ? locationTracker.getLocation((Object)tagName) : null;
            for (T t : list) {
                writer.write(t);
                this.writeLocationTracking((InputLocationTracker)location, index++, serializer);
            }
            if (!flat) {
                serializer.writeEndElement();
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XMLStreamWriter serializer, InputLocationTracker locationTracker) throws IOException, XMLStreamException {
        if (props != null && !props.isEmpty()) {
            serializer.writeStartElement(this.namespace, tagName);
            InputLocation location = locationTracker != null ? locationTracker.getLocation((Object)tagName) : null;
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                this.writeTag(key, null, entry.getValue(), serializer, null);
                this.writeLocationTracking((InputLocationTracker)location, key, serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDom(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dom != null) {
            serializer.writeStartElement(this.namespace, dom.getName());
            for (Map.Entry attr : dom.getAttributes().entrySet()) {
                if (((String)attr.getKey()).startsWith("xml:")) {
                    serializer.writeAttribute("http://www.w3.org/XML/1998/namespace", ((String)attr.getKey()).substring(4), (String)attr.getValue());
                    continue;
                }
                serializer.writeAttribute((String)attr.getKey(), (String)attr.getValue());
            }
            for (XmlNode child : dom.getChildren()) {
                this.writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.writeCharacters(value);
            }
            serializer.writeEndElement();
            if (this.addLocationInformation && dom.getInputLocation() instanceof InputLocation && dom.getChildren().isEmpty()) {
                serializer.writeComment(this.toString((InputLocation)dom.getInputLocation()));
            }
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XMLStreamWriter serializer, InputLocationTracker locationTracker) throws IOException, XMLStreamException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.writeStartElement(this.namespace, tagName);
            serializer.writeCharacters(value);
            serializer.writeEndElement();
            this.writeLocationTracking(locationTracker, tagName, serializer);
        }
    }

    private void writeAttr(String attrName, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null) {
            serializer.writeAttribute(attrName, value);
        }
    }

    protected void writeLocationTracking(InputLocationTracker locationTracker, Object key, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (this.addLocationInformation) {
            InputLocation location;
            InputLocation inputLocation = location = locationTracker == null ? null : locationTracker.getLocation(key);
            if (location != null) {
                serializer.writeComment(this.toString(location));
            }
        }
    }

    protected String toString(InputLocation location) {
        if (this.stringFormatter != null) {
            return this.stringFormatter.apply(location);
        }
        if (location.getSource() != null) {
            return " " + location.getSource().toString() + ":" + location.getLineNumber() + " ";
        }
        return " " + location.getLineNumber() + " ";
    }

    static class IndentingXMLStreamWriter
    extends StreamWriterDelegate {
        int depth = 0;
        boolean hasChildren = false;

        public IndentingXMLStreamWriter(XMLStreamWriter parent) {
            super(parent);
        }

        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(localName);
            this.hasChildren = true;
        }

        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(namespaceURI, localName);
            this.hasChildren = true;
        }

        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(prefix, localName, namespaceURI);
            this.hasChildren = true;
        }

        public void writeStartElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(localName);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(namespaceURI, localName);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeStartElement(prefix, localName, namespaceURI);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeEndElement() throws XMLStreamException {
            --this.depth;
            if (this.hasChildren) {
                this.indent();
            }
            super.writeEndElement();
            this.hasChildren = true;
        }

        private void indent() throws XMLStreamException {
            super.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                super.writeCharacters("  ");
            }
        }
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException, XMLStreamException;
    }
}

