/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.InterpolatorException;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ModelTransformer;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.SuperPomProvider;
import org.apache.maven.api.services.VersionParserException;
import org.apache.maven.api.services.model.DependencyManagementImporter;
import org.apache.maven.api.services.model.DependencyManagementInjector;
import org.apache.maven.api.services.model.InheritanceAssembler;
import org.apache.maven.api.services.model.ModelCache;
import org.apache.maven.api.services.model.ModelCacheFactory;
import org.apache.maven.api.services.model.ModelInterpolator;
import org.apache.maven.api.services.model.ModelNormalizer;
import org.apache.maven.api.services.model.ModelPathTranslator;
import org.apache.maven.api.services.model.ModelProcessor;
import org.apache.maven.api.services.model.ModelResolver;
import org.apache.maven.api.services.model.ModelResolverException;
import org.apache.maven.api.services.model.ModelUrlNormalizer;
import org.apache.maven.api.services.model.ModelValidator;
import org.apache.maven.api.services.model.ModelVersionParser;
import org.apache.maven.api.services.model.PluginConfigurationExpander;
import org.apache.maven.api.services.model.PluginManagementInjector;
import org.apache.maven.api.services.model.ProfileInjector;
import org.apache.maven.api.services.model.ProfileSelector;
import org.apache.maven.api.services.model.RootLocator;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.spi.ModelParserException;
import org.apache.maven.internal.impl.model.DefaultInheritanceAssembler;
import org.apache.maven.internal.impl.model.DefaultModelBuilderResult;
import org.apache.maven.internal.impl.model.DefaultModelProblem;
import org.apache.maven.internal.impl.model.DefaultProfileActivationContext;
import org.apache.maven.internal.impl.model.Graph;
import org.apache.maven.internal.impl.model.ModelProblemUtils;
import org.apache.maven.internal.impl.model.ProfileActivationFilePathInterpolator;
import org.apache.maven.internal.impl.util.PhasingExecutor;
import org.apache.maven.model.v4.MavenTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultModelBuilder
implements ModelBuilder {
    public static final String NAMESPACE_PREFIX = "http://maven.apache.org/POM/";
    private static final String RAW = "raw";
    private static final String FILE = "file";
    private static final String IMPORT = "import";
    private static final String PARENT = "parent";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ModelProcessor modelProcessor;
    private final ModelValidator modelValidator;
    private final ModelNormalizer modelNormalizer;
    private final ModelInterpolator modelInterpolator;
    private final ModelPathTranslator modelPathTranslator;
    private final ModelUrlNormalizer modelUrlNormalizer;
    private final SuperPomProvider superPomProvider;
    private final InheritanceAssembler inheritanceAssembler;
    private final ProfileSelector profileSelector;
    private final ProfileInjector profileInjector;
    private final PluginManagementInjector pluginManagementInjector;
    private final DependencyManagementInjector dependencyManagementInjector;
    private final DependencyManagementImporter dependencyManagementImporter;
    private final PluginConfigurationExpander pluginConfigurationExpander;
    private final ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator;
    private final ModelVersionParser versionParser;
    private final List<org.apache.maven.api.spi.ModelTransformer> transformers;
    private final ModelCacheFactory modelCacheFactory;
    private final ModelResolver modelResolver;
    private final Interpolator interpolator;

    @Inject
    public DefaultModelBuilder(ModelProcessor modelProcessor, ModelValidator modelValidator, ModelNormalizer modelNormalizer, ModelInterpolator modelInterpolator, ModelPathTranslator modelPathTranslator, ModelUrlNormalizer modelUrlNormalizer, SuperPomProvider superPomProvider, InheritanceAssembler inheritanceAssembler, ProfileSelector profileSelector, ProfileInjector profileInjector, PluginManagementInjector pluginManagementInjector, DependencyManagementInjector dependencyManagementInjector, DependencyManagementImporter dependencyManagementImporter, PluginConfigurationExpander pluginConfigurationExpander, ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator, ModelVersionParser versionParser, List<org.apache.maven.api.spi.ModelTransformer> transformers, ModelCacheFactory modelCacheFactory, ModelResolver modelResolver, Interpolator interpolator) {
        this.modelProcessor = modelProcessor;
        this.modelValidator = modelValidator;
        this.modelNormalizer = modelNormalizer;
        this.modelInterpolator = modelInterpolator;
        this.modelPathTranslator = modelPathTranslator;
        this.modelUrlNormalizer = modelUrlNormalizer;
        this.superPomProvider = superPomProvider;
        this.inheritanceAssembler = inheritanceAssembler;
        this.profileSelector = profileSelector;
        this.profileInjector = profileInjector;
        this.pluginManagementInjector = pluginManagementInjector;
        this.dependencyManagementInjector = dependencyManagementInjector;
        this.dependencyManagementImporter = dependencyManagementImporter;
        this.pluginConfigurationExpander = pluginConfigurationExpander;
        this.profileActivationFilePathInterpolator = profileActivationFilePathInterpolator;
        this.versionParser = versionParser;
        this.transformers = transformers;
        this.modelCacheFactory = modelCacheFactory;
        this.modelResolver = modelResolver;
        this.interpolator = interpolator;
    }

    public ModelBuilder.ModelBuilderSession newSession() {
        return new ModelBuilder.ModelBuilderSession(){
            DefaultModelBuilderSession mainSession;

            public ModelBuilderResult build(ModelBuilderRequest request) throws ModelBuilderException {
                DefaultModelBuilderSession session = this.mainSession == null ? (this.mainSession = new DefaultModelBuilderSession(request)) : this.mainSession.derive(request, new DefaultModelBuilderResult());
                if (request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_POM) {
                    session.buildBuildPom();
                } else {
                    session.buildEffectiveModel(new LinkedHashSet<String>());
                }
                return session.result;
            }
        };
    }

    private static List<String> getSubprojects(Model activated) {
        List subprojects = activated.getSubprojects();
        if (subprojects.isEmpty()) {
            subprojects = activated.getModules();
        }
        return subprojects;
    }

    public Model buildRawModel(ModelBuilderRequest request) throws ModelBuilderException {
        DefaultModelBuilderSession build = new DefaultModelBuilderSession(request);
        Model model = build.readRawModel();
        if (build.hasErrors()) {
            throw build.newModelBuilderException();
        }
        return model;
    }

    static String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        return groupId;
    }

    static String getVersion(Model model) {
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    private DefaultProfileActivationContext getProfileActivationContext(ModelBuilderRequest request, Model model) {
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(request.getActiveProfileIds());
        context.setInactiveProfileIds(request.getInactiveProfileIds());
        context.setSystemProperties(request.getSystemProperties());
        HashMap<String, String> userProperties = new HashMap<String, String>(request.getUserProperties());
        if (!userProperties.containsKey("packaging")) {
            userProperties.put("packaging", model.getPackaging());
        }
        context.setUserProperties(userProperties);
        context.setProjectDirectory(model.getProjectDirectory());
        return context;
    }

    private Map<String, Activation> getProfileActivations(Model model) {
        return model.getProfiles().stream().filter(p -> p.getActivation() != null).collect(Collectors.toMap(Profile::getId, Profile::getActivation));
    }

    private Model injectProfileActivations(Model model, Map<String, Activation> activations) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        boolean modified = false;
        for (Profile profile : model.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation != null) {
                profile = profile.withActivation(activations.get(profile.getId()));
                modified = true;
            }
            profiles.add(profile);
        }
        return modified ? model.withProfiles(profiles) : model;
    }

    private Model interpolateModel(Model model, ModelBuilderRequest request, ModelProblemCollector problems) {
        Model interpolatedModel = this.modelInterpolator.interpolateModel(model, model.getProjectDirectory(), request, problems);
        if (interpolatedModel.getParent() != null) {
            Map map1 = request.getSession().getUserProperties();
            Map map2 = model.getProperties();
            Map map3 = request.getSession().getSystemProperties();
            Function[] functionArray = new Function[3];
            functionArray[0] = map1::get;
            functionArray[1] = map2::get;
            functionArray[2] = map3::get;
            Function cb = Interpolator.chain((Function[])functionArray);
            try {
                String interpolated = this.interpolator.interpolate(interpolatedModel.getParent().getVersion(), cb);
                interpolatedModel = interpolatedModel.withParent(interpolatedModel.getParent().withVersion(interpolated));
            }
            catch (Exception e) {
                problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Failed to interpolate field: " + interpolatedModel.getParent().getVersion() + " on class: ", e);
            }
        }
        interpolatedModel = interpolatedModel.withPomFile(model.getPomFile());
        return interpolatedModel;
    }

    private boolean rawChildVersionReferencesParent(String rawChildModelVersion) {
        return rawChildModelVersion.equals("${pom.version}") || rawChildModelVersion.equals("${project.version}") || rawChildModelVersion.equals("${pom.parent.version}") || rawChildModelVersion.equals("${project.parent.version}");
    }

    private Model getSuperModel(String modelVersion) {
        return this.superPomProvider.getSuperPom(modelVersion);
    }

    private static Dependency addExclusions(Dependency candidate, List<Exclusion> exclusions) {
        return candidate.withExclusions(Stream.concat(candidate.getExclusions().stream(), exclusions.stream()).toList());
    }

    private boolean match(Exclusion exclusion, Dependency candidate) {
        return this.match(exclusion.getGroupId(), candidate.getGroupId()) && this.match(exclusion.getArtifactId(), candidate.getArtifactId());
    }

    private boolean match(String match, String text) {
        return match.equals("*") || match.equals(text);
    }

    private boolean containsCoordinates(String message, String groupId, String artifactId, String version) {
        return !(message == null || groupId != null && !message.contains(groupId) || artifactId != null && !message.contains(artifactId) || version != null && !message.contains(version));
    }

    protected class DefaultModelBuilderSession
    implements ModelProblemCollector {
        private static final Pattern REGEX = Pattern.compile("\\$\\{([^}]+)}");
        final Session session;
        final ModelBuilderRequest request;
        final DefaultModelBuilderResult result;
        final ModelCache cache;
        final Graph dag;
        final Map<GAKey, Set<ModelSource>> mappedSources;
        String source;
        Model sourceModel;
        Model rootModel;
        List<RemoteRepository> pomRepositories;
        List<RemoteRepository> externalRepositories;
        List<RemoteRepository> repositories;

        DefaultModelBuilderSession(ModelBuilderRequest request) {
            this(request.getSession(), request, new DefaultModelBuilderResult(), (ModelCache)request.getSession().getData().computeIfAbsent(SessionData.key(ModelCache.class), this$0.modelCacheFactory::newInstance), new Graph(), new ConcurrentHashMap<GAKey, Set<ModelSource>>(64), List.of(), DefaultModelBuilderSession.repos(request), DefaultModelBuilderSession.repos(request));
        }

        static List<RemoteRepository> repos(ModelBuilderRequest request) {
            return List.copyOf(request.getRepositories() != null ? request.getRepositories() : request.getSession().getRemoteRepositories());
        }

        private DefaultModelBuilderSession(Session session, ModelBuilderRequest request, DefaultModelBuilderResult result, ModelCache cache, Graph dag, Map<GAKey, Set<ModelSource>> mappedSources, List<RemoteRepository> pomRepositories, List<RemoteRepository> externalRepositories, List<RemoteRepository> repositories) {
            this.session = session;
            this.request = request;
            this.result = result;
            this.cache = cache;
            this.dag = dag;
            this.mappedSources = mappedSources;
            this.pomRepositories = pomRepositories;
            this.externalRepositories = externalRepositories;
            this.repositories = repositories;
            this.result.setSource(this.request.getSource());
        }

        DefaultModelBuilderSession derive(ModelSource source) {
            return this.derive(source, new DefaultModelBuilderResult(this.result));
        }

        DefaultModelBuilderSession derive(ModelSource source, DefaultModelBuilderResult result) {
            return this.derive(ModelBuilderRequest.build((ModelBuilderRequest)this.request, (ModelSource)source), result);
        }

        DefaultModelBuilderSession derive(ModelBuilderRequest request) {
            return this.derive(request, new DefaultModelBuilderResult(this.result));
        }

        DefaultModelBuilderSession derive(ModelBuilderRequest request, DefaultModelBuilderResult result) {
            if (this.session != request.getSession()) {
                throw new IllegalArgumentException("Session mismatch");
            }
            return new DefaultModelBuilderSession(this.session, request, result, this.cache, this.dag, this.mappedSources, this.pomRepositories, this.externalRepositories, this.repositories);
        }

        public String toString() {
            return "ModelBuilderSession[session=" + String.valueOf(this.session) + ", request=" + String.valueOf(this.request) + ", result=" + String.valueOf(this.result) + ", cache=" + String.valueOf(this.cache) + "]";
        }

        PhasingExecutor createExecutor() {
            return new PhasingExecutor(Executors.newFixedThreadPool(this.getParallelism()));
        }

        private int getParallelism() {
            int parallelism = Runtime.getRuntime().availableProcessors() / 2 + 1;
            try {
                String str = (String)this.request.getUserProperties().get("maven.modelBuilder.parallelism");
                if (str != null) {
                    parallelism = Integer.parseInt(str);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Math.max(1, Math.min(parallelism, Runtime.getRuntime().availableProcessors()));
        }

        public Model getRawModel(Path from, String groupId, String artifactId) {
            ModelSource source = this.getSource(groupId, artifactId);
            if (source != null) {
                if (this.addEdge(from, source.getPath())) {
                    return null;
                }
                try {
                    return this.derive(source).readRawModel();
                }
                catch (ModelBuilderException modelBuilderException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Model getRawModel(Path from, Path path) {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new IllegalArgumentException("Not a regular file: " + String.valueOf(path));
            }
            if (this.addEdge(from, path)) {
                return null;
            }
            try {
                return this.derive(ModelSource.fromPath((Path)path)).readRawModel();
            }
            catch (ModelBuilderException modelBuilderException) {
                return null;
            }
        }

        private boolean addEdge(Path from, Path p) {
            try {
                this.dag.addEdge(from.toString(), p.toString());
                return false;
            }
            catch (Graph.CycleDetectedException e) {
                this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "Cycle detected between models at " + String.valueOf(from) + " and " + String.valueOf(p), null, e);
                return true;
            }
        }

        public ModelSource getSource(String groupId, String artifactId) {
            Set<ModelSource> sources = this.mappedSources.get(new GAKey(groupId, artifactId));
            if (sources != null) {
                return sources.stream().reduce((a, b) -> {
                    throw new IllegalStateException(String.format("No unique Source for %s:%s: %s and %s", groupId, artifactId, a.getLocation(), b.getLocation()));
                }).orElse(null);
            }
            return null;
        }

        public void putSource(String groupId, String artifactId, ModelSource source) {
            this.mappedSources.computeIfAbsent(new GAKey(groupId, artifactId), k -> new HashSet()).add(source);
            if (groupId != null) {
                this.putSource(null, artifactId, source);
            }
        }

        public boolean hasFatalErrors() {
            return this.result.getProblems().stream().anyMatch(p -> p.getSeverity() == BuilderProblem.Severity.FATAL);
        }

        public boolean hasErrors() {
            return this.result.getProblems().stream().anyMatch(p -> p.getSeverity() == BuilderProblem.Severity.FATAL || p.getSeverity() == BuilderProblem.Severity.ERROR);
        }

        public List<ModelProblem> getProblems() {
            return this.result.getProblems();
        }

        public void setSource(String source) {
            this.source = source;
            this.sourceModel = null;
        }

        public void setSource(Model source) {
            this.sourceModel = source;
            this.source = null;
            if (this.rootModel == null) {
                this.rootModel = source;
            }
        }

        public String getSource() {
            if (this.source == null && this.sourceModel != null) {
                this.source = ModelProblemUtils.toPath(this.sourceModel);
            }
            return this.source;
        }

        private String getModelId() {
            return ModelProblemUtils.toId(this.sourceModel);
        }

        public void setRootModel(Model rootModel) {
            this.rootModel = rootModel;
        }

        public Model getRootModel() {
            return this.rootModel;
        }

        public void add(ModelProblem problem) {
            this.result.addProblem(problem);
        }

        public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message) {
            this.add(severity, version, message, null, null);
        }

        public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message, InputLocation location) {
            this.add(severity, version, message, location, null);
        }

        public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message, Exception exception) {
            this.add(severity, version, message, null, exception);
        }

        public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message, InputLocation location, Exception exception) {
            int line = -1;
            int column = -1;
            String source = null;
            String modelId = null;
            if (location != null) {
                line = location.getLineNumber();
                column = location.getColumnNumber();
                if (location.getSource() != null) {
                    modelId = location.getSource().getModelId();
                    source = location.getSource().getLocation();
                }
            }
            if (modelId == null) {
                modelId = this.getModelId();
                source = this.getSource();
            }
            if (line <= 0 && column <= 0 && exception instanceof ModelParserException) {
                ModelParserException e = (ModelParserException)exception;
                line = e.getLineNumber();
                column = e.getColumnNumber();
            }
            DefaultModelProblem problem = new DefaultModelProblem(message, severity, version, source, line, column, modelId, exception);
            this.add(problem);
        }

        public ModelBuilderException newModelBuilderException() {
            return new ModelBuilderException((ModelBuilderResult)this.result);
        }

        public void mergeRepositories(List<Repository> toAdd, boolean replace) {
            List<RemoteRepository> repos = toAdd.stream().map(arg_0 -> ((Session)this.session).createRemoteRepository(arg_0)).toList();
            if (replace) {
                ids = repos.stream().map(org.apache.maven.api.Repository::getId).collect(Collectors.toSet());
                this.repositories = this.repositories.stream().filter(r -> !ids.contains(r.getId())).toList();
                this.pomRepositories = this.pomRepositories.stream().filter(r -> !ids.contains(r.getId())).toList();
            } else {
                ids = this.pomRepositories.stream().map(org.apache.maven.api.Repository::getId).collect(Collectors.toSet());
                repos = repos.stream().filter(r -> !ids.contains(r.getId())).toList();
            }
            RepositoryFactory repositoryFactory = (RepositoryFactory)this.session.getService(RepositoryFactory.class);
            if (this.request.getRepositoryMerging() == ModelBuilderRequest.RepositoryMerging.REQUEST_DOMINANT) {
                this.repositories = repositoryFactory.aggregate(this.session, this.repositories, repos, true);
                this.pomRepositories = this.repositories;
            } else {
                this.pomRepositories = repositoryFactory.aggregate(this.session, this.pomRepositories, repos, true);
                this.repositories = repositoryFactory.aggregate(this.session, this.pomRepositories, this.externalRepositories, false);
            }
        }

        Model transformFileToRaw(Model model) {
            if (model.getDependencies().isEmpty()) {
                return model;
            }
            ArrayList<Dependency> newDeps = new ArrayList<Dependency>(model.getDependencies().size());
            boolean changed = false;
            for (Dependency dep : model.getDependencies()) {
                Dependency newDep = null;
                if (dep.getVersion() == null && (newDep = this.inferDependencyVersion(model, dep)) != null) {
                    changed = true;
                }
                newDeps.add(newDep == null ? dep : newDep);
            }
            return changed ? model.withDependencies(newDeps) : model;
        }

        private Dependency inferDependencyVersion(Model model, Dependency dep) {
            Model depModel = this.getRawModel(model.getPomFile(), dep.getGroupId(), dep.getArtifactId());
            if (depModel == null) {
                return null;
            }
            Dependency.Builder depBuilder = Dependency.newBuilder((Dependency)dep);
            String version = depModel.getVersion();
            InputLocation versionLocation = depModel.getLocation((Object)"version");
            if (version == null && depModel.getParent() != null) {
                version = depModel.getParent().getVersion();
                versionLocation = depModel.getParent().getLocation((Object)"version");
            }
            depBuilder.version(version).location((Object)"version", versionLocation);
            if (dep.getGroupId() == null) {
                String depGroupId = depModel.getGroupId();
                InputLocation groupIdLocation = depModel.getLocation((Object)"groupId");
                if (depGroupId == null && depModel.getParent() != null) {
                    depGroupId = depModel.getParent().getGroupId();
                    groupIdLocation = depModel.getParent().getLocation((Object)"groupId");
                }
                depBuilder.groupId(depGroupId).location((Object)"groupId", groupIdLocation);
            }
            return depBuilder.build();
        }

        String replaceCiFriendlyVersion(Map<String, String> properties, String version) {
            Matcher matcher;
            if (version != null && (matcher = REGEX.matcher(version)).find()) {
                StringBuilder result = new StringBuilder();
                do {
                    String key = matcher.group(1);
                    String replacement = properties.getOrDefault(key, "\\" + matcher.group(0));
                    matcher.appendReplacement(result, replacement);
                } while (matcher.find());
                matcher.appendTail(result);
                return result.toString();
            }
            return version;
        }

        private void buildBuildPom() throws ModelBuilderException {
            Path rootDirectory;
            Path top = this.request.getSource().getPath();
            if (top == null) {
                throw new IllegalStateException("Recursive build requested but source has no path");
            }
            top = top.toAbsolutePath().normalize();
            try {
                rootDirectory = this.session.getRootDirectory();
            }
            catch (IllegalStateException e) {
                rootDirectory = ((RootLocator)this.session.getService(RootLocator.class)).findMandatoryRoot(top);
            }
            Path root = DefaultModelBuilder.this.modelProcessor.locateExistingPom(rootDirectory);
            root = root != null ? root.toAbsolutePath().normalize() : top;
            this.loadFromRoot(root, top);
            if (this.hasErrors()) {
                throw this.newModelBuilderException();
            }
            List<DefaultModelBuilderResult> allResults = this.results(this.result).toList();
            CopyOnWriteArrayList exceptions = new CopyOnWriteArrayList();
            try (PhasingExecutor executor = this.createExecutor();){
                for (DefaultModelBuilderResult r : allResults) {
                    executor.execute(() -> {
                        DefaultModelBuilderSession mbs = this.derive(r.getSource(), r);
                        try {
                            mbs.buildEffectiveModel(new LinkedHashSet<String>());
                        }
                        catch (ModelBuilderException modelBuilderException) {
                        }
                        catch (RuntimeException t) {
                            exceptions.add(t);
                        }
                    });
                }
            }
            if (exceptions.size() == 1) {
                throw (RuntimeException)exceptions.get(0);
            }
            if (exceptions.size() > 1) {
                MavenException fatalException = new MavenException("Multiple fatal exceptions occurred");
                exceptions.forEach(arg_0 -> fatalException.addSuppressed(arg_0));
                throw fatalException;
            }
            if (this.hasErrors()) {
                throw this.newModelBuilderException();
            }
        }

        Stream<DefaultModelBuilderResult> results(DefaultModelBuilderResult r) {
            return Stream.concat(Stream.of(r), r.getChildren().stream().flatMap(this::results));
        }

        private void loadFromRoot(Path root, Path top) {
            try (PhasingExecutor executor = this.createExecutor();){
                DefaultModelBuilderResult r = Objects.equals(top, root) ? this.result : new DefaultModelBuilderResult();
                this.loadFilePom(executor, top, root, Set.of(), r);
            }
            if (this.result.getFileModel() == null && !Objects.equals(top, root)) {
                DefaultModelBuilder.this.logger.warn("The top project ({}) cannot be found in the reactor from root project ({}). Make sure the root directory is correct (a missing '.mvn' directory in the root project is the most common cause) and the project is correctly included in the reactor (missing activated profiles, command line options, etc.). For this build, the top project will be used as the root project.", (Object)top, (Object)root);
                this.cache.clear();
                this.mappedSources.clear();
                this.loadFromRoot(top, top);
            }
        }

        private void loadFilePom(Executor executor, Path top, Path pom, Set<Path> parents, DefaultModelBuilderResult r) {
            try {
                Path pomDirectory = Files.isDirectory(pom, new LinkOption[0]) ? pom : pom.getParent();
                ModelSource src = ModelSource.fromPath((Path)pom);
                Model model = this.derive(src, r).readFileModel();
                this.putSource(DefaultModelBuilder.getGroupId(model), model.getArtifactId(), src);
                Model activated = this.activateFileModel(model);
                for (String subproject : DefaultModelBuilder.getSubprojects(activated)) {
                    DefaultModelBuilderResult cr;
                    if (subproject == null || subproject.isEmpty()) continue;
                    Path rawSubprojectFile = DefaultModelBuilder.this.modelProcessor.locateExistingPom(pomDirectory.resolve(subproject = subproject.replace('\\', File.separatorChar).replace('/', File.separatorChar)));
                    if (rawSubprojectFile == null) {
                        DefaultModelProblem problem = new DefaultModelProblem("Child subproject " + subproject + " of " + String.valueOf(pomDirectory) + " does not exist", BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, model, -1, -1, null);
                        r.addProblem(problem);
                        continue;
                    }
                    Path subprojectFile = rawSubprojectFile.toAbsolutePath().normalize();
                    if (parents.contains(subprojectFile)) {
                        StringBuilder buffer = new StringBuilder(256);
                        for (Path aggregatorFile : parents) {
                            buffer.append(aggregatorFile).append(" -> ");
                        }
                        buffer.append(subprojectFile);
                        DefaultModelProblem problem = new DefaultModelProblem("Child subproject " + String.valueOf(subprojectFile) + " of " + String.valueOf(pom) + " forms aggregation cycle " + String.valueOf(buffer), BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, model, -1, -1, null);
                        r.addProblem(problem);
                        continue;
                    }
                    DefaultModelBuilderResult defaultModelBuilderResult = cr = Objects.equals(top, subprojectFile) ? this.result : new DefaultModelBuilderResult(r);
                    if (this.request.isRecursive()) {
                        r.getChildren().add(cr);
                    }
                    executor.execute(() -> this.loadFilePom(executor, top, subprojectFile, DefaultModelBuilderSession.concat(parents, pom), cr));
                }
            }
            catch (ModelBuilderException e) {
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.V40, "Failed to load project " + String.valueOf(pom), (Exception)((Object)e));
            }
            if (r != this.result) {
                r.getProblems().forEach(this.result::addProblem);
            }
        }

        static <T> Set<T> concat(Set<T> a, T b) {
            HashSet<T> result = new HashSet<T>(a);
            result.add(b);
            return Set.copyOf(result);
        }

        void buildEffectiveModel(Collection<String> importIds) throws ModelBuilderException {
            ModelTransformer lifecycleBindingsInjector;
            Model resultModel = this.readEffectiveModel();
            this.setSource(resultModel);
            this.setRootModel(resultModel);
            resultModel = DefaultModelBuilder.this.modelPathTranslator.alignToBaseDirectory(resultModel, resultModel.getProjectDirectory(), this.request);
            resultModel = DefaultModelBuilder.this.pluginManagementInjector.injectManagement(resultModel, this.request, this);
            if (this.request.getRequestType() != ModelBuilderRequest.RequestType.DEPENDENCY && (lifecycleBindingsInjector = this.request.getLifecycleBindingsInjector()) != null) {
                resultModel = lifecycleBindingsInjector.transform(resultModel, this.request, (ModelProblemCollector)this);
            }
            resultModel = this.importDependencyManagement(resultModel, importIds);
            resultModel = DefaultModelBuilder.this.dependencyManagementInjector.injectManagement(resultModel, this.request, this);
            resultModel = DefaultModelBuilder.this.modelNormalizer.injectDefaultValues(resultModel, this.request, this);
            if (this.request.getRequestType() != ModelBuilderRequest.RequestType.DEPENDENCY) {
                resultModel = DefaultModelBuilder.this.pluginConfigurationExpander.expandPluginConfiguration(resultModel, this.request, this);
            }
            for (org.apache.maven.api.spi.ModelTransformer transformer : DefaultModelBuilder.this.transformers) {
                resultModel = transformer.transformEffectiveModel(resultModel);
            }
            this.result.setEffectiveModel(resultModel);
            if (this.result.getFileModel().getParent() != null && this.result.getFileModel().getParent().getRelativePath() == null) {
                this.result.setFileModel(this.result.getFileModel().withParent(this.result.getFileModel().getParent().withRelativePath(resultModel.getParent().getRelativePath())));
            }
            DefaultModelBuilder.this.modelValidator.validateEffectiveModel(resultModel, this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_POM ? 40 : 0, this.request, this);
            if (this.hasErrors()) {
                throw this.newModelBuilderException();
            }
        }

        Model readParent(Model childModel) throws ModelBuilderException {
            Model parentModel;
            Parent parent = childModel.getParent();
            if (parent != null) {
                parentModel = this.resolveParent(childModel);
                if (!"pom".equals(parentModel.getPackaging())) {
                    this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Invalid packaging for parent POM " + ModelProblemUtils.toSourceHint(parentModel) + ", must be \"pom\" but is \"" + parentModel.getPackaging() + "\"", parentModel.getLocation((Object)"packaging"));
                }
                this.result.setParentModel(parentModel);
            } else {
                String superModelVersion = childModel.getModelVersion();
                if (superModelVersion == null || !ModelBuilder.VALID_MODEL_VERSIONS.contains(superModelVersion)) {
                    superModelVersion = "4.0.0";
                }
                parentModel = DefaultModelBuilder.this.getSuperModel(superModelVersion);
            }
            return parentModel;
        }

        private Model resolveParent(Model childModel) {
            Model parentModel = null;
            if (this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_POM || this.request.getRequestType() == ModelBuilderRequest.RequestType.CONSUMER_POM) {
                parentModel = this.readParentLocally(childModel);
            }
            if (parentModel == null) {
                parentModel = this.resolveAndReadParentExternally(childModel);
            }
            return parentModel;
        }

        private Model readParentLocally(Model childModel) throws ModelBuilderException {
            ModelSource candidateSource = null;
            Parent parent = childModel.getParent();
            String parentPath = parent.getRelativePath();
            if (parentPath != null && !parentPath.isEmpty()) {
                candidateSource = this.request.getSource().resolve(DefaultModelBuilder.this.modelProcessor::locateExistingPom, parentPath);
                if (candidateSource == null) {
                    this.wrongParentRelativePath(childModel);
                    return null;
                }
            }
            if (candidateSource == null) {
                candidateSource = this.resolveReactorModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            if (candidateSource == null) {
                candidateSource = this.request.getSource().resolve(DefaultModelBuilder.this.modelProcessor::locateExistingPom, "..");
            }
            if (candidateSource == null) {
                return null;
            }
            Model candidateModel = this.derive(candidateSource).readAsParentModel();
            String groupId = DefaultModelBuilder.getGroupId(candidateModel);
            String artifactId = candidateModel.getArtifactId();
            String version = DefaultModelBuilder.getVersion(candidateModel);
            if (groupId == null || !groupId.equals(parent.getGroupId()) || artifactId == null || !artifactId.equals(parent.getArtifactId())) {
                this.mismatchRelativePathAndGA(childModel, groupId, artifactId);
                return null;
            }
            if (version != null && parent.getVersion() != null && !version.equals(parent.getVersion())) {
                try {
                    VersionRange parentRange = DefaultModelBuilder.this.versionParser.parseVersionRange(parent.getVersion());
                    if (!parentRange.contains(DefaultModelBuilder.this.versionParser.parseVersion(version))) {
                        return null;
                    }
                    String rawChildModelVersion = childModel.getVersion();
                    if (rawChildModelVersion == null) {
                        this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)""));
                    } else if (DefaultModelBuilder.this.rawChildVersionReferencesParent(rawChildModelVersion)) {
                        this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)"version"));
                    }
                }
                catch (VersionParserException e) {
                    return null;
                }
            }
            return candidateModel;
        }

        private void mismatchRelativePathAndGA(Model childModel, String groupId, String artifactId) {
            Parent parent = childModel.getParent();
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("'parent.relativePath'");
            if (childModel != this.getRootModel()) {
                buffer.append(" of POM ").append(ModelProblemUtils.toSourceHint(childModel));
            }
            buffer.append(" points at ").append(groupId).append(':').append(artifactId);
            buffer.append(" instead of ").append(parent.getGroupId()).append(':');
            buffer.append(parent.getArtifactId()).append(", please verify your project structure");
            this.setSource(childModel);
            boolean warn = "4.0.0".equals(childModel.getModelVersion()) || childModel.getParent().getRelativePath() == null;
            this.add(warn ? BuilderProblem.Severity.WARNING : BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, buffer.toString(), parent.getLocation((Object)""));
        }

        private void wrongParentRelativePath(Model childModel) {
            Parent parent = childModel.getParent();
            String parentPath = parent.getRelativePath();
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("'parent.relativePath'");
            if (childModel != this.getRootModel()) {
                buffer.append(" of POM ").append(ModelProblemUtils.toSourceHint(childModel));
            }
            buffer.append(" points at '").append(parentPath);
            buffer.append("' but no POM could be found, please verify your project structure");
            this.setSource(childModel);
            this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, buffer.toString(), parent.getLocation((Object)""));
        }

        Model resolveAndReadParentExternally(Model childModel) throws ModelBuilderException {
            ModelSource modelSource;
            ModelBuilderRequest request = this.request;
            this.setSource(childModel);
            Parent parent = childModel.getParent();
            String groupId = parent.getGroupId();
            String artifactId = parent.getArtifactId();
            String version = parent.getVersion();
            if (!childModel.getRepositories().isEmpty()) {
                List<RemoteRepository> previousRepositories = this.repositories;
                this.mergeRepositories(childModel.getRepositories(), false);
                if (!Objects.equals(previousRepositories, this.repositories) && DefaultModelBuilder.this.logger.isDebugEnabled()) {
                    DefaultModelBuilder.this.logger.debug("Merging repositories from " + childModel.getId() + "\n" + this.repositories.stream().map(Object::toString).collect(Collectors.joining("\n", "    ", "")));
                }
            }
            try {
                modelSource = this.resolveReactorModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
                if (modelSource == null) {
                    AtomicReference<Parent> modified = new AtomicReference<Parent>();
                    modelSource = DefaultModelBuilder.this.modelResolver.resolveModel(request.getSession(), this.repositories, parent, modified);
                    if (modified.get() != null) {
                        parent = modified.get();
                    }
                }
            }
            catch (ModelResolverException e) {
                StringBuilder buffer = new StringBuilder(256);
                buffer.append("Non-resolvable parent POM");
                if (!DefaultModelBuilder.this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                    buffer.append(' ').append(ModelProblemUtils.toId(groupId, artifactId, version));
                }
                if (childModel != this.getRootModel()) {
                    buffer.append(" for ").append(ModelProblemUtils.toId(childModel));
                }
                buffer.append(": ").append(e.getMessage());
                if (request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_POM) {
                    buffer.append(" and parent could not be found in reactor");
                }
                this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, buffer.toString(), parent.getLocation((Object)""), (Exception)((Object)e));
                throw this.newModelBuilderException();
            }
            ModelBuilderRequest lenientRequest = ModelBuilderRequest.builder((ModelBuilderRequest)request).requestType(ModelBuilderRequest.RequestType.PARENT_POM).source(modelSource).build();
            Model parentModel = this.derive(lenientRequest).readAsParentModel();
            if (!parent.getVersion().equals(version)) {
                String rawChildModelVersion = childModel.getVersion();
                if (rawChildModelVersion == null) {
                    this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)""));
                } else if (DefaultModelBuilder.this.rawChildVersionReferencesParent(rawChildModelVersion)) {
                    this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)"version"));
                }
            }
            return parentModel;
        }

        Model activateFileModel(Model inputModel) throws ModelBuilderException {
            this.setRootModel(inputModel);
            DefaultProfileActivationContext profileActivationContext = DefaultModelBuilder.this.getProfileActivationContext(this.request, inputModel);
            this.setSource("(external profiles)");
            List<Profile> activeExternalProfiles = this.getActiveProfiles(this.request.getProfiles(), profileActivationContext);
            this.result.setActiveExternalProfiles(activeExternalProfiles);
            if (!activeExternalProfiles.isEmpty()) {
                Properties profileProps = new Properties();
                for (Profile profile : activeExternalProfiles) {
                    profileProps.putAll((Map<?, ?>)profile.getProperties());
                }
                profileProps.putAll(profileActivationContext.getUserProperties());
                profileActivationContext.setUserProperties(profileProps);
            }
            profileActivationContext.setProjectProperties(inputModel.getProperties());
            this.setSource(inputModel);
            List<Profile> activePomProfiles = this.getActiveProfiles(inputModel.getProfiles(), profileActivationContext);
            this.setSource(inputModel);
            inputModel = DefaultModelBuilder.this.modelNormalizer.mergeDuplicates(inputModel, this.request, this);
            Map<String, Activation> interpolatedActivations = DefaultModelBuilder.this.getProfileActivations(inputModel);
            inputModel = DefaultModelBuilder.this.injectProfileActivations(inputModel, interpolatedActivations);
            inputModel = DefaultModelBuilder.this.profileInjector.injectProfiles(inputModel, activePomProfiles, this.request, this);
            inputModel = DefaultModelBuilder.this.profileInjector.injectProfiles(inputModel, activeExternalProfiles, this.request, this);
            return inputModel;
        }

        private Model readEffectiveModel() throws ModelBuilderException {
            Model inputModel = this.readRawModel();
            if (this.hasFatalErrors()) {
                throw this.newModelBuilderException();
            }
            this.setRootModel(inputModel);
            Model activatedFileModel = this.activateFileModel(inputModel);
            DefaultProfileActivationContext profileActivationContext = DefaultModelBuilder.this.getProfileActivationContext(this.request, activatedFileModel);
            List<Profile> activeExternalProfiles = this.result.getActiveExternalProfiles();
            if (!activeExternalProfiles.isEmpty()) {
                Properties profileProps = new Properties();
                for (Profile profile : activeExternalProfiles) {
                    profileProps.putAll((Map<?, ?>)profile.getProperties());
                }
                profileProps.putAll(profileActivationContext.getUserProperties());
                profileActivationContext.setUserProperties(profileProps);
            }
            Model parentModel = this.readParent(activatedFileModel);
            if (inputModel.getParent() != null && inputModel.getParent().getRelativePath() == null) {
                String relPath = parentModel.getPomFile() != null && (this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_POM || this.request.getRequestType() == ModelBuilderRequest.RequestType.CONSUMER_POM) ? inputModel.getPomFile().getParent().relativize(parentModel.getPomFile().getParent()).toString() : "..";
                inputModel = inputModel.withParent(inputModel.getParent().withRelativePath(relPath));
            }
            List<Profile> parentInterpolatedProfiles = this.interpolateActivations(parentModel.getProfiles(), profileActivationContext, this);
            List<Profile> parentActivePomProfiles = this.getActiveProfiles(parentInterpolatedProfiles, profileActivationContext);
            Model injectedParentModel = DefaultModelBuilder.this.profileInjector.injectProfiles(parentModel, parentActivePomProfiles, this.request, this).withProfiles(List.of());
            Model model = DefaultModelBuilder.this.inheritanceAssembler.assembleModelInheritance(inputModel, injectedParentModel, this.request, this);
            model = DefaultModelBuilder.this.modelNormalizer.mergeDuplicates(model, this.request, this);
            profileActivationContext.setProjectProperties(model.getProperties());
            List<Profile> interpolatedProfiles = this.interpolateActivations(model.getProfiles(), profileActivationContext, this);
            List<Profile> activePomProfiles = this.getActiveProfiles(interpolatedProfiles, profileActivationContext);
            this.result.setActivePomProfiles(activePomProfiles);
            model = DefaultModelBuilder.this.profileInjector.injectProfiles(model, activePomProfiles, this.request, this);
            Model resultModel = model = DefaultModelBuilder.this.profileInjector.injectProfiles(model, activeExternalProfiles, this.request, this);
            resultModel = DefaultModelBuilder.this.interpolateModel(resultModel, this.request, this);
            resultModel = DefaultModelBuilder.this.modelUrlNormalizer.normalize(resultModel, this.request);
            if (!resultModel.getRepositories().isEmpty()) {
                List<String> oldRepos = this.repositories.stream().map(Object::toString).toList();
                this.mergeRepositories(resultModel.getRepositories(), true);
                List<String> newRepos = this.repositories.stream().map(Object::toString).toList();
                if (!Objects.equals(oldRepos, newRepos)) {
                    DefaultModelBuilder.this.logger.debug("Replacing repositories from " + resultModel.getId() + "\n" + newRepos.stream().map(s -> "    " + s).collect(Collectors.joining("\n")));
                }
            }
            return resultModel;
        }

        private List<Profile> getActiveProfiles(Collection<Profile> interpolatedProfiles, DefaultProfileActivationContext profileActivationContext) {
            if (this.request.getRequestType() != ModelBuilderRequest.RequestType.CONSUMER_POM) {
                return DefaultModelBuilder.this.profileSelector.getActiveProfiles(interpolatedProfiles, profileActivationContext, this);
            }
            return List.of();
        }

        Model readFileModel() throws ModelBuilderException {
            Model model = this.cache((Source)this.request.getSource(), DefaultModelBuilder.FILE, this::doReadFileModel);
            this.result.setFileModel(model);
            return model;
        }

        Model doReadFileModel() throws ModelBuilderException {
            String namespace;
            Model model;
            Path rootDirectory;
            ModelSource modelSource;
            block54: {
                modelSource = this.request.getSource();
                this.setSource(modelSource.getLocation());
                DefaultModelBuilder.this.logger.debug("Reading file model from " + modelSource.getLocation());
                try {
                    InputSource v4src;
                    boolean strict = this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_POM;
                    try {
                        rootDirectory = this.request.getSession().getRootDirectory();
                    }
                    catch (IllegalStateException ignore) {
                        for (rootDirectory = modelSource.getPath(); rootDirectory != null && !Files.isDirectory(rootDirectory, new LinkOption[0]); rootDirectory = rootDirectory.getParent()) {
                        }
                    }
                    try (InputStream is = modelSource.openStream();){
                        model = DefaultModelBuilder.this.modelProcessor.read(XmlReaderRequest.builder().strict(strict).location(modelSource.getLocation()).path(modelSource.getPath()).rootDirectory(rootDirectory).inputStream(is).build());
                    }
                    catch (XmlReaderException e) {
                        if (!strict) {
                            throw e;
                        }
                        try (InputStream is2 = modelSource.openStream();){
                            model = DefaultModelBuilder.this.modelProcessor.read(XmlReaderRequest.builder().strict(false).location(modelSource.getLocation()).path(modelSource.getPath()).rootDirectory(rootDirectory).inputStream(is2).build());
                        }
                        catch (XmlReaderException ne) {
                            throw e;
                        }
                        this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, "Malformed POM " + modelSource.getLocation() + ": " + e.getMessage(), (Exception)((Object)e));
                    }
                    InputLocation loc = model.getLocation((Object)"");
                    InputSource inputSource = v4src = loc != null ? loc.getSource() : null;
                    if (v4src == null) break block54;
                    try {
                        Field field = InputSource.class.getDeclaredField("modelId");
                        field.setAccessible(true);
                        field.set(v4src, ModelProblemUtils.toId(model));
                    }
                    catch (Throwable t) {
                        throw new IllegalStateException("Unable to set modelId on InputSource", t);
                    }
                }
                catch (XmlReaderException e) {
                    this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "Non-parseable POM " + modelSource.getLocation() + ": " + e.getMessage(), (Exception)((Object)e));
                    throw this.newModelBuilderException();
                }
                catch (IOException e) {
                    String msg = e.getMessage();
                    if (msg == null || msg.isEmpty()) {
                        msg = e.getClass().getName().endsWith("MalformedInputException") ? "Some input bytes do not match the file encoding." : e.getClass().getSimpleName();
                    }
                    this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "Non-readable POM " + modelSource.getLocation() + ": " + msg, e);
                    throw this.newModelBuilderException();
                }
            }
            if (model.getModelVersion() == null && (namespace = model.getNamespaceUri()) != null && namespace.startsWith(DefaultModelBuilder.NAMESPACE_PREFIX)) {
                model = model.withModelVersion(namespace.substring(DefaultModelBuilder.NAMESPACE_PREFIX.length()));
            }
            if (this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_POM || this.request.getRequestType() == ModelBuilderRequest.RequestType.CONSUMER_POM) {
                Parent parent = (model = model.withPomFile(modelSource.getPath())).getParent();
                if (parent != null) {
                    String groupId = parent.getGroupId();
                    String artifactId = parent.getArtifactId();
                    String version = parent.getVersion();
                    String path = parent.getRelativePath();
                    if (!(groupId != null && artifactId != null && version != null || path != null && path.isEmpty())) {
                        Path relativePath;
                        Path pomFile = model.getPomFile();
                        Path pomPath = pomFile.resolveSibling(relativePath = Paths.get(path != null ? path : "..", new String[0])).normalize();
                        if (Files.isDirectory(pomPath, new LinkOption[0])) {
                            pomPath = DefaultModelBuilder.this.modelProcessor.locateExistingPom(pomPath);
                        }
                        if (pomPath != null && Files.isRegularFile(pomPath, new LinkOption[0])) {
                            Model parentModel = this.derive(ModelSource.fromPath((Path)pomPath)).readFileModel();
                            String parentGroupId = DefaultModelBuilder.getGroupId(parentModel);
                            String parentArtifactId = parentModel.getArtifactId();
                            String parentVersion = DefaultModelBuilder.getVersion(parentModel);
                            if (!(groupId != null && !groupId.equals(parentGroupId) || artifactId != null && !artifactId.equals(parentArtifactId) || version != null && !version.equals(parentVersion))) {
                                model = model.withParent(parent.with().groupId(parentGroupId).artifactId(parentArtifactId).version(parentVersion).build());
                            } else {
                                this.mismatchRelativePathAndGA(model, parentGroupId, parentArtifactId);
                            }
                        } else if (!"4.0.0".equals(model.getModelVersion()) && path != null) {
                            this.wrongParentRelativePath(model);
                        }
                    }
                }
                if (DefaultModelBuilder.getSubprojects(model).isEmpty() && !"4.0.0".equals(model.getModelVersion()) && "pom".equals(model.getPackaging())) {
                    ArrayList<String> subprojects = new ArrayList<String>();
                    try (Stream<Path> files = Files.list(model.getProjectDirectory());){
                        for (Path f : files.toList()) {
                            Path subproject;
                            if (!Files.isDirectory(f, new LinkOption[0]) || (subproject = DefaultModelBuilder.this.modelProcessor.locateExistingPom(f)) == null) continue;
                            subprojects.add(f.getFileName().toString());
                        }
                        if (!subprojects.isEmpty()) {
                            model = model.withSubprojects(subprojects);
                        }
                    }
                    catch (IOException e) {
                        this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V41, "Error discovering subprojects", e);
                    }
                }
                HashMap<String, String> properties = new HashMap<String, String>();
                if (!Objects.equals(rootDirectory, model.getProjectDirectory())) {
                    Path rootModelPath = DefaultModelBuilder.this.modelProcessor.locateExistingPom(rootDirectory);
                    if (rootModelPath != null) {
                        Model rootModel = this.derive(ModelSource.fromPath((Path)rootModelPath)).readFileModel();
                        properties.putAll(rootModel.getProperties());
                    }
                } else {
                    properties.putAll(model.getProperties());
                }
                properties.putAll(this.session.getUserProperties());
                model = model.with().version(this.replaceCiFriendlyVersion(properties, model.getVersion())).parent(model.getParent() != null ? model.getParent().withVersion(this.replaceCiFriendlyVersion(properties, model.getParent().getVersion())) : null).build();
            }
            for (org.apache.maven.api.spi.ModelTransformer transformer : DefaultModelBuilder.this.transformers) {
                model = transformer.transformFileModel(model);
            }
            this.setSource(model);
            DefaultModelBuilder.this.modelValidator.validateFileModel(model, this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_POM ? 40 : 0, this.request, this);
            if (this.hasFatalErrors()) {
                throw this.newModelBuilderException();
            }
            return model;
        }

        Model readRawModel() throws ModelBuilderException {
            this.readFileModel();
            Model model = this.cache((Source)this.request.getSource(), DefaultModelBuilder.RAW, this::doReadRawModel);
            this.result.setRawModel(model);
            return model;
        }

        private Model doReadRawModel() throws ModelBuilderException {
            ModelBuilderRequest request = this.request;
            Model rawModel = this.readFileModel();
            if (!("4.0.0".equals(rawModel.getModelVersion()) || request.getRequestType() != ModelBuilderRequest.RequestType.BUILD_POM && request.getRequestType() != ModelBuilderRequest.RequestType.CONSUMER_POM)) {
                rawModel = this.transformFileToRaw(rawModel);
            }
            for (org.apache.maven.api.spi.ModelTransformer transformer : DefaultModelBuilder.this.transformers) {
                rawModel = transformer.transformRawModel(rawModel);
            }
            DefaultModelBuilder.this.modelValidator.validateRawModel(rawModel, request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_POM ? 40 : 0, request, this);
            if (this.hasFatalErrors()) {
                throw this.newModelBuilderException();
            }
            return rawModel;
        }

        Model readAsParentModel() {
            return this.cache((Source)this.request.getSource(), DefaultModelBuilder.PARENT, this::doReadAsParentModel);
        }

        private Model doReadAsParentModel() throws ModelBuilderException {
            Model raw = this.readRawModel();
            Model parentData = this.readParent(raw);
            Model parent = new DefaultInheritanceAssembler(new DefaultInheritanceAssembler.InheritanceModelMerger(){

                @Override
                protected void mergeModel_Modules(Model.Builder builder, Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
                }

                @Override
                protected void mergeModel_Subprojects(Model.Builder builder, Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
                }

                @Override
                protected void mergeModel_Profiles(Model.Builder builder, Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
                    builder.profiles(Stream.concat(source.getProfiles().stream(), target.getProfiles().stream()).map(p -> p.withModules(null).withSubprojects(null)).toList());
                }
            }).assembleModelInheritance(raw, parentData, this.request, this);
            return parent.withParent(null);
        }

        private Model importDependencyManagement(Model model, Collection<String> importIds) {
            DependencyManagement depMgmt = model.getDependencyManagement();
            if (depMgmt == null) {
                return model;
            }
            String importing = model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
            importIds.add(importing);
            ArrayList<DependencyManagement> importMgmts = null;
            ArrayList deps = new ArrayList(depMgmt.getDependencies());
            Iterator it = deps.iterator();
            while (it.hasNext()) {
                Dependency dependency = (Dependency)it.next();
                if (!"pom".equals(dependency.getType()) || !DefaultModelBuilder.IMPORT.equals(dependency.getScope()) || "bom".equals(dependency.getType())) continue;
                it.remove();
                DependencyManagement importMgmt = this.loadDependencyManagement(dependency, importIds);
                if (importMgmt == null) continue;
                if (importMgmts == null) {
                    importMgmts = new ArrayList<DependencyManagement>();
                }
                importMgmts.add(importMgmt);
            }
            importIds.remove(importing);
            model = model.withDependencyManagement(model.getDependencyManagement().withDependencies(deps));
            return DefaultModelBuilder.this.dependencyManagementImporter.importManagement(model, importMgmts, this.request, this);
        }

        private DependencyManagement loadDependencyManagement(Dependency dependency, Collection<String> importIds) {
            DependencyManagement importMgmt;
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            String version = dependency.getVersion();
            if (groupId == null || groupId.isEmpty()) {
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "'dependencyManagement.dependencies.dependency.groupId' for " + dependency.getManagementKey() + " is missing.", dependency.getLocation((Object)""));
                return null;
            }
            if (artifactId == null || artifactId.isEmpty()) {
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "'dependencyManagement.dependencies.dependency.artifactId' for " + dependency.getManagementKey() + " is missing.", dependency.getLocation((Object)""));
                return null;
            }
            if (version == null || version.isEmpty()) {
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "'dependencyManagement.dependencies.dependency.version' for " + dependency.getManagementKey() + " is missing.", dependency.getLocation((Object)""));
                return null;
            }
            String imported = groupId + ":" + artifactId + ":" + version;
            if (importIds.contains(imported)) {
                StringBuilder message = new StringBuilder("The dependencies of type=pom and with scope=import form a cycle: ");
                for (String modelId : importIds) {
                    message.append(modelId).append(" -> ");
                }
                message.append(imported);
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, message.toString());
                return null;
            }
            Model importModel = this.cache(groupId, artifactId, version, DefaultModelBuilder.IMPORT, () -> this.doLoadDependencyManagement(dependency, groupId, artifactId, version, importIds));
            DependencyManagement dependencyManagement = importMgmt = importModel != null ? importModel.getDependencyManagement() : null;
            if (importMgmt == null) {
                importMgmt = DependencyManagement.newInstance();
            }
            List exclusions = dependency.getExclusions();
            if (importMgmt != null && !exclusions.isEmpty()) {
                List dependencies = importMgmt.getDependencies().stream().filter(candidate -> exclusions.stream().noneMatch(exclusion -> DefaultModelBuilder.this.match((Exclusion)exclusion, (Dependency)candidate))).map(candidate -> DefaultModelBuilder.addExclusions(candidate, exclusions)).collect(Collectors.toList());
                importMgmt = importMgmt.withDependencies(dependencies);
            }
            return importMgmt;
        }

        private Model doLoadDependencyManagement(Dependency dependency, String groupId, String artifactId, String version, Collection<String> importIds) {
            DefaultModelBuilderResult importResult;
            Path sourcePath;
            Path rootDirectory;
            ModelSource importSource;
            try {
                importSource = this.resolveReactorModel(groupId, artifactId, version);
                if (importSource == null) {
                    importSource = DefaultModelBuilder.this.modelResolver.resolveModel(this.request.getSession(), this.repositories, dependency, new AtomicReference<Dependency>());
                }
            }
            catch (ModelBuilderException e) {
                StringBuilder buffer = new StringBuilder(256);
                buffer.append("Non-resolvable import POM");
                if (!DefaultModelBuilder.this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                    buffer.append(' ').append(ModelProblemUtils.toId(groupId, artifactId, version));
                }
                buffer.append(": ").append(e.getMessage());
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, buffer.toString(), dependency.getLocation((Object)""), (Exception)((Object)e));
                return null;
            }
            try {
                rootDirectory = this.request.getSession().getRootDirectory();
            }
            catch (IllegalStateException e) {
                rootDirectory = null;
            }
            if (this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_POM && rootDirectory != null && (sourcePath = importSource.getPath()) != null && sourcePath.startsWith(rootDirectory)) {
                this.add(BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, "BOM imports from within reactor should be avoided", dependency.getLocation((Object)""));
            }
            try {
                ModelBuilderRequest importRequest = ModelBuilderRequest.builder().session(this.request.getSession()).requestType(ModelBuilderRequest.RequestType.DEPENDENCY).systemProperties(this.request.getSystemProperties()).userProperties(this.request.getUserProperties()).source(importSource).repositories(this.repositories).build();
                DefaultModelBuilderSession modelBuilderSession = this.derive(importRequest);
                modelBuilderSession.buildEffectiveModel(importIds);
                importResult = modelBuilderSession.result;
            }
            catch (ModelBuilderException e) {
                e.getResult().getProblems().forEach(this::add);
                return null;
            }
            importResult.getProblems().forEach(this::add);
            Model importModel = importResult.getEffectiveModel();
            return importModel;
        }

        ModelSource resolveReactorModel(String groupId, String artifactId, String version) {
            Set<ModelSource> sources = this.mappedSources.get(new GAKey(groupId, artifactId));
            if (sources != null) {
                for (ModelSource source : sources) {
                    Model model = this.derive(source).readRawModel();
                    if (!Objects.equals(DefaultModelBuilder.getVersion(model), version)) continue;
                    return source;
                }
            }
            return null;
        }

        private <T> T cache(String groupId, String artifactId, String version, String tag, Supplier<T> supplier) {
            return this.cache.computeIfAbsent(groupId, artifactId, version, tag, supplier);
        }

        private <T> T cache(Source source, String tag, Supplier<T> supplier) {
            return this.cache.computeIfAbsent(source, tag, supplier);
        }

        private List<Profile> interpolateActivations(List<Profile> profiles, final DefaultProfileActivationContext context, final ModelProblemCollector problems) {
            if (profiles.stream().map(Profile::getActivation).noneMatch(Objects::nonNull)) {
                return profiles;
            }
            final Interpolator interpolator = (Interpolator)this.request.getSession().getService(Interpolator.class);
            class ProfileInterpolator
            extends MavenTransformer
            implements UnaryOperator<Profile> {
                ProfileInterpolator() {
                    super(s -> {
                        try {
                            Map<String, String> map1 = defaultProfileActivationContext.getUserProperties();
                            Map<String, String> map2 = defaultProfileActivationContext.getSystemProperties();
                            Function[] functionArray = new Function[2];
                            functionArray[0] = map1::get;
                            functionArray[1] = map2::get;
                            return interpolator2.interpolate(s, Interpolator.chain((Function[])functionArray));
                        }
                        catch (InterpolatorException e) {
                            modelProblemCollector.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, e.getMessage(), (Exception)((Object)e));
                            return s;
                        }
                    });
                }

                @Override
                public Profile apply(Profile p) {
                    return Profile.newBuilder((Profile)p).activation(this.transformActivation(p.getActivation())).build();
                }

                @Override
                protected ActivationFile.Builder transformActivationFile_Missing(Supplier<? extends ActivationFile.Builder> creator, ActivationFile.Builder builder, ActivationFile target) {
                    String path = target.getMissing();
                    String xformed = this.transformPath(path, target, "missing");
                    return xformed != path ? (builder != null ? builder : creator.get()).missing(xformed) : builder;
                }

                @Override
                protected ActivationFile.Builder transformActivationFile_Exists(Supplier<? extends ActivationFile.Builder> creator, ActivationFile.Builder builder, ActivationFile target) {
                    String path = target.getExists();
                    String xformed = this.transformPath(path, target, "exists");
                    return xformed != path ? (builder != null ? builder : creator.get()).exists(xformed) : builder;
                }

                private String transformPath(String path, ActivationFile target, String locationKey) {
                    try {
                        return DefaultModelBuilder.this.profileActivationFilePathInterpolator.interpolate(path, context);
                    }
                    catch (InterpolatorException e) {
                        problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Failed to interpolate file location " + path + ": " + e.getMessage(), target.getLocation((Object)locationKey), (Exception)((Object)e));
                        return path;
                    }
                }
            }
            return profiles.stream().map(new ProfileInterpolator()).toList();
        }
    }

    record GAKey(String groupId, String artifactId) {
    }
}

